/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.math.BigDecimal;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.keypad.DoubleModel;
import ordermate.gui.keypad.IntModel;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.keypad.LongIntModel;
import ordermate.gui.keypad.PinModel;
import ordermate.gui.keypad.PriceModel;
import ordermate.gui.keypad.Renderer;
import ordermate.gui.keypad.StringModel;
import ordermate.gui.themes.OrderMateTheme;

public class KeypadDialog
extends JPanel {
    private JPanel labelHolder;
    private JLabel unitLabel = new JLabel();
    private JLabel valueLabel;
    protected Keypad keypad;
    private static final int LABEL_PAD = 15;

    public KeypadDialog() {
        this(new Keypad.KeypadBuilder().build(), 0);
    }

    public KeypadDialog(Keypad useKeypad, int align) {
        this.unitLabel.setFont(OrderMateTheme.getMediumFont());
        this.valueLabel = new JLabel();
        this.valueLabel.setFont(OrderMateTheme.getMediumFont());
        this.labelHolder = new JPanel();
        this.keypad = useKeypad;
        useKeypad.setLabel(this.valueLabel);
        if (this.keypad.isLabelInline()) {
            this.labelHolder.setLayout(new BoxLayout(this.labelHolder, 1));
            this.labelHolder.setAlignmentY(0.5f);
            this.labelHolder.add(this.unitLabel);
            this.labelHolder.add(this.valueLabel);
            this.unitLabel.setVerticalAlignment(0);
            this.unitLabel.setHorizontalAlignment(0);
            this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(12, 1)));
            this.add((Component)this.labelHolder, new Rectangle(0, 0, 1, 1));
            this.add((Component)this.keypad, new Rectangle(1, 0, 11, 1));
        } else {
            this.labelHolder.setLayout(new BoxLayout(this.labelHolder, 0));
            this.labelHolder.add(this.unitLabel);
            this.labelHolder.add(Box.createHorizontalStrut(15));
            this.labelHolder.add(this.valueLabel);
            this.setLayout(new BorderLayout());
            this.add((Component)this.labelHolder, "North");
            this.add((Component)this.keypad, "Center");
        }
    }

    public String getValue() {
        return this.keypad.getValue();
    }

    public String getValueAsString() {
        return this.keypad.getValueAsString();
    }

    public int getValueAsInt() {
        return this.keypad.getValueAsInt();
    }

    public double getValueAsDouble() {
        return this.keypad.getValueAsDouble();
    }

    public BigDecimal getValueAsBigDecimal() {
        return this.keypad.getValueAsBigDecimal();
    }

    public String getValueAsPrice() {
        return this.keypad.getValueAsPrice();
    }

    public void setUnits(String units) {
        this.unitLabel.setText(units);
    }

    public void setLabelForeground(Color value) {
        this.unitLabel.setForeground(value);
        this.valueLabel.setForeground(value);
    }

    public void setMaxChars(int maxChars) {
        this.keypad.setMaximumValue(maxChars);
    }

    public void setValue(String newValue) {
        this.keypad.setValue(newValue);
    }

    public void setup(boolean showDecimal) {
        if (showDecimal) {
            this.keypad.setDecimalButtonVisible(true);
            this.keypad.setModel((KeypadModel)new DoubleModel());
            this.keypad.setRenderer(Keypad.DOUBLE_RENDERER);
        } else {
            this.keypad.setDecimalButtonVisible(false);
            this.keypad.setModel((KeypadModel)new IntModel());
            this.keypad.setRenderer(Keypad.INT_RENDERER);
        }
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(false);
        this.keypad.resetModel();
    }

    public void setRenderer(Renderer renderer) {
        this.keypad.setRenderer(renderer);
    }

    public void setupLongInt(boolean showDecimal, int maxNumbFigures) {
        if (showDecimal) {
            this.keypad.setDecimalButtonVisible(true);
            this.keypad.setModel((KeypadModel)new DoubleModel());
            this.keypad.setRenderer(Keypad.DOUBLE_RENDERER);
        } else {
            this.keypad.setDecimalButtonVisible(false);
            this.keypad.setModel((KeypadModel)new LongIntModel(maxNumbFigures));
            this.keypad.setRenderer(Keypad.INT_RENDERER);
        }
        this.keypad.setFirstPress(true);
        this.keypad.setOverwrite(false);
        this.keypad.resetModel();
    }

    public void setOverwriteValue(boolean doOverwrite) {
        this.keypad.setOverwrite(doOverwrite);
    }

    public void pinInput(boolean maskPin) {
        if (maskPin) {
            this.keypad.setRenderer(Keypad.PASSWORD_RENDERER);
        } else {
            this.keypad.setRenderer(Keypad.DOUBLE_RENDERER);
        }
        this.keypad.setModel((KeypadModel)new PinModel());
    }

    public void priceInput() {
        this.keypad.setDecimalButtonVisible(true);
        this.keypad.setModel((KeypadModel)new PriceModel());
        this.keypad.setRenderer(Keypad.PRICE_RENDERER);
        this.keypad.setOverwrite(false);
        this.keypad.setFirstPress(true);
    }

    public void doubleInput() {
        this.doubleInput(10);
    }

    public void doubleInput(int numCharsPreDecimalPoint) {
        this.keypad.setDecimalButtonVisible(true);
        this.keypad.setModel((KeypadModel)new DoubleModel(numCharsPreDecimalPoint));
        this.keypad.setRenderer(Keypad.DOUBLE_RENDERER);
        this.keypad.setOverwrite(false);
        this.keypad.setFirstPress(true);
    }

    public void phoneInput() {
        this.keypad.setRenderer(Keypad.PHONE_RENDERER);
    }

    public void stringInput() {
        this.keypad.setModel((KeypadModel)new StringModel());
    }

    public void intInput() {
        this.keypad.setFirstPress(true);
        this.keypad.setModel((KeypadModel)new IntModel());
    }

    public void longIntInput(int maxNumbFigures) {
        this.keypad.setFirstPress(true);
        this.keypad.setModel((KeypadModel)new LongIntModel(maxNumbFigures));
    }

    public void percentageInput() {
        this.keypad.setRenderer(Keypad.PERCENTAGE_RENDERER);
    }

    public boolean getFirstPressQuantityFlag() {
        return this.keypad.getFirstPress();
    }

    public void setFirstPressQuantityFlag(boolean setIt) {
        this.keypad.setFirstPress(setIt);
    }

    public void setKeypadLabelInline(boolean inline) {
        this.keypad.setLabelInline(inline);
    }

    @Override
    public void setOpaque(boolean value) {
        super.setOpaque(value);
        if (this.keypad != null) {
            this.keypad.setOpaque(value);
            this.valueLabel.setOpaque(value);
            this.unitLabel.setOpaque(value);
            this.labelHolder.setOpaque(value);
        }
    }
}

