/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import waitermate.guikit.dialogs.OnePressPopupWindow;

public class ObjectPopupWindow<T> {
    private T selectedObject;
    private final Map<JButton, T> buttonMap;
    OnePressPopupWindow popupWindow;

    public ObjectPopupWindow(String text, List<T> objects, int columns, int rows, boolean allowCancel) {
        this(text, objects, columns, rows, allowCancel, null);
    }

    public ObjectPopupWindow(String text, List<T> objects, int columns, int rows, boolean allowCancel, ObjectDisplayableLabelStrategy<T> strategy) {
        List<JButton> buttons = this.makeButtons(objects, strategy);
        this.buttonMap = new LinkedHashMap<JButton, T>();
        for (int i = 0; i < objects.size(); ++i) {
            this.buttonMap.put(buttons.get(i), objects.get(i));
        }
        this.popupWindow = new OnePressPopupWindow(text, buttons, columns, rows, allowCancel);
        this.selectedObject = null;
    }

    private List<JButton> makeButtons(List<T> objects, ObjectDisplayableLabelStrategy<T> labelStrategy) {
        ArrayList<JButton> toReturn = new ArrayList<JButton>();
        for (T o : objects) {
            String label = labelStrategy != null ? labelStrategy.getDisplayableLabel(o) : o.toString();
            JButton toAdd = new JButton(label);
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    private ObjectPopupWindow(ObjectPopupWindowBuilder<T> builder) {
        this.buttonMap = ((ObjectPopupWindowBuilder)builder).buttonMap;
        this.popupWindow = new OnePressPopupWindow(((ObjectPopupWindowBuilder)builder).text, ((ObjectPopupWindowBuilder)builder).buttonMap.keySet(), ((ObjectPopupWindowBuilder)builder).columns, ((ObjectPopupWindowBuilder)builder).rows, ((ObjectPopupWindowBuilder)builder).allowCancel);
        this.selectedObject = null;
    }

    public T start() {
        this.selectedObject = null;
        this.popupWindow.setPreferredSize(new Dimension(300, 280));
        JButton selectedButton = this.popupWindow.start();
        if (selectedButton != null) {
            this.selectedObject = this.buttonMap.get(selectedButton);
        }
        return this.selectedObject;
    }

    public OnePressPopupWindow getPopupWindow() {
        return this.popupWindow;
    }

    public static class ObjectPopupWindowBuilder<U> {
        private final ObjectDisplayableLabelStrategy<U> labelStrategy;
        private final String text;
        private final int columns;
        private final int rows;
        private final Map<JButton, U> buttonMap;
        private boolean allowCancel;

        public ObjectPopupWindowBuilder(String text, int columns, int rows, ObjectDisplayableLabelStrategy<U> labelStrategy) {
            this.text = text;
            this.columns = columns;
            this.rows = rows;
            this.labelStrategy = labelStrategy;
            this.buttonMap = new LinkedHashMap<JButton, U>();
            this.allowCancel = false;
        }

        public ObjectPopupWindowBuilder<U> setAllowCancel(boolean allowCancel) {
            this.allowCancel = allowCancel;
            return this;
        }

        public ObjectPopupWindowBuilder<U> addSelectionButton(U data) {
            return this.addSelectionButton(data, true);
        }

        public ObjectPopupWindowBuilder<U> addSelectionButton(U data, boolean enabled) {
            String label = this.labelStrategy != null ? this.labelStrategy.getDisplayableLabel(data) : data.toString();
            JButton button = new JButton(label);
            if (data instanceof Displayable) {
                button.setIcon(IconLoader.get((String)((Displayable)data).getIcon()));
                button.setHorizontalAlignment(2);
            }
            button.setEnabled(enabled);
            this.buttonMap.put(button, data);
            return this;
        }

        public ObjectPopupWindow<U> build() {
            return new ObjectPopupWindow(this);
        }
    }

    public static interface ObjectDisplayableLabelStrategy<T> {
        public String getDisplayableLabel(T var1);
    }
}

