/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.guicore.AbstractComponentDecorator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import ordermate.gui.dialogs.OnePressPopup;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.PopupWindow;

public class OnePressPopupWindow
extends CustomScrollPane
implements ActionListener,
OnePressPopup {
    protected JButton selectedButton;
    private List<JButton> buttonList;
    protected PopupWindow parentWindow = new PopupWindow();
    private boolean isCloseWindow = true;

    public OnePressPopupWindow(String text, Collection<? extends JButton> buttons, int columns, int rows) {
        this(text, buttons, columns, rows, false);
    }

    public OnePressPopupWindow(String text, Collection<? extends JButton> buttons, int columns, int rows, boolean allowCancel) {
        this(text, buttons, columns, rows, false, allowCancel);
    }

    public OnePressPopupWindow(String text, Collection<? extends JButton> buttons, int columns, int rows, boolean hasClearButton, boolean allowCancel) {
        super((CustomScrollPaneModel)new DefaultScrollPaneModel(columns, rows));
        this.parentWindow.setOkButtonVisible(false);
        this.parentWindow.setText(text);
        this.parentWindow.setComponent(this.getMainArea((JComponent)((Object)this)));
        this.parentWindow.setCancelButtonText(Internationalization.getLiteralFor((String)"CANCEL"));
        this.parentWindow.setCancelButtonVisible(allowCancel);
        if (hasClearButton) {
            this.parentWindow.getNavBar().addRight(this.parentWindow.getNavBar().getClearButton());
            this.parentWindow.clear.connect((Object)this, "gotClear");
        }
        ((DefaultScrollPaneModel)this.getModel()).setItems(buttons);
        this.buttonList = new ArrayList<JButton>();
        for (JButton jButton : buttons) {
            JButton button;
            if (jButton instanceof AbstractComponentDecorator) {
                button = (JButton)((AbstractComponentDecorator)jButton).getDecorateComponent();
                this.buttonList.add(button);
            } else if (jButton instanceof JButton) {
                button = jButton;
                this.buttonList.add(button);
            } else {
                throw new IllegalArgumentException("You must pass in a list of JButtons");
            }
            button.addActionListener(this);
        }
    }

    public JComponent getMainArea(JComponent scrollPane) {
        return scrollPane;
    }

    public JButton start() {
        this.selectedButton = null;
        this.parentWindow.start();
        return this.selectedButton;
    }

    protected PopupWindow getParentWindow() {
        return this.parentWindow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (this.buttonList.contains(e.getSource())) {
            this.selectedButton = (JButton)e.getSource();
            if (this.isCloseWindow) {
                this.parentWindow.stop();
            }
        }
    }

    public List<JButton> getButtons() {
        return this.buttonList;
    }

    public void gotClear() {
        this.selectedButton = new JButton("");
        this.parentWindow.stop();
    }

    public boolean isCloseWindow() {
        return this.isCloseWindow;
    }

    public void setCloseWindow(boolean isCloseWindow) {
        this.isCloseWindow = isCloseWindow;
    }
}

