/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenResource;

public class PopupWindow
extends JPanel
implements AncestorListener {
    public static final int BORDER_SPACE = 30;
    private static final int ALMOST_FULLSCREEN_OFFSET = 50;
    private boolean result;
    private Point displayLocation;
    private NavBar navBar;
    private JPanel mainArea;
    private JComponent component;
    public Signal visibleSignal = Signals.createSignal(Boolean.class, (String)"isVisible");
    public final Signal clear = Signals.createSignal();
    public boolean baseDialog = false;

    public PopupWindow() {
        this(new NavBar());
        this.navBar.addLeft(this.navBar.getBackButton());
        this.navBar.getBackButton().setVisible(false);
        this.navBar.addLeft(this.navBar.getCancelButton());
        this.navBar.addRight(this.navBar.getOkButton());
        this.setCancelButtonText(Internationalization.getLiteralFor((String)"NO"));
    }

    public PopupWindow(NavBar nav) {
        this(nav, true);
    }

    public PopupWindow(boolean showBorder) {
        this(new NavBar(), showBorder);
        this.navBar.addLeft(this.navBar.getBackButton());
        this.navBar.getBackButton().setVisible(false);
        this.navBar.addRight(this.navBar.getClearButton());
        this.navBar.getClearButton().setVisible(false);
        this.navBar.addLeft(this.navBar.getCancelButton());
        this.navBar.addRight(this.navBar.getOkButton());
        this.setCancelButtonText(Internationalization.getLiteralFor((String)"NO"));
    }

    public PopupWindow(NavBar nav, boolean showBorder) {
        super(new BorderLayout());
        this.mainArea = new JPanel(new BorderLayout());
        if (showBorder) {
            this.mainArea.setBorder(new EmptyBorder(15, 30, 15, 30));
        }
        this.component = null;
        this.navBar = nav;
        this.add((Component)this.mainArea, "Center");
        this.add((Component)this.navBar, "South");
        this.navBar.ok.connect((Object)this, "gotOk");
        this.navBar.cancel.connect((Object)this, "gotCancel");
        this.navBar.back.connect((Object)this, "gotCancel");
        this.navBar.clear.connect((Object)this, "gotClear");
        this.addAncestorListener(this);
    }

    public final NavBar getNavBar() {
        return this.navBar;
    }

    public void disconnectNavBar() {
        this.navBar.ok.disconnect((Object)this);
        this.navBar.cancel.disconnect((Object)this);
        this.navBar.back.disconnect((Object)this);
        this.navBar.clear.disconnect((Object)this);
        this.remove(this.navBar);
    }

    public void setComponent(JComponent comp) {
        if (this.component != null) {
            this.mainArea.remove(this.component);
        }
        this.component = comp;
        if (comp != null) {
            this.mainArea.add((Component)this.component, "Center");
        }
    }

    public void setCancelButtonVisible(boolean isVisible) {
        this.navBar.getCancelButton().setVisible(isVisible);
    }

    public void setOkButtonVisible(boolean isVisible) {
        this.navBar.getOkButton().setVisible(isVisible);
    }

    public void setOkButtonEnable(boolean isEnable) {
        this.navBar.getOkButton().setEnabled(isEnable);
    }

    public void setBackButtonVisible(boolean isVisible) {
        this.navBar.getBackButton().setVisible(isVisible);
    }

    public void setClearButtonVisible(boolean isVisible) {
        this.navBar.getClearButton().setVisible(isVisible);
    }

    public void setText(String text) {
        this.navBar.setText(text);
    }

    public void setCancelButtonText(String text) {
        String buttonText = text;
        if (buttonText == null) {
            buttonText = "";
        }
        this.navBar.getCancelButton().setText(buttonText);
    }

    public void setOKButtonText(String text) {
        String buttonText = text;
        if (buttonText == null) {
            buttonText = "";
        }
        this.navBar.getOkButton().setText(buttonText);
    }

    public void setClearButtonText(String text) {
        String buttonText = text;
        if (buttonText == null) {
            buttonText = "";
        }
        this.navBar.getClearButton().setText(buttonText);
    }

    public void setCenterFont(Font newFont) {
        this.navBar.setCenterFont(newFont);
    }

    public boolean start() {
        ScreenResource.startModalWindow(this, this.displayLocation, this.baseDialog);
        return this.result;
    }

    public boolean startFillTheFrame() {
        Dimension dim = ScreenResource.getTarget().getSize();
        Dimension newDim = new Dimension(dim.width - 50, dim.height - 50);
        this.setPreferredSize(newDim);
        return this.start();
    }

    public boolean getResult() {
        return this.result;
    }

    public final void stop() {
        if (this.isShowing()) {
            ScreenResource.stopWindow(this);
        }
    }

    @Override
    public void setVisible(boolean value) {
        this.visibleSignal.emit((Object)value);
        super.setVisible(value);
    }

    public void gotOk() {
        this.result = true;
        this.stop();
    }

    public void gotCancel() {
        this.result = false;
        this.stop();
    }

    public void gotClear() {
        this.clear.emit();
    }

    public Point getDisplayLocation() {
        return this.displayLocation;
    }

    public void setDisplayLocation(Point value) {
        this.displayLocation = value;
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.visibleSignal.emit((Object)Boolean.TRUE);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.visibleSignal.emit((Object)Boolean.FALSE);
    }

    public boolean isBaseDialog() {
        return this.baseDialog;
    }

    public void setBaseDialog(boolean b) {
        this.baseDialog = b;
    }
}

