/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.guicore.task.ProgressBarConnector;
import au.com.ordermate.guicore.task.Task;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import ordermate.OrderMate;
import waitermate.guikit.ScreenResource;

public final class ProgressDialog
extends JPanel {
    private Task task;
    private JProgressBar progress;

    public static void doProgressDialog(Task task) {
        ProgressDialog dialog = new ProgressDialog(task);
        dialog.start();
    }

    public static ProgressDialog createProgressDialog(JDialog dialog, Task task) {
        ProgressDialog progDialog = new ProgressDialog(task);
        progDialog.setVisible(true);
        dialog.add(progDialog);
        dialog.pack();
        return progDialog;
    }

    public static JDialog doIndeterminateProgress(String taskName, Icon icon) {
        ProgressDialog progDialog = new ProgressDialog(taskName, icon);
        progDialog.setVisible(true);
        JDialog dialog = new JDialog();
        dialog.add(progDialog);
        dialog.setUndecorated(true);
        dialog.pack();
        dialog.setModal(false);
        dialog.setLocationRelativeTo(ScreenResource.getTarget());
        dialog.setVisible(true);
        return dialog;
    }

    private ProgressDialog(Task task) {
        this(task.getName(), task.getIcon());
        this.task = task;
        this.progress.setIndeterminate(false);
        this.progress.setStringPainted(true);
        ProgressBarConnector.connect((JProgressBar)this.progress, (Task)task);
    }

    private ProgressDialog(String taskName, Icon icon) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(30, 30, 30, 30));
        JLabel label = new JLabel(taskName);
        if (icon != null) {
            label.setIcon(icon);
        }
        this.add(label);
        this.add(Box.createVerticalStrut(30));
        this.progress = new JProgressBar();
        this.progress.setStringPainted(false);
        this.add(this.progress);
        this.progress.setIndeterminate(true);
    }

    private void start() {
        this.start(false);
    }

    public void start(boolean useCustomDialog) {
        this.task.done.connect((Object)this, "stop");
        this.task.exceptionSignal.connect((Object)this, "exceptionMethod");
        Thread taskThread = new Thread((Runnable)this.task, this.task.getName());
        taskThread.setPriority(1);
        taskThread.start();
        if (!useCustomDialog) {
            ScreenResource.startModalWindow(this);
        }
    }

    public void stop() throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            ScreenResource.stopWindow(this);
        } else {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ScreenResource.stopWindow(ProgressDialog.this);
                }
            });
        }
    }

    public void exceptionMethod(Exception ex) {
        try {
            this.stop();
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to stop the task and teardown the progress dialog!", (Throwable)ex);
        }
    }
}

