/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.gui.GraphPaperLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.requisition.StockItemQuantityHelper;
import ordermate.database.stock.requisition.StockRequisition;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.themes.OrderMateTheme;

public class StockItemQuantityDialog
extends JPanel
implements ActionListener {
    private JButton outerQtyButton;
    private JButton purchaseQtyButton;
    private JPanel buttonHolder;
    private JPanel quantityCalcHolder;
    private Keypad keypad;
    private StockRequisitionOrder order;
    private StockArea stockAreaTo;
    private StockArea stockAreaFrom;
    private StockItem item;
    private StockRequisition stockReq;
    private DecimalFormat decFormat = new DecimalFormat("0.###");
    private JLabel evalLabel;
    private JLabel stockNameLabel;
    private JLabel stockOnHandToLabel;
    private JLabel stockOnHandFromLabel;
    private JPanel plusPanel;
    private double outerQty;
    private double unitQty;
    private StockItemQuantityHelper helper = new StockItemQuantityHelper();
    private SelectedQuantity selected;

    public StockItemQuantityDialog() {
        this(new Keypad.KeypadBuilder().build());
    }

    public StockItemQuantityDialog(Keypad useKeypad) {
        this.outerQtyButton = new JButton();
        this.outerQtyButton.setFont(OrderMateTheme.getMediumFont());
        this.outerQtyButton.addActionListener(this);
        this.outerQtyButton.setMinimumSize(new Dimension(140, 40));
        this.outerQtyButton.setPreferredSize(new Dimension(140, 40));
        this.outerQtyButton.setName("outerQtyButton");
        this.purchaseQtyButton = new JButton();
        this.purchaseQtyButton.setFont(OrderMateTheme.getMediumFont());
        this.purchaseQtyButton.addActionListener(this);
        this.purchaseQtyButton.setMinimumSize(new Dimension(140, 40));
        this.purchaseQtyButton.setPreferredSize(new Dimension(140, 40));
        this.purchaseQtyButton.setName("purchaseQtyButton");
        this.quantityCalcHolder = new JPanel();
        this.quantityCalcHolder.setLayout(new BoxLayout(this.quantityCalcHolder, 1));
        this.buttonHolder = new JPanel((LayoutManager)new GraphPaperLayout(9, 1));
        JLabel plusLabel = new JLabel("+");
        plusLabel.setFont(OrderMateTheme.getMediumFont());
        this.plusPanel = new JPanel();
        plusLabel.setAlignmentX(0.5f);
        plusLabel.setAlignmentY(0.5f);
        this.plusPanel.setLayout(new FlowLayout(1));
        this.plusPanel.add(plusLabel);
        this.buttonHolder.add((Component)this.outerQtyButton, new Rectangle(0, 0, 4, 1));
        this.buttonHolder.add((Component)this.plusPanel, new Rectangle(4, 0, 1, 1));
        this.buttonHolder.add((Component)this.purchaseQtyButton, new Rectangle(5, 0, 4, 1));
        this.evalLabel = new JLabel("");
        this.evalLabel.setFont(OrderMateTheme.getMediumFont());
        this.stockNameLabel = new JLabel("");
        this.stockNameLabel.setFont(OrderMateTheme.getLargeFont());
        this.stockOnHandToLabel = new JLabel("****");
        this.stockOnHandToLabel.setFont(OrderMateTheme.getMediumFont());
        this.stockOnHandFromLabel = new JLabel("****");
        this.stockOnHandFromLabel.setFont(OrderMateTheme.getMediumFont());
        this.quantityCalcHolder.add(this.buildLabelPanel(this.stockNameLabel));
        this.quantityCalcHolder.add(this.buildLabelPanel(this.stockOnHandToLabel));
        this.quantityCalcHolder.add(this.buildLabelPanel(this.stockOnHandFromLabel));
        this.quantityCalcHolder.add(this.buttonHolder);
        this.quantityCalcHolder.add(Box.createHorizontalStrut(300));
        this.quantityCalcHolder.add(this.buildLabelPanel(this.evalLabel));
        this.keypad = useKeypad;
        this.keypad.updated.connect((Object)this, "gotKeypadUpdated");
        this.setLayout(new BorderLayout());
        this.add((Component)this.quantityCalcHolder, "North");
        this.add((Component)this.keypad, "Center");
    }

    private JPanel buildLabelPanel(JLabel toAdd) {
        JPanel toBuild = new JPanel();
        toBuild.add(toAdd);
        return toBuild;
    }

    public void setStockRequisitionOrder(StockRequisitionOrder toSet) {
        this.order = toSet;
    }

    public void setStockAreaTo(StockArea toArea) {
        this.stockAreaTo = toArea;
    }

    public void setStockAreaFrom(StockArea fromArea) {
        this.stockAreaFrom = fromArea;
    }

    public void setStockRequisition(StockRequisition stockReq) {
        this.stockReq = stockReq;
        this.item = stockReq.getStockItem();
        this.setupQuantityFields();
        this.updateQuantities();
        this.updateSelectedButton(this.purchaseQtyButton);
        this.updateStringFields();
    }

    private void updateStringFields() {
        this.stockNameLabel.setText(this.stockReq.getStockItem().getName());
        this.stockOnHandToLabel.setText(this.buildSOHLabel(this.stockAreaTo));
        this.stockOnHandFromLabel.setText(this.buildSOHLabel(this.stockAreaFrom));
    }

    private String buildSOHLabel(StockArea toGetSOHFrom) {
        StringBuilder SB = new StringBuilder();
        if (toGetSOHFrom == null) {
            return SB.toString();
        }
        SB.append("<html>");
        SB.append(toGetSOHFrom.toString());
        SB.append(" Stock On Hand: ");
        Quantity SOH = this.stockReq.getStockItem().getStockOnHand(toGetSOHFrom);
        String sohString = this.buildSOHString(this.stockReq.getStockItem(), SOH);
        if (SOH.doubleValue() <= 0.0) {
            SB.append("<span style=\"color:red\">");
            SB.append(sohString);
            SB.append("</span>");
        } else {
            SB.append(sohString);
        }
        SB.append("</html>");
        return SB.toString();
    }

    private String buildSOHString(StockItem item, Quantity SOH) {
        StringBuilder SB = new StringBuilder();
        double totalUnitQty = SOH.doubleValue();
        if (this.helper.hasOuterQty(item, totalUnitQty)) {
            SB.append(this.helper.getOuterDiplayString(item, totalUnitQty));
        }
        if (this.helper.hasOuterQty(item, totalUnitQty) && this.helper.hasUnitQty(item, totalUnitQty)) {
            SB.append(" and ");
        }
        if (this.helper.hasUnitQty(item, totalUnitQty) || !this.helper.hasOuterQty(item, totalUnitQty) && !this.helper.hasUnitQty(item, totalUnitQty)) {
            SB.append(this.helper.getUnitDisplayString(item, totalUnitQty));
        }
        return SB.toString();
    }

    private void setupQuantityFields() {
        this.unitQty = this.helper.getUnitQty(this.stockReq.getStockItem(), this.stockReq.getRawQuantity());
        this.outerQty = this.helper.getOuterQty(this.stockReq.getStockItem(), this.stockReq.getRawQuantity());
    }

    public Quantity getQty() {
        double totalQty = this.helper.getTotalQty(this.item, this.outerQty, this.unitQty);
        return new Quantity(this.item.getDisplayMeasureUnitContainer(), totalQty, false);
    }

    private void updateQuantities() {
        this.purchaseQtyButton.setText(new Quantity(this.item.getDisplayMeasureUnitContainer(), this.unitQty, false).toString());
        this.outerQtyButton.setText(new DecimalFormat("0.###").format(this.outerQty) + " " + this.item.getOuterDisplayName());
        this.outerQtyButton.setVisible(this.item.getOuterContainer() != null);
        this.plusPanel.setVisible(this.item.getOuterContainer() != null);
        this.validate();
        this.repaint();
    }

    private void updateSelectedButton(JButton button) {
        if (button.equals(this.outerQtyButton)) {
            this.selected = SelectedQuantity.OUTER;
            OrderMateTheme.setupToggledButton((AbstractButton)this.outerQtyButton);
            OrderMateTheme.setupUntoggledButton((AbstractButton)this.purchaseQtyButton);
            this.keypad.setValue("" + this.decFormat.format(this.outerQty));
        } else if (button.equals(this.purchaseQtyButton)) {
            this.selected = SelectedQuantity.PURCHASE;
            OrderMateTheme.setupUntoggledButton((AbstractButton)this.outerQtyButton);
            OrderMateTheme.setupToggledButton((AbstractButton)this.purchaseQtyButton);
            this.keypad.setValue("" + this.decFormat.format(this.unitQty));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.outerQtyButton) {
            this.updateSelectedButton(this.outerQtyButton);
        } else if (source == this.purchaseQtyButton) {
            this.updateSelectedButton(this.purchaseQtyButton);
        }
    }

    public void gotKeypadUpdated(String value) {
        double newRawValue = 0.0;
        if (value.trim().isEmpty()) {
            value = value + newRawValue;
        }
        try {
            newRawValue = Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            OrderMate.LOG.error("Unexpected keypad output in StockItemQuantityDialog.gotKeypadUpdated()", (Throwable)e);
        }
        this.setNewValue(newRawValue);
    }

    private void setNewValue(double newRawValue) {
        if (SelectedQuantity.OUTER.equals((Object)this.selected)) {
            this.outerQty = newRawValue;
        } else if (SelectedQuantity.PURCHASE.equals((Object)this.selected)) {
            this.unitQty = newRawValue;
        }
        this.updateQuantities();
    }

    static enum SelectedQuantity {
        PURCHASE,
        OUTER;

    }
}

