/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.showitem;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.Course;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.TableAccount;
import ordermate.internationalization.Internationalization;

public class ShowItemsDetails {
    static final int optionsIndent = 23;
    static final int componentIndent = 17;

    protected String getHTMLSpaces(int number) {
        StringBuilder SB = new StringBuilder();
        this.appendHTMLSpaces(SB, number);
        return SB.toString();
    }

    protected StringBuilder appendHTMLSpaces(StringBuilder SB, int number) {
        for (int i = 0; i < number; ++i) {
            SB.append("&nbsp;");
        }
        return SB;
    }

    public void getDetails(List<String> lines, ItemGroup currentGroup) {
        this.addDetails(lines, currentGroup);
        this.addTotal(lines, currentGroup);
        this.addDue(lines, currentGroup);
    }

    protected void addTotal(List<String> lines, ItemGroup currentGroup) {
        lines.add("");
        String totalString = SystemProperty.getInstance().isExTax() ? Internationalization.getLiteralFor((String)"TOTAL_INC_TAX") : Internationalization.getLiteralFor((String)"TOTAL");
        String totalHTML = "<b>" + totalString + Internationalization.getLiteralFor((String)"COLON") + " " + currentGroup.getTotal() + "</b>";
        lines.add(totalHTML);
    }

    protected void addDue(List<String> lines, ItemGroup currentGroup) {
        String dueHTML = Internationalization.getLiteralFor((String)"DUE") + " " + Internationalization.getLiteralFor((String)"COLON") + " " + currentGroup.getDue();
        lines.add(dueHTML);
    }

    protected void addDetails(List<String> lines, ItemGroup currentGroup) {
        if (currentGroup.usesSeatNums()) {
            this.doSeats(lines, currentGroup);
        } else {
            this.doCourses(lines, currentGroup);
        }
    }

    protected void doItems(List<String> lines, List<SalesLineItem> theItems) {
        int indentSpaces = 9;
        for (SalesLineItem lineItem : theItems) {
            for (SalesItem currentItem : lineItem.getSalesItems()) {
                List quantities = currentItem.getSalesItemQuantities();
                String currentText = this.getHTMLSpaces(9) + currentItem.getQuantity() + " " + currentItem.getLabel();
                if (quantities.size() == 1) {
                    SalesItemQuantity quantity = (SalesItemQuantity)quantities.get(0);
                    SimpleDateFormat format = new SimpleDateFormat("h:mm a dd/MM/yy");
                    String timeString = format.format(quantity.getCreationTime());
                    String userString = quantity.getUser().getLabel();
                    currentText = currentText + " - " + userString + " @ " + timeString;
                }
                lines.add(currentText);
                if (currentItem.getNotes() != null && currentItem.getNotes().length() > 0) {
                    lines.add(this.getHTMLSpaces(18) + currentItem.getNotes());
                }
                List theComponents = currentItem.getComponentList();
                for (SalesComponent currentComponent : theComponents) {
                    if (!currentComponent.hasMinuses() && !currentComponent.hasPlusses() && !currentComponent.hasOption()) continue;
                    this.doComponent(lines, currentComponent, theComponents.size() > 1);
                }
                if (quantities.size() <= 1) continue;
                this.doItemQuantities(lines, (SalesLineItem)currentItem);
            }
        }
    }

    protected void doItemQuantities(List<String> lines, SalesLineItem item) {
        List quantities = item.getSalesItemQuantities();
        for (int i = 0; i < quantities.size(); ++i) {
            SalesItemQuantity qty = (SalesItemQuantity)quantities.get(i);
            String qtyString = quantities.size() > 1 ? "" + qty.getQuantity() : "";
            Date time = qty.getCreationTime();
            String timeString = new SimpleDateFormat("h:mm a dd/MM/yy").format(time);
            String userStr = qty.getUser() != null ? qty.getUser().getName() : "";
            String currentText = this.getHTMLSpaces(26) + qtyString + " " + userStr + " @ " + timeString;
            lines.add(currentText);
        }
    }

    protected void doComponent(List<String> lines, SalesComponent currentComponent, boolean printComponentName) {
        StringBuilder SB;
        if (printComponentName) {
            SB = new StringBuilder();
            this.appendHTMLSpaces(SB, 17).append(currentComponent.getLabel());
            lines.add(SB.toString());
        }
        if (currentComponent.hasOption()) {
            for (SalesOption nextOption : currentComponent.getCurrentOptions()) {
                SB = new StringBuilder();
                this.appendHTMLSpaces(SB, 23).append(nextOption.getLabel());
                lines.add(SB.toString());
            }
        }
        if (currentComponent.hasPlusses()) {
            for (SalesAdd nextPlus : currentComponent.getCurrentPluses()) {
                SB = new StringBuilder();
                this.appendHTMLSpaces(SB, 23).append("+").append(nextPlus.getModificationSize() != null ? nextPlus.getModificationSize().getAbbreviatedName() : "").append(" ").append(nextPlus.getLabel());
                lines.add(SB.toString());
            }
        }
        if (currentComponent.hasMinuses()) {
            for (AbstractSalesRemove nextRemove : currentComponent.getCurrentMinuses()) {
                SB = new StringBuilder("<font color=\"red\">");
                this.appendHTMLSpaces(SB, 23).append("-").append(nextRemove.getModificationSize() != null ? nextRemove.getModificationSize().getAbbreviatedName() : "").append(" ").append(nextRemove.getLabel()).append("</font>");
                lines.add(SB.toString());
            }
        }
    }

    private void doSeats(List<String> lines, ItemGroup currentGroup) {
        for (int seat = 0; seat < currentGroup.getNumPatrons() + 1; ++seat) {
            if (currentGroup.getItemHelper().getItems(0, seat).isEmpty() && currentGroup.getItemHelper().getItems(1, seat).isEmpty() && currentGroup.getItemHelper().getItems(2, seat).isEmpty()) continue;
            if (seat == 0) {
                lines.add("<font color=\"blue\">" + Internationalization.getLiteralFor((String)"ALL_COVERS") + "</font>");
            } else {
                lines.add("<font color=\"blue\">" + Internationalization.getLiteralFor((String)"COVER") + " " + seat + "</font>");
            }
            this.doCoursesWithSeats(lines, currentGroup, seat);
        }
    }

    private void doCoursesWithSeats(List<String> lines, ItemGroup currentGroup, int seat) {
        String[] courses = Course.getCourseNames();
        for (int course = 0; course < courses.length; ++course) {
            if (currentGroup.getItemHelper().getItems(course, seat).isEmpty()) continue;
            lines.add("<font color=\"green\">" + Internationalization.getLiteralFor((String)"COURSE") + " " + courses[course] + "</font>");
            this.doItems(lines, currentGroup.getItemHelper().getItems(course, seat));
        }
    }

    private void doCourses(List<String> lines, ItemGroup currentGroup) {
        String[] courses = Course.getCourseNames();
        for (int course = 0; course < courses.length; ++course) {
            if (currentGroup.getItemHelper().getItems(course).isEmpty()) continue;
            if (currentGroup instanceof TableAccount) {
                lines.add("<font color=\"green\">" + Internationalization.getLiteralFor((String)"COURSE") + " " + courses[course] + "</font>");
            }
            this.doItems(lines, currentGroup.getItemHelper().getItems(course));
        }
    }
}

