/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.showitem;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.DebtorTransactionGroupAdapter;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.sales.itemfilter.OrderableItemFilter;
import ordermate.database.users.AllPermissions;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.gui.SaveAccount;
import ordermate.gui.modify.security.StandardSecurityDecorator;
import ordermate.gui.scroll.HtmlReportPanel;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.NavBar;
import waitermate.guikit.actions.GoToExternalUrlAction;
import waitermate.guikit.actions.PrintExternalDocketAction;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;
import waitermate.guikit.showitem.EnhancedShowItemsDetails;
import waitermate.guikit.showitem.ShowItemsDetails;

public class ShowItemsUtils {
    private final SaveAccount saveAccount;

    public ShowItemsUtils() {
        this.saveAccount = null;
    }

    public ShowItemsUtils(SaveAccount yourSaveAccount) {
        this.saveAccount = yourSaveAccount;
    }

    public void showItems(ItemGroup toDisplay) {
        List sellables = ItemFilter.filterItems((List)toDisplay.getItems(), (ItemFilter[])new ItemFilter[]{new OrderableItemFilter()});
        if (sellables.isEmpty()) {
            Dialogs.displayOkDialog(Internationalization.getLiteralFor((String)"ACCOUNT_IS_EMPTY"), Internationalization.getLiteralFor((String)"EMPTY"));
        } else {
            JTabbedPane tab = new JTabbedPane();
            OrderMateTheme.setupTabbedPane((JTabbedPane)tab);
            tab.addTab("Order", this.getAccountDetailsComponent("Summary for " + toDisplay.getLabel(), toDisplay, true));
            tab.addTab("History", this.getAccountDetailsComponent("Summary for " + toDisplay.getLabel(), toDisplay, false));
            JTabbedPane component = tab;
            if (toDisplay instanceof OnlineAccount) {
                OnlineAccount online = (OnlineAccount)toDisplay;
                this.displayPopup(component, Internationalization.getLiteralFor((String)"ONLINE_ACCOUNT_SUMMARY"), online.getExtHRef(), online.getExtDocketHRef());
            } else {
                this.displayPopup(component);
            }
        }
    }

    private JComponent getAccountDetailsComponent(String name, ItemGroup toDisplay, boolean byCourse) {
        HtmlReportPanel text = new HtmlReportPanel("Summary for " + toDisplay.getLabel());
        ArrayList<String> lines = new ArrayList<String>();
        this.doAccountDetails(lines, toDisplay, byCourse);
        text.setListData(lines);
        return text;
    }

    public void showItemsOnPriceLevelChange(ItemGroup toDisplay) {
        if (toDisplay.getItems().isEmpty()) {
            Dialogs.displayOkDialog("0 items updated.", Internationalization.getLiteralFor((String)"ACCOUNT_IS_EMPTY"));
        } else {
            HtmlReportPanel text = new HtmlReportPanel(toDisplay.getItems().size() + " items updated.");
            ArrayList<String> lines = new ArrayList<String>();
            for (SalesLineItem item : toDisplay.getItems()) {
                lines.add(item.getQuantity().toString() + " - " + item.getLabel());
            }
            text.setListData(lines);
            this.displayPopup((JComponent)text);
        }
    }

    public void showDebtorFinanceTransactions(AbstractDebtor debtor, List<DebtorPayment> payments) {
        double total = 0.0;
        if (payments.size() == 0) {
            Dialogs.displayOkDialog(Internationalization.getLiteralFor((String)"NO_FINANCE_TRANSACTION_SELECTED"), Internationalization.getLiteralFor((String)"NOTHING_TO_DISPLAY"));
            return;
        }
        HtmlReportPanel text = new HtmlReportPanel("Debtor Finance Transactions");
        DebtorTransactionGroupAdapter itemGroup = new DebtorTransactionGroupAdapter(new DebtorPaymentAgent(debtor));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < payments.size(); ++i) {
            FinanceTransaction currentTran = payments.get(i).getFinanceTransaction();
            this.showFinanceTransaction(lines, currentTran);
            if (!"ACTIVE".equals(currentTran.getSystemState())) continue;
            itemGroup.addFinanceTransaction(currentTran);
            total += currentTran.getPaid().doubleValue();
            if (i >= payments.size() - 1) continue;
            char[] chars = new char[120];
            Arrays.fill(chars, '-');
            lines.add(new String(chars));
        }
        lines.add("");
        lines.add("<h1><FONT COLOR='GREEN'>" + Internationalization.getLiteralFor((String)"TOTAL") + Internationalization.getLiteralFor((String)"COLON") + " " + new Price(total).toString() + "</FONT></h1>");
        ArrayList<ItemGroup> groupList = new ArrayList<ItemGroup>();
        groupList.add((ItemGroup)itemGroup);
        text.setListData(lines);
        this.displayDebtorPopup((JComponent)text, Internationalization.getLiteralFor((String)"PAYMENT_DETAILS"), groupList);
    }

    private void showFinanceTransaction(List<String> lines, FinanceTransaction tran) {
        String titleHTML = "<h1>" + DateTimeUtils.getLongFormat().format(tran.getCreationTime()) + "&nbsp;&nbsp;&nbsp;<B>" + tran.getPaid().toString() + "</B>&nbsp;&nbsp;&nbsp; " + tran.getSubType().getLabel() + "</h1>";
        lines.add(titleHTML);
        if ("ACTIVE".equals(tran.getSystemState())) {
            if (tran.getPayoffGroup() != null) {
                ItemGroup account = tran.getPayoffGroup();
                String payOffLine = Internationalization.getLiteralFor((String)"PAY_OFF_SALE") + Internationalization.getLiteralFor((String)"COLON") + " " + account.getLabel();
                lines.add(payOffLine);
            } else {
                for (DebtorPayment currentPayment : tran.getDebtorPayments()) {
                    DebtorSale currentSale = currentPayment.getSale();
                    if (currentSale != null) {
                        String payOffLine = "<FONT SIZE= '+1'>" + Internationalization.getLiteralFor((String)"PAYS") + " " + currentPayment.getAmount() + " " + Internationalization.getLiteralFor((String)"OFF_SALE") + Internationalization.getLiteralFor((String)"COLON") + " </FONT>";
                        lines.add(payOffLine);
                        String labelWithFrigginHtmlInIt = currentSale.getLabel();
                        lines.add(labelWithFrigginHtmlInIt.substring(6, labelWithFrigginHtmlInIt.length() - 7));
                        continue;
                    }
                    lines.add(currentPayment.getAmount() + " " + Internationalization.getLiteralFor((String)"UNASSIGNED_PAYMENT"));
                }
            }
        } else {
            FinanceTransaction movedTxn;
            lines.add("<FONT SIZE= '+1'>" + tran.getSystemState() + "</FONT>");
            if ("MOVED".equals(tran.getSystemState()) && (movedTxn = (FinanceTransaction)PersistenceManager.getObject(FinanceTransaction.class, (String)Query.select(FinanceTransaction.class).equals(FinanceTransaction.Properties.MOVED_TRANSACTION, (Object)tran).active(FinanceTransaction.class).toString())) != null) {
                lines.add(String.valueOf(movedTxn.getPayoffGroup()));
            }
        }
        if (tran.getNote() != null) {
            lines.add(Internationalization.getLiteralFor((String)"NOTE") + Internationalization.getLiteralFor((String)"COLON") + " " + tran.getNote());
        }
    }

    public void showDebtorAccounts(List<DebtorSale> debtorSales) {
        if (debtorSales.size() == 0) {
            Dialogs.displayOkDialog(Internationalization.getLiteralFor((String)"NO_ACCOUNTS_SELECTED"), Internationalization.getLiteralFor((String)"EMPTY"));
            return;
        }
        ArrayList<Account> accounts = new ArrayList<Account>();
        HtmlReportPanel text = new HtmlReportPanel("Debtor Accounts");
        ArrayList<String> lines = new ArrayList<String>();
        for (DebtorSale sale : debtorSales) {
            Account currentGroup = sale.getSaleAccount();
            this.doAccountDetails(lines, (ItemGroup)currentGroup, false);
            this.doDebtorPayments(lines, DebtorSale.getDebtorPayments(Collections.singletonList(sale)));
            char[] chars = new char[120];
            Arrays.fill(chars, '-');
            lines.add(new String(chars));
            accounts.add(currentGroup);
        }
        this.doCustomer(lines, (ItemGroup)accounts.get(0));
        text.setListData(lines);
        this.displayDebtorPopup((JComponent)text, Internationalization.getLiteralFor((String)"ACCOUNT_SUMMARY"), DebtorSale.getSalesAccounts(debtorSales));
    }

    private void doDebtorPayments(List<String> lines, Collection<DebtorPayment> payments) {
        if (payments == null || payments.size() == 0) {
            return;
        }
        lines.add(Internationalization.getLiteralFor((String)"PAYMENTS"));
        for (DebtorPayment payment : payments) {
            lines.add(payment.formatPayment());
        }
    }

    private void displayPopup(JComponent toDisplay) {
        this.displayPopup(toDisplay, Internationalization.getLiteralFor((String)"ACCOUNT_SUMMARY"));
    }

    private void displayDebtorPopup(JComponent toDisplay, String navLabel, final List<ItemGroup> accounts) {
        PopupWindow popupWin = new PopupWindow(false);
        NavBar navBar = popupWin.getNavBar();
        navBar.removeLeft(navBar.getCancelButton());
        navBar.removeRight(navBar.getOkButton());
        if (this.saveAccount != null) {
            navBar.addRight(navBar.getPrintButton());
            navBar.getPrintButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowItemsUtils.this.saveAccount.printReceiptDockets(accounts);
                }
            });
        }
        this.addPrintEftposButton(accounts, navBar);
        navBar.addRight(navBar.getOkButton());
        navBar.setText(navLabel);
        popupWin.setComponent(toDisplay);
        popupWin.startFillTheFrame();
    }

    private void addPrintEftposButton(List<ItemGroup> groups, NavBar navBar) {
        boolean hasEftpos = false;
        for (ItemGroup itemGroup : groups) {
            hasEftpos = hasEftpos || itemGroup.hasEftposDockets();
        }
        if (!hasEftpos) {
            return;
        }
        final ArrayList allDockets = new ArrayList();
        for (ItemGroup group : groups) {
            allDockets.addAll(group.getEftposDockets());
        }
        JButton jButton = navBar.constructButton(IconLoader.get((String)"/waitermate/images/printEftpos.png"), Internationalization.getLiteralFor((String)"REPRINT_EFTPOS"), "printEftpos");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (FinanceTransactionDocket nextDocket : allDockets) {
                    try {
                        DocketProcessor.rePrintDocket((AbstractDocket)nextDocket);
                    }
                    catch (IOException ex) {
                        OrderMateLog.LOG.warn("Problem re-printing debtor eftpos docket.", (Throwable)ex);
                    }
                }
            }
        });
        StandardSecurityDecorator decorator = new StandardSecurityDecorator((JComponent)jButton, AllPermissions.PRINT_BILL);
        navBar.addRight((Component)decorator);
    }

    private void displayPopup(JComponent toDisplay, String navLabel) {
        this.displayPopup(toDisplay, navLabel, null, null);
    }

    private void displayPopup(JComponent toDisplay, String navLabel, String href, String docketHref) {
        PopupWindow popupWin = new PopupWindow(false);
        NavBar nav = popupWin.getNavBar();
        nav.removeLeft(nav.getCancelButton());
        nav.setText(navLabel);
        if (href != null && !href.isEmpty()) {
            nav.removeRight(nav.getOkButton());
            this.addHrefDocketButton(docketHref, nav);
            this.addHrefButton(href, nav);
            nav.addRight(nav.getOkButton());
        }
        popupWin.setComponent(toDisplay);
        popupWin.startFillTheFrame();
    }

    private void addHrefDocketButton(String docketHref, NavBar nav) {
        if (docketHref != null && !docketHref.isEmpty()) {
            nav.addRight(nav.constructButton(new PrintExternalDocketAction(docketHref)));
        }
    }

    private void addHrefButton(String href, NavBar nav) {
        if (href == null || href.isEmpty()) {
            nav.addRight(nav.constructButton(new GoToExternalUrlAction("Online Order", IconLoader.get((String)"/waitermate/images/browser.png"), href)));
        }
    }

    private void doAccountDetails(List<String> lines, ItemGroup currentGroup, boolean byCourse) {
        if (byCourse) {
            new EnhancedShowItemsDetails().getDetails(lines, currentGroup);
        } else {
            new ShowItemsDetails().getDetails(lines, currentGroup);
        }
        this.doCustomer(lines, currentGroup);
        this.doOnlineInfo(lines, currentGroup);
    }

    private void doOnlineInfo(List<String> lines, ItemGroup currentGroup) {
        AccountType type;
        Account account = currentGroup.getAccount();
        AccountType accountType = type = account == null ? null : account.getAccountType();
        if (AccountType.onlineDeliveryType.equals((Object)type) || AccountType.onlinePickupType.equals((Object)type)) {
            OnlineAccount onlineAccount = (OnlineAccount)account;
            if (currentGroup.getCustomer() != null) {
                Customer customer = currentGroup.getCustomer();
                this.addInfo(lines, Internationalization.getLiteralFor((String)"CUSTOMER_EMAIL") + Internationalization.getLiteralFor((String)"COLON") + " ", customer.getEmail());
            }
            this.addInfo(lines, Internationalization.getLiteralFor((String)"SOURCE") + Internationalization.getLiteralFor((String)"COLON") + " ", onlineAccount.getSource());
            this.addInfo(lines, Internationalization.getLiteralFor((String)"DOCKET_REFERENCE_NR") + Internationalization.getLiteralFor((String)"COLON") + " ", onlineAccount.getExtDocketHRef());
            this.addInfo(lines, Internationalization.getLiteralFor((String)"ORDER_ID") + Internationalization.getLiteralFor((String)"COLON") + " ", onlineAccount.getExtOrderID());
            String date = null;
            if (onlineAccount.getExtOrderDateTime() != null) {
                date = new SimpleDateFormat("dd/MM hh:mm").format(onlineAccount.getExtOrderDateTime());
            }
            this.addInfo(lines, Internationalization.getLiteralFor((String)"ORDER_TIME") + Internationalization.getLiteralFor((String)"COLON") + " ", date);
            if (onlineAccount.isExtPaidFlag()) {
                lines.add(Internationalization.getLiteralFor((String)"HAS_BEEN_PAID"));
            } else {
                lines.add(Internationalization.getLiteralFor((String)"NOT_PAID"));
            }
        }
    }

    private void addInfo(List<String> lines, String prefix, String info) {
        lines.add(prefix + (info != null ? info : " " + Internationalization.getLiteralFor((String)"NOT_SUPPLIED")));
    }

    private void doCustomer(List<String> lines, ItemGroup currentGroup) {
        if (currentGroup.hasCustomer()) {
            lines.add("");
            Customer customer = currentGroup.getCustomer();
            lines.add(Internationalization.getLiteralFor((String)"CUSTOMER") + Internationalization.getLiteralFor((String)"COLON") + " " + customer.getName());
            String phoneNumberLine = Internationalization.getLiteralFor((String)"PHONE_NUMBER") + Internationalization.getLiteralFor((String)"COLON") + " " + customer.getPrimaryPhoneNumber();
            String secondaryPhone = customer.getSecondaryPhoneNumber();
            if (secondaryPhone != null && secondaryPhone.length() > 0) {
                phoneNumberLine = phoneNumberLine + " " + Internationalization.getLiteralFor((String)"OR") + " " + secondaryPhone;
            }
            lines.add(phoneNumberLine);
            lines.add(Internationalization.getLiteralFor((String)"ADDRESS") + Internationalization.getLiteralFor((String)"COLON") + " " + customer.getAddress());
        }
    }
}

