/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.task;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.ProcessUtil;
import java.net.InetAddress;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;

public abstract class RestartXMateTask
extends AbstractTask {
    protected int getTotalSubTasks() {
        return 0;
    }

    public String getName() {
        return "Restart " + this.getAppName() + " Task";
    }

    protected abstract String getAppName();

    protected abstract String getJnlp();

    protected void performTask() throws Exception {
        InetAddress serverAddress = Terminal.getServerMateTerminal().getAddress();
        final String jnlpFile = "http://" + serverAddress.getHostAddress() + "/webstart/" + this.getJnlp() + ".jnlp";
        OrderMate.LOG.info("Restarting " + this.getAppName() + " with " + jnlpFile);
        Runnable restarter = new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessUtil.execJavaWSProcessImmediately((String)jnlpFile, null);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Could not start the " + RestartXMateTask.this.getAppName() + " application from " + jnlpFile, (Throwable)ex);
                }
            }
        };
        Thread thread = new Thread(restarter);
        thread.setDaemon(false);
        thread.start();
        this.done();
    }

    protected void done() {
        System.exit(0);
    }
}

