/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.vouchers;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.ChainPropertyAccessor;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.PropertiedObjectStringifier;
import java.util.Comparator;
import javax.swing.JComponent;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.users.User;
import ordermate.gui.scroll.HtmlReportPanel;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.NavBar;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class ShowVoucherUtils {
    private final GiftVoucher voucher;
    private final PropertiedObjectStringifier poStringfier;
    private static final String[] headers = new String[]{"Date", "Time", "Transaction Type", "User", "Terminal", "Transaction Amount", "Current Balance"};

    public ShowVoucherUtils(GiftVoucher theVoucher) {
        this.voucher = theVoucher;
        this.poStringfier = new PropertiedObjectStringifier();
    }

    public void showTransactionsReport() {
        HtmlReportPanel text = new HtmlReportPanel("Voucher Details");
        try {
            text.setData(HtmlUtils.html((String)this.buildHTMLReport()));
            this.displayPopup((JComponent)text, Internationalization.getLiteralFor((String)"VOUCHER_HISTORY"));
        }
        catch (Exception ex) {
            Dialogs.displayOkDialog("Error displaying voucher transactions!", "Error!");
        }
    }

    protected String buildHTMLReport() {
        StringBuilder sb = new StringBuilder();
        sb.append(HtmlUtils.newline((int)1));
        sb.append("Voucher ID: " + this.voucher.getUniqueId());
        sb.append(HtmlUtils.newline((int)2));
        SequentialComparator comp = new SequentialComparator();
        comp.addComparator((Comparator)new PropertyComparator(GiftVoucherTransaction.Properties.CREATION_DATE).negate());
        comp.addComparator((Comparator)new PropertyComparator(GiftVoucherTransaction.Properties.CREATION_TIME).negate());
        String data = HtmlUtils.table((String[][])this.poStringfier.getDisplayableData((PropertiedObject)this.voucher, (PropertyAccessor)GiftVoucher.Properties.TRANSACTIONS, (PropertyAccessor)GiftVoucherTransaction.Properties.SYSTEM_STATE, (Comparator)comp, headers, new PropertyAccessor[]{GiftVoucherTransaction.Properties.CREATION_DATE, GiftVoucherTransaction.Properties.CREATION_TIME, GiftVoucherTransaction.Properties.VOUCHER_TRANSACTION_TYPE, new ChainPropertyAccessor((PropertyAccessor[])new PropertiedObject.Property[]{GiftVoucherTransaction.Properties.USER, User.Properties.NAME}), new ChainPropertyAccessor((PropertyAccessor[])new PropertiedObject.Property[]{GiftVoucherTransaction.Properties.TERMINAL, Terminal.Properties.ADDRESS}), GiftVoucherTransaction.Properties.AMOUNT, GiftVoucherTransaction.Properties.VOUCHER_BALANCE}), (boolean)true, (boolean)true);
        sb.append(data);
        sb.append(HtmlUtils.newline((int)2));
        sb.append(HtmlUtils.boldColor((String)("Current Balance: " + this.voucher.getCachedValue()), (String)"black"));
        return sb.toString();
    }

    public void displayPopup(JComponent toDisplay, String navLabel) {
        PopupWindow popupWin = new PopupWindow(false);
        NavBar nav = popupWin.getNavBar();
        nav.removeLeft(nav.getCancelButton());
        nav.setText(navLabel);
        popupWin.setComponent(toDisplay);
        popupWin.startFillTheFrame();
    }

    String[] getHeaders() {
        return headers;
    }
}

