/*
 * Decompiled with CFR 0.152.
 */
package posiflex;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import posiflex.PosiflexRFIDWrapper;

public class PosiflexRFIDReader {
    private static final int success = 0;
    private static final int fail = 1;
    private static final PosiflexRFIDReader instance = new PosiflexRFIDReader();
    private ChangeListener listener;
    private String[] dllsRequired = new String[]{"PFXRFID.DLL", "PosiflexRFIDWrapper.dll", "libgcc_s_dw2-1.dll"};
    private ReaderThread reader;
    private Thread thread;
    private PosiflexRFIDWrapper wrapper;

    public static PosiflexRFIDReader getInstance() {
        return instance;
    }

    private PosiflexRFIDReader() {
        this.createDllsIfRequired();
        this.wrapper = new PosiflexRFIDWrapper();
    }

    private void createDllsIfRequired() {
        String userDir = System.getProperty("user.dir");
        String[] stringArray = this.dllsRequired;
        int n = this.dllsRequired.length;
        int n2 = 0;
        while (n2 < n) {
            String nextDll = stringArray[n2];
            File theFile = new File(String.valueOf(userDir) + File.separator + nextDll);
            if (!theFile.exists()) {
                this.copyToDisk(nextDll, theFile);
            }
            ++n2;
        }
    }

    private void copyToDisk(String dllName, File location) {
        InputStream input = this.getClass().getResourceAsStream("/dlls/" + dllName);
        OutputStream fout = null;
        if (input != null) {
            try {
                try {
                    location.createNewFile();
                    fout = new FileOutputStream(location);
                    int nextByte = input.read();
                    while (nextByte >= 0) {
                        ((FileOutputStream)fout).write(nextByte);
                        nextByte = input.read();
                    }
                }
                catch (IOException ex) {
                    System.out.println("Cannot write required dlls:" + ex);
                    try {
                        if (fout != null) {
                            fout.flush();
                            ((FileOutputStream)fout).close();
                        }
                        input.close();
                    }
                    catch (IOException ex2) {
                        System.out.println("Problem closing off the input or output files:" + ex2);
                    }
                }
            }
            finally {
                try {
                    if (fout != null) {
                        fout.flush();
                        ((FileOutputStream)fout).close();
                    }
                    input.close();
                }
                catch (IOException ex) {
                    System.out.println("Problem closing off the input or output files:" + ex);
                }
            }
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startReading() {
        PosiflexRFIDReader posiflexRFIDReader = this;
        synchronized (posiflexRFIDReader) {
            this.createAndStart();
        }
        return true;
    }

    private void createAndStart() {
        if (this.reader != null) {
            this.reader.finishUp();
        }
        this.reader = new ReaderThread();
        this.thread = new Thread(this.reader);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopReading() {
        PosiflexRFIDReader posiflexRFIDReader = this;
        synchronized (posiflexRFIDReader) {
            if (this.reader == null) {
                this.createAndStart();
            }
            this.reader.finishUp();
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class ReaderThread
    implements Runnable {
        private boolean run = true;
        private final int timeout = 1000;
        private byte[] buffer = new byte[512];
        private int prevSuccessState = 0;

        ReaderThread() {
        }

        @Override
        public void run() {
            int result = 0;
            PosiflexRFIDReader.this.wrapper.openReader();
            while (this.run) {
                result = PosiflexRFIDReader.this.wrapper.connectCard();
                result = PosiflexRFIDReader.this.wrapper.chkCard(this.buffer, 1000);
                if (result == 0 && PosiflexRFIDReader.this.listener != null) {
                    StringBuilder SB = new StringBuilder();
                    int i = 0;
                    while (i < this.buffer.length) {
                        if (this.buffer[i] == 0) break;
                        SB.append(" ").append((Object)this.buffer[i]);
                        ++i;
                    }
                    PosiflexRFIDReader.this.listener.stateChanged(new ChangeEvent(SB.toString().trim()));
                }
                result = PosiflexRFIDReader.this.wrapper.disconnect();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            PosiflexRFIDReader.this.wrapper.closeReader();
        }

        void finishUp() {
            this.run = false;
        }
    }
}

