/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi;

import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection {
    private static final Logger LOG = LoggerFactory.getLogger((String)"spi");
    private static final long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(4L);
    private EventHandler eventHandler;
    private State state;
    private String address;
    private WebSocket webSocket;
    private OkHttpClient httpClient;

    public Connection(String address) {
        this.address = address;
        this.state = State.DISCONNECTED;
        this.httpClient = new OkHttpClient.Builder().connectTimeout(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS).build();
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
        if (this.eventHandler != null) {
            this.eventHandler.onConnectionStateChanged(state);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void connect() {
        if (this.state == State.CONNECTED || this.state == State.CONNECTING) {
            return;
        }
        this.setState(State.CONNECTING);
        String prefix = "ws://";
        String address = this.getAddress();
        if (!address.startsWith("ws://")) {
            address = "ws://" + address;
        }
        this.webSocket = this.httpClient.newWebSocket(new Request.Builder().url(address).addHeader("Sec-WebSocket-Protocol", "spi.2.4.0").build(), new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                Connection.this.onOpen();
            }

            public void onMessage(WebSocket webSocket, String text) {
                Connection.this.onMessageReceived(text);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                Connection.this.onClose();
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                if (t instanceof SocketTimeoutException) {
                    t = new TimeoutException(CONNECTION_TIMEOUT);
                }
                Connection.this.onError(t);
                if (Connection.this.state == State.CONNECTING) {
                    Connection.this.onClose();
                }
            }
        });
    }

    public void send(String message) {
        this.webSocket.send(message);
    }

    public void disconnect() {
        if (this.state != State.DISCONNECTED) {
            this.closeSession(1001);
            this.onClose();
        }
    }

    public void dispose() {
        this.disconnect();
    }

    private void onOpen() {
        this.setState(State.CONNECTED);
    }

    private void onClose() {
        this.webSocket = null;
        this.setState(State.DISCONNECTED);
    }

    private void onMessageReceived(String message) {
        if (this.eventHandler != null) {
            this.eventHandler.onMessageReceived(message);
        }
    }

    private void onError(Throwable thr) {
        if (this.eventHandler != null) {
            this.eventHandler.onError(thr);
        }
    }

    private void closeSession(int code) {
        if (this.webSocket != null) {
            this.webSocket.close(code, null);
        }
    }

    public static class TimeoutException
    extends RuntimeException {
        private TimeoutException(long timeoutMillis) {
            super("Connection timeout of " + timeoutMillis + "ms has been reached.");
        }
    }

    public static interface EventHandler {
        public void onConnectionStateChanged(State var1);

        public void onMessageReceived(String var1);

        public void onError(Throwable var1);
    }

    public static enum State {
        CONNECTED,
        DISCONNECTED,
        CONNECTING;

    }
}

