/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi;

import com.assemblypayments.spi.Connection;
import com.assemblypayments.spi.SpiPayAtTable;
import com.assemblypayments.spi.SpiPreauth;
import com.assemblypayments.spi.model.AuthCodeAdvice;
import com.assemblypayments.spi.model.CancelTransactionRequest;
import com.assemblypayments.spi.model.CancelTransactionResponse;
import com.assemblypayments.spi.model.CashoutOnlyRequest;
import com.assemblypayments.spi.model.DeviceAddressStatus;
import com.assemblypayments.spi.model.DropKeysRequest;
import com.assemblypayments.spi.model.GetLastTransactionRequest;
import com.assemblypayments.spi.model.GetLastTransactionResponse;
import com.assemblypayments.spi.model.InitiateTxResult;
import com.assemblypayments.spi.model.KeyCheck;
import com.assemblypayments.spi.model.KeyRequest;
import com.assemblypayments.spi.model.KeyRollingResult;
import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.MessageStamp;
import com.assemblypayments.spi.model.MidTxResult;
import com.assemblypayments.spi.model.MotoPurchaseRequest;
import com.assemblypayments.spi.model.PairRequest;
import com.assemblypayments.spi.model.PairResponse;
import com.assemblypayments.spi.model.PairingFlowState;
import com.assemblypayments.spi.model.PayAtTableConfig;
import com.assemblypayments.spi.model.PhoneForAuthRequired;
import com.assemblypayments.spi.model.PrintingRequest;
import com.assemblypayments.spi.model.PurchaseRequest;
import com.assemblypayments.spi.model.RefundRequest;
import com.assemblypayments.spi.model.Secrets;
import com.assemblypayments.spi.model.SecretsAndKeyResponse;
import com.assemblypayments.spi.model.SetPosInfoRequest;
import com.assemblypayments.spi.model.SetPosInfoResponse;
import com.assemblypayments.spi.model.SettleRequest;
import com.assemblypayments.spi.model.SettlementEnquiryRequest;
import com.assemblypayments.spi.model.SignatureAccept;
import com.assemblypayments.spi.model.SignatureDecline;
import com.assemblypayments.spi.model.SignatureRequired;
import com.assemblypayments.spi.model.SpiConfig;
import com.assemblypayments.spi.model.SpiFlow;
import com.assemblypayments.spi.model.SpiStatus;
import com.assemblypayments.spi.model.SubmitAuthCodeResult;
import com.assemblypayments.spi.model.TerminalConfigurationRequest;
import com.assemblypayments.spi.model.TerminalStatusRequest;
import com.assemblypayments.spi.model.TransactionFlowState;
import com.assemblypayments.spi.model.TransactionOptions;
import com.assemblypayments.spi.model.TransactionType;
import com.assemblypayments.spi.service.DeviceService;
import com.assemblypayments.spi.util.Crypto;
import com.assemblypayments.spi.util.DeviceInfo;
import com.assemblypayments.spi.util.KeyRollingHelper;
import com.assemblypayments.spi.util.PairingHelper;
import com.assemblypayments.spi.util.PingHelper;
import com.assemblypayments.spi.util.PongHelper;
import com.assemblypayments.spi.util.PurchaseHelper;
import com.assemblypayments.spi.util.RequestIdHelper;
import java.security.GeneralSecurityException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spi {
    private static final Logger LOG = LoggerFactory.getLogger((String)"spi");
    static final String PROTOCOL_VERSION = "2.4.0";
    private static final long RECONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    private static final long TX_MONITOR_CHECK_FREQUENCY = TimeUnit.SECONDS.toMillis(1L);
    private static final long CHECK_ON_TX_FREQUENCY = TimeUnit.SECONDS.toMillis(20L);
    private static final long MAX_WAIT_FOR_CANCEL_TX = TimeUnit.SECONDS.toMillis(10L);
    private static final long PONG_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final long PING_FREQUENCY = TimeUnit.SECONDS.toMillis(18L);
    private String posId;
    private String eftposAddress;
    private String serialNumber;
    private String deviceApiKey;
    private String acquirerCode;
    private boolean inTestMode;
    private boolean autoAddressResolutionEnabled;
    private Secrets secrets;
    private MessageStamp spiMessageStamp;
    private String posVendorId;
    private String posVersion;
    private boolean hasSetInfo;
    private Connection conn;
    private SpiStatus currentStatus;
    private SpiFlow currentFlow;
    private PairingFlowState currentPairingFlowState;
    private TransactionFlowState currentTxFlowState;
    private DeviceAddressStatus currentDeviceStatus;
    private EventHandler<SpiStatus> statusChangedHandler;
    private EventHandler<PairingFlowState> pairingFlowStateChangedHandler;
    private EventHandler<TransactionFlowState> txFlowStateChangedHandler;
    private EventHandler<Secrets> secretsChangedHandler;
    private EventHandler<DeviceAddressStatus> deviceAddressChangedHandler;
    private PrintingResponseDelegate printingResponseDelegate;
    private TerminalStatusResponseDelegate terminalStatusResponseDelegate;
    private BatteryLevelChangedDelegate batteryLevelChangedDelegate;
    private TerminalConfigurationResponseDelegate terminalConfigurationResponseDelegate;
    private Message mostRecentPingSent;
    private long mostRecentPingSentTime;
    private Message mostRecentPongReceived;
    private int missedPongsCount;
    private int retriesSinceLastDeviceAddressResolution;
    private Thread periodicPingThread;
    private Thread transactionMonitoringThread;
    private final Object txLock;
    private final long missedPongsToDisconnect = 2L;
    private final int retriesBeforeResolvingDeviceAddress = 5;
    private SpiPayAtTable spiPat;
    private SpiPreauth spiPreauth;
    private ScheduledThreadPoolExecutor reconnectExecutor;
    private ScheduledFuture reconnectFuture;
    final SpiConfig config;

    public Spi(@NotNull String posId, @NotNull String serialNumber, @NotNull String eftposAddress, @Nullable Secrets secrets) throws CompatibilityException {
        if (posId == null) {
            Spi.$$$reportNull$$$0(0);
        }
        if (serialNumber == null) {
            Spi.$$$reportNull$$$0(1);
        }
        if (eftposAddress == null) {
            Spi.$$$reportNull$$$0(2);
        }
        this.retriesSinceLastDeviceAddressResolution = 0;
        this.txLock = new Object();
        this.missedPongsToDisconnect = 2L;
        this.retriesBeforeResolvingDeviceAddress = 5;
        this.config = new SpiConfig();
        try {
            Crypto.checkCompatibility();
            LOG.info("Compatibility check passed");
        }
        catch (GeneralSecurityException e) {
            throw new CompatibilityException("JDK configuration incompatible with SPI", e);
        }
        this.posId = posId;
        this.eftposAddress = "ws://" + eftposAddress;
        this.secrets = secrets;
        this.serialNumber = serialNumber;
        this.currentStatus = SpiStatus.UNPAIRED;
        this.currentFlow = SpiFlow.IDLE;
        this.spiMessageStamp = new MessageStamp(this.posId, this.secrets, 0L);
        this.mostRecentPingSent = null;
        this.mostRecentPongReceived = null;
        this.missedPongsCount = 0;
    }

    public SpiPayAtTable enablePayAtTable() {
        this.spiPat = new SpiPayAtTable(this);
        return this.spiPat;
    }

    public SpiPayAtTable disablePayAtTable() {
        this.spiPat = new SpiPayAtTable(this);
        this.spiPat.getConfig().setPayAtTableEnabled(false);
        return this.spiPat;
    }

    public SpiPreauth enablePreauth() {
        this.spiPreauth = new SpiPreauth(this, this.txLock);
        return this.spiPreauth;
    }

    public void start() {
        if (StringUtils.isBlank((String)this.posVendorId) || StringUtils.isBlank((String)this.posVersion)) {
            LOG.warn("Missing POS vendor ID and version. posVendorId and posVersion are required before starting");
            throw new IllegalArgumentException("Missing POS vendor ID and version. posVendorId and posVersion are required before starting");
        }
        this.reconnectExecutor = new ScheduledThreadPoolExecutor(5);
        this.reconnectFuture = null;
        this.resetConn();
        this.startTransactionMonitoring();
        this.setCurrentFlow(SpiFlow.IDLE);
        if (this.secrets != null) {
            LOG.info("Starting in paired state");
            this.currentStatus = SpiStatus.PAIRED_CONNECTING;
            this.conn.connect();
        } else {
            LOG.info("Starting in unpaired state");
            this.currentStatus = SpiStatus.UNPAIRED;
        }
    }

    public void setAcquirerCode(String acquirerCode) {
        this.acquirerCode = acquirerCode;
    }

    public void setDeviceApiKey(String deviceApiKey) {
        this.deviceApiKey = deviceApiKey;
    }

    public boolean setSerialNumber(String serialNumber) {
        if (this.getCurrentStatus() != SpiStatus.UNPAIRED) {
            return false;
        }
        String was = this.serialNumber;
        this.serialNumber = serialNumber;
        if (this.autoAddressResolutionEnabled && this.hasSerialNumberChanged(was)) {
            this.autoResolveEftposAddress();
        }
        return true;
    }

    public boolean setAutoAddressResolution(boolean autoAddressResolutionEnable) {
        if (this.getCurrentStatus() == SpiStatus.PAIRED_CONNECTED) {
            return false;
        }
        boolean was = this.autoAddressResolutionEnabled;
        this.autoAddressResolutionEnabled = autoAddressResolutionEnable;
        if (autoAddressResolutionEnable && !was) {
            this.autoResolveEftposAddress();
        }
        return true;
    }

    public boolean setTestMode(boolean testMode) {
        if (this.getCurrentStatus() != SpiStatus.UNPAIRED) {
            return false;
        }
        if (testMode == this.inTestMode) {
            return true;
        }
        this.inTestMode = testMode;
        this.autoResolveEftposAddress();
        return true;
    }

    public boolean setPosId(@NotNull String id) {
        if (id == null) {
            Spi.$$$reportNull$$$0(3);
        }
        if (this.getCurrentStatus() != SpiStatus.UNPAIRED) {
            return false;
        }
        this.posId = id;
        this.spiMessageStamp.setPosId(id);
        return true;
    }

    public boolean setEftposAddress(String address) {
        if (this.getCurrentStatus() == SpiStatus.PAIRED_CONNECTED || this.autoAddressResolutionEnabled) {
            return false;
        }
        this.eftposAddress = "ws://" + address;
        this.conn.setAddress(this.eftposAddress);
        return true;
    }

    public void setPosInfo(String posVendorId, String posVersion) {
        this.posVendorId = posVendorId;
        this.posVersion = posVersion;
    }

    @NotNull
    public static String getVersion() {
        if ("0.0.1-SNAPSHOT" == null) {
            Spi.$$$reportNull$$$0(4);
        }
        return "0.0.1-SNAPSHOT";
    }

    @NotNull
    public SpiStatus getCurrentStatus() {
        SpiStatus spiStatus = this.currentStatus;
        if (spiStatus == null) {
            Spi.$$$reportNull$$$0(5);
        }
        return spiStatus;
    }

    private void setCurrentStatus(@NotNull SpiStatus value) {
        if (value == null) {
            Spi.$$$reportNull$$$0(6);
        }
        if (this.currentStatus == value) {
            return;
        }
        this.currentStatus = value;
        this.statusChanged();
    }

    @NotNull
    public SpiFlow getCurrentFlow() {
        SpiFlow spiFlow = this.currentFlow;
        if (spiFlow == null) {
            Spi.$$$reportNull$$$0(7);
        }
        return spiFlow;
    }

    void setCurrentFlow(@NotNull SpiFlow value) {
        if (value == null) {
            Spi.$$$reportNull$$$0(8);
        }
        this.currentFlow = value;
    }

    public PairingFlowState getCurrentPairingFlowState() {
        return this.currentPairingFlowState;
    }

    private void setCurrentPairingFlowState(PairingFlowState state) {
        this.currentPairingFlowState = state;
    }

    public TransactionFlowState getCurrentTxFlowState() {
        return this.currentTxFlowState;
    }

    void setCurrentTxFlowState(TransactionFlowState state) {
        this.currentTxFlowState = state;
    }

    public DeviceAddressStatus getCurrentDeviceStatus() {
        return this.currentDeviceStatus;
    }

    private void setCurrentDeviceStatus(DeviceAddressStatus state) {
        this.currentDeviceStatus = state;
    }

    public void setStatusChangedHandler(@Nullable EventHandler<SpiStatus> handler) {
        this.statusChangedHandler = handler;
    }

    public void setPairingFlowStateChangedHandler(@Nullable EventHandler<PairingFlowState> handler) {
        this.pairingFlowStateChangedHandler = handler;
    }

    public void setTxFlowStateChangedHandler(@Nullable EventHandler<TransactionFlowState> handler) {
        this.txFlowStateChangedHandler = handler;
    }

    public void setSecretsChangedHandler(@Nullable EventHandler<Secrets> handler) {
        this.secretsChangedHandler = handler;
    }

    public void setDeviceAddressChangedHandler(@Nullable EventHandler<DeviceAddressStatus> handler) {
        this.deviceAddressChangedHandler = handler;
    }

    public void setPrintingResponseDelegate(PrintingResponseDelegate printingResponseDelegate) {
        this.printingResponseDelegate = printingResponseDelegate;
    }

    public void setTerminalStatusResponseDelegate(TerminalStatusResponseDelegate terminalStatusResponseDelegate) {
        this.terminalStatusResponseDelegate = terminalStatusResponseDelegate;
    }

    public void setBatteryLevelChangedDelegate(BatteryLevelChangedDelegate batteryLevelChangedDelegate) {
        this.batteryLevelChangedDelegate = batteryLevelChangedDelegate;
    }

    public void setTerminalConfigurationResponseDelegate(TerminalConfigurationResponseDelegate terminalConfigurationResponseDelegate) {
        this.terminalConfigurationResponseDelegate = terminalConfigurationResponseDelegate;
    }

    private void statusChanged() {
        if (this.statusChangedHandler != null) {
            this.statusChangedHandler.onEvent(this.getCurrentStatus());
        }
    }

    private void pairingFlowStateChanged() {
        if (this.pairingFlowStateChangedHandler != null) {
            this.pairingFlowStateChangedHandler.onEvent(this.getCurrentPairingFlowState());
        }
    }

    void txFlowStateChanged() {
        if (this.txFlowStateChangedHandler != null) {
            this.txFlowStateChangedHandler.onEvent(this.getCurrentTxFlowState());
        }
    }

    private void secretsChanged(Secrets value) {
        if (this.secretsChangedHandler != null) {
            this.secretsChangedHandler.onEvent(value);
        }
    }

    private void deviceStatusChanged(DeviceAddressStatus value) {
        if (this.deviceAddressChangedHandler != null) {
            this.deviceAddressChangedHandler.onEvent(value);
        }
    }

    public SpiConfig getConfig() {
        return this.config;
    }

    public void printReport(String key, String payload) {
        this.send(new PrintingRequest(key, payload).toMessage());
    }

    public void getTerminalStatus() {
        this.send(new TerminalStatusRequest().toMessage());
    }

    public void getTerminalConfiguration() {
        this.send(new TerminalConfigurationRequest().toMessage());
    }

    public boolean ackFlowEndedAndBackToIdle() {
        if (this.getCurrentFlow() == SpiFlow.IDLE) {
            return true;
        }
        if (this.getCurrentFlow() == SpiFlow.PAIRING && this.getCurrentPairingFlowState().isFinished()) {
            this.setCurrentFlow(SpiFlow.IDLE);
            return true;
        }
        if (this.getCurrentFlow() == SpiFlow.TRANSACTION && this.getCurrentTxFlowState().isFinished()) {
            this.setCurrentFlow(SpiFlow.IDLE);
            return true;
        }
        return false;
    }

    public boolean pair() {
        if (this.getCurrentStatus() != SpiStatus.UNPAIRED) {
            LOG.warn("Tried to pair but we're already paired");
            return false;
        }
        if (StringUtils.isBlank((String)this.posId) || StringUtils.isBlank((String)this.eftposAddress)) {
            LOG.warn("Tried to pair but missing posId and/or eftposAddress");
            return false;
        }
        this.setCurrentFlow(SpiFlow.PAIRING);
        PairingFlowState pairingFlowState = new PairingFlowState();
        pairingFlowState.setSuccessful(false);
        pairingFlowState.setFinished(false);
        pairingFlowState.setMessage("Connecting...");
        pairingFlowState.setAwaitingCheckFromEftpos(false);
        pairingFlowState.setAwaitingCheckFromPos(false);
        pairingFlowState.setConfirmationCode("");
        this.setCurrentPairingFlowState(pairingFlowState);
        this.pairingFlowStateChanged();
        this.conn.connect();
        return true;
    }

    public void pairingConfirmCode() {
        if (!this.getCurrentPairingFlowState().isAwaitingCheckFromPos()) {
            return;
        }
        this.getCurrentPairingFlowState().setAwaitingCheckFromPos(false);
        if (this.getCurrentPairingFlowState().isAwaitingCheckFromEftpos()) {
            LOG.info("Pair code confirmed from POS side, but I'm still waiting for confirmation from EFTPOS");
            this.getCurrentPairingFlowState().setMessage("Click YES on EFTPOS if code is: " + this.getCurrentPairingFlowState().getConfirmationCode());
            this.pairingFlowStateChanged();
        } else {
            LOG.info("Pair code confirmed from POS side, and was already confirmed from EFTPOS side, pairing finalized");
            this.onPairingSuccess();
            this.onReadyToTransact();
        }
    }

    public void pairingCancel() {
        if (this.getCurrentFlow() != SpiFlow.PAIRING || this.getCurrentPairingFlowState().isFinished()) {
            return;
        }
        if (this.getCurrentPairingFlowState().isAwaitingCheckFromPos() && !this.getCurrentPairingFlowState().isAwaitingCheckFromEftpos()) {
            this.send(new DropKeysRequest().toMessage());
        }
        this.onPairingFailed();
    }

    public boolean unpair() {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            return false;
        }
        if (this.getCurrentFlow() != SpiFlow.IDLE) {
            return false;
        }
        this.send(new DropKeysRequest().toMessage());
        this.doUnpair();
        return true;
    }

    @NotNull
    public InitiateTxResult initiatePurchaseTx(String posRefId, int purchaseAmount) {
        InitiateTxResult initiateTxResult = this.initiatePurchaseTx(posRefId, purchaseAmount, 0, 0, false, null, 0);
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(9);
        }
        return initiateTxResult;
    }

    @NotNull
    public InitiateTxResult initiatePurchaseTx(String posRefId, int purchaseAmount, int tipAmount, int cashoutAmount, boolean promptForCashout) {
        InitiateTxResult initiateTxResult = this.initiatePurchaseTx(posRefId, purchaseAmount, tipAmount, cashoutAmount, promptForCashout, null, 0);
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(10);
        }
        return initiateTxResult;
    }

    @NotNull
    public InitiateTxResult initiatePurchaseTx(String posRefId, int purchaseAmount, int tipAmount, int cashoutAmount, boolean promptForCashout, TransactionOptions options) {
        InitiateTxResult initiateTxResult = this.initiatePurchaseTx(posRefId, purchaseAmount, tipAmount, cashoutAmount, promptForCashout, options, 0);
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(11);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiatePurchaseTx(String posRefId, int purchaseAmount, int tipAmount, int cashoutAmount, boolean promptForCashout, TransactionOptions options, int surchargeAmount) {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(12);
            }
            return initiateTxResult;
        }
        if (tipAmount > 0 && (cashoutAmount > 0 || promptForCashout)) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Cannot Accept Tips and Cashout at the same time.");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(13);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl15 : MonitorExitStatement: MONITOREXIT : var8_8
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(14);
                }
                return initiateTxResult;
            }
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            PurchaseRequest request = PurchaseHelper.createPurchaseRequest(purchaseAmount, posRefId, tipAmount, cashoutAmount, promptForCashout, surchargeAmount);
            request.setConfig(this.config);
            request.setOptions(options);
            Message message = request.toMessage();
            this.setCurrentTxFlowState(new TransactionFlowState(posRefId, TransactionType.PURCHASE, purchaseAmount, message, "Waiting for EFTPOS connection to make payment request. " + request.amountSummary()));
            if (this.send(message)) {
                this.getCurrentTxFlowState().sent("Asked EFTPOS to accept payment for " + request.amountSummary());
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "Purchase Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(15);
        }
        return initiateTxResult;
    }

    @NotNull
    public InitiateTxResult initiateRefundTx(String posRefId, int refundAmount) {
        InitiateTxResult initiateTxResult = this.initiateRefundTx(posRefId, refundAmount, false);
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(16);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiateRefundTx(String posRefId, int refundAmount, boolean isSuppressMerchantPassword) {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(17);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(18);
                }
                return initiateTxResult;
            }
            RefundRequest request = PurchaseHelper.createRefundRequest(refundAmount, posRefId, isSuppressMerchantPassword);
            request.setConfig(this.config);
            Message message = request.toMessage();
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            this.setCurrentTxFlowState(new TransactionFlowState(posRefId, TransactionType.REFUND, refundAmount, message, String.format("Waiting for EFTPOS connection to make refund request for %.2f", (double)refundAmount / 100.0)));
            if (this.send(message)) {
                this.getCurrentTxFlowState().sent(String.format("Asked EFTPOS to refund %.2f", (double)refundAmount / 100.0));
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "Refund Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(19);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MidTxResult acceptSignature(boolean accepted) {
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.TRANSACTION || this.getCurrentTxFlowState().isFinished() || !this.getCurrentTxFlowState().isAwaitingSignatureCheck()) {
                LOG.info("Asked to accept signature but I was not waiting for one.");
                MidTxResult midTxResult = new MidTxResult(false, "Asked to accept signature but I was not waiting for one.");
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                if (midTxResult == null) {
                    Spi.$$$reportNull$$$0(20);
                }
                return midTxResult;
            }
            this.getCurrentTxFlowState().signatureResponded(accepted ? "Accepting Signature..." : "Declining Signature...");
            SignatureRequired sigReqMsg = this.getCurrentTxFlowState().getSignatureRequiredMessage();
            String sigReqId = sigReqMsg.getRequestId();
            this.send((accepted ? new SignatureAccept(sigReqId) : new SignatureDecline(sigReqId)).toMessage());
        }
        this.txFlowStateChanged();
        MidTxResult midTxResult = new MidTxResult(true, "");
        if (midTxResult == null) {
            Spi.$$$reportNull$$$0(21);
        }
        return midTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public SubmitAuthCodeResult submitAuthCode(String authCode) {
        if (authCode.length() != 6) {
            SubmitAuthCodeResult submitAuthCodeResult = new SubmitAuthCodeResult(false, "Not a 6-digit code.");
            if (submitAuthCodeResult == null) {
                Spi.$$$reportNull$$$0(22);
            }
            return submitAuthCodeResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.TRANSACTION || this.getCurrentTxFlowState().isFinished() || !this.getCurrentTxFlowState().isAwaitingPhoneForAuth()) {
                LOG.info("Asked to send auth code but I was not waiting for one.");
                SubmitAuthCodeResult submitAuthCodeResult = new SubmitAuthCodeResult(false, "Was not waiting for one.");
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                if (submitAuthCodeResult == null) {
                    Spi.$$$reportNull$$$0(23);
                }
                return submitAuthCodeResult;
            }
            this.getCurrentTxFlowState().authCodeSent("Submitting Auth Code " + authCode);
            this.send(new AuthCodeAdvice(this.getCurrentTxFlowState().getPosRefId(), authCode).toMessage());
        }
        this.txFlowStateChanged();
        SubmitAuthCodeResult submitAuthCodeResult = new SubmitAuthCodeResult(true, "Valid Code.");
        if (submitAuthCodeResult == null) {
            Spi.$$$reportNull$$$0(24);
        }
        return submitAuthCodeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MidTxResult cancelTransaction() {
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.TRANSACTION || this.getCurrentTxFlowState().isFinished()) {
                LOG.info("Asked to cancel transaction but I was not in the middle of one.");
                MidTxResult midTxResult = new MidTxResult(false, "Asked to cancel transaction but I was not in the middle of one.");
                // MONITOREXIT @DISABLED, blocks:[2, 7] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                if (midTxResult == null) {
                    Spi.$$$reportNull$$$0(25);
                }
                return midTxResult;
            }
            if (this.getCurrentTxFlowState().isRequestSent()) {
                CancelTransactionRequest cancelReq = new CancelTransactionRequest();
                this.getCurrentTxFlowState().cancelling("Attempting to Cancel Transaction...");
                this.send(cancelReq.toMessage());
            } else {
                this.getCurrentTxFlowState().failed(null, "Transaction Cancelled. Request Had not even been sent yet.");
            }
        }
        this.txFlowStateChanged();
        MidTxResult midTxResult = new MidTxResult(true, "");
        if (midTxResult == null) {
            Spi.$$$reportNull$$$0(26);
        }
        return midTxResult;
    }

    @NotNull
    public InitiateTxResult initiateCashoutOnlyTx(String posRefId, int amountCents) {
        InitiateTxResult initiateTxResult = this.initiateCashoutOnlyTx(posRefId, amountCents, 0);
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(27);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiateCashoutOnlyTx(String posRefId, int amountCents, int surchargeAmount) {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(28);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(29);
                }
                return initiateTxResult;
            }
            CashoutOnlyRequest cashoutOnlyRequest = new CashoutOnlyRequest(amountCents, posRefId);
            cashoutOnlyRequest.setSurchargeAmount(surchargeAmount);
            cashoutOnlyRequest.setConfig(this.config);
            Message cashoutMsg = cashoutOnlyRequest.toMessage();
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            this.setCurrentTxFlowState(new TransactionFlowState(posRefId, TransactionType.CASHOUT_ONLY, amountCents, cashoutMsg, String.format("Waiting for EFTPOS connection to send cashout request for %.2f", (double)amountCents / 100.0)));
            if (this.send(cashoutMsg)) {
                this.getCurrentTxFlowState().sent(String.format("Asked EFTPOS to do cashout for %.2f", (double)amountCents / 100.0));
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "Cashout Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(30);
        }
        return initiateTxResult;
    }

    @NotNull
    public InitiateTxResult initiateMotoPurchaseTx(String posRefId, int amountCents) {
        InitiateTxResult initiateTxResult = this.initiateMotoPurchaseTx(posRefId, amountCents, 0);
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(31);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiateMotoPurchaseTx(String posRefId, int amountCents, int surchargeAmount) {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(32);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(33);
                }
                return initiateTxResult;
            }
            MotoPurchaseRequest request = new MotoPurchaseRequest(amountCents, posRefId);
            request.setSurchargeAmount(surchargeAmount);
            request.setConfig(this.config);
            Message message = request.toMessage();
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            this.setCurrentTxFlowState(new TransactionFlowState(posRefId, TransactionType.MOTO, amountCents, message, String.format("Waiting for EFTPOS connection to send MOTO request for %.2f", (double)amountCents / 100.0)));
            if (this.send(message)) {
                this.getCurrentTxFlowState().sent(String.format("Asked EFTPOS do MOTO for %.2f", (double)amountCents / 100.0));
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "MOTO Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(34);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiateSettleTx(String posRefId) {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(35);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(36);
                }
                return initiateTxResult;
            }
            SettleRequest settleRequest = new SettleRequest(RequestIdHelper.id("settle"));
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            this.setCurrentTxFlowState(new TransactionFlowState(posRefId, TransactionType.SETTLE, 0, settleRequest.toMessage(), "Waiting for EFTPOS connection to make a settle request"));
            if (this.send(settleRequest.toMessage())) {
                this.getCurrentTxFlowState().sent("Asked EFTPOS to settle.");
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "Settle Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(37);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiateSettlementEnquiry(String posRefId) {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(38);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(39);
                }
                return initiateTxResult;
            }
            Message message = new SettlementEnquiryRequest(RequestIdHelper.id("stlenq")).toMessage();
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            this.setCurrentTxFlowState(new TransactionFlowState(posRefId, TransactionType.SETTLEMENT_ENQUIRY, 0, message, "Waiting for EFTPOS connection to make a settlement enquiry"));
            if (this.send(message)) {
                this.getCurrentTxFlowState().sent("Asked EFTPOS to make a settlement enquiry.");
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "Settle Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(40);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiateGetLastTx() {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(41);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.currentFlow != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(42);
                }
                return initiateTxResult;
            }
            Message message = new GetLastTransactionRequest().toMessage();
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            this.setCurrentTxFlowState(new TransactionFlowState(message.getId(), TransactionType.GET_LAST_TRANSACTION, 0, message, "Waiting for EFTPOS connection to make a Get-Last-Transaction request"));
            this.getCurrentTxFlowState().callingGlt(message.getId());
            if (this.send(message)) {
                this.getCurrentTxFlowState().sent("Asked EFTPOS to Get Last Transaction.");
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "GLT Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(43);
        }
        return initiateTxResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InitiateTxResult initiateRecovery(String posRefId, TransactionType txType) {
        if (this.getCurrentStatus() == SpiStatus.UNPAIRED) {
            InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Paired");
            if (initiateTxResult == null) {
                Spi.$$$reportNull$$$0(44);
            }
            return initiateTxResult;
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() != SpiFlow.IDLE) {
                InitiateTxResult initiateTxResult = new InitiateTxResult(false, "Not Idle");
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                if (initiateTxResult == null) {
                    Spi.$$$reportNull$$$0(45);
                }
                return initiateTxResult;
            }
            Message message = new GetLastTransactionRequest().toMessage();
            this.setCurrentFlow(SpiFlow.TRANSACTION);
            this.setCurrentTxFlowState(new TransactionFlowState(posRefId, txType, 0, message, "Waiting for EFTPOS connection to attempt recovery."));
            if (this.send(message)) {
                this.getCurrentTxFlowState().sent("Asked EFTPOS to recover state.");
            }
        }
        this.txFlowStateChanged();
        InitiateTxResult initiateTxResult = new InitiateTxResult(true, "Recovery Initiated");
        if (initiateTxResult == null) {
            Spi.$$$reportNull$$$0(46);
        }
        return initiateTxResult;
    }

    @NotNull
    public Message.SuccessState gltMatch(@NotNull GetLastTransactionResponse gltResponse, @NotNull String posRefId) {
        if (gltResponse == null) {
            Spi.$$$reportNull$$$0(47);
        }
        if (posRefId == null) {
            Spi.$$$reportNull$$$0(48);
        }
        LOG.info("GLT CHECK: PosRefId: " + posRefId + "->" + gltResponse.getPosRefId());
        if (!posRefId.equals(gltResponse.getPosRefId())) {
            Message.SuccessState successState = Message.SuccessState.UNKNOWN;
            if (successState == null) {
                Spi.$$$reportNull$$$0(49);
            }
            return successState;
        }
        Message.SuccessState successState = gltResponse.getSuccessState();
        if (successState == null) {
            Spi.$$$reportNull$$$0(50);
        }
        return successState;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NotNull
    public Message.SuccessState gltMatch(@NotNull GetLastTransactionResponse gltResponse, @NotNull TransactionType expectedType, int expectedAmount, long requestTime, String string) {
        void posRefId;
        if (gltResponse == null) {
            Spi.$$$reportNull$$$0(51);
        }
        if (expectedType == null) {
            Spi.$$$reportNull$$$0(52);
        }
        Message.SuccessState successState = this.gltMatch(gltResponse, (String)posRefId);
        if (successState == null) {
            Spi.$$$reportNull$$$0(53);
        }
        return successState;
    }

    private void handleKeyRequest(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(54);
        }
        PairingFlowState currentState = this.getCurrentPairingFlowState();
        currentState.setMessage("Negotiating pairing...");
        this.pairingFlowStateChanged();
        SecretsAndKeyResponse result = PairingHelper.generateSecretsAndKeyResponse(new KeyRequest(m));
        this.secrets = result.getSecrets();
        this.spiMessageStamp.setSecrets(this.secrets);
        this.send(result.getKeyResponse().toMessage());
    }

    private void handleKeyCheck(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(55);
        }
        KeyCheck keyCheck = new KeyCheck(m);
        PairingFlowState currentState = this.getCurrentPairingFlowState();
        currentState.setConfirmationCode(keyCheck.getConfirmationCode());
        currentState.setAwaitingCheckFromEftpos(true);
        currentState.setAwaitingCheckFromPos(true);
        currentState.setMessage("Confirm that the following code is showing on the terminal");
        this.pairingFlowStateChanged();
    }

    private void handlePairResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(56);
        }
        PairResponse pairResp = new PairResponse(m);
        PairingFlowState currentState = this.getCurrentPairingFlowState();
        currentState.setAwaitingCheckFromEftpos(false);
        if (pairResp.isSuccess()) {
            if (currentState.isAwaitingCheckFromPos()) {
                currentState.setMessage("Confirm that the following Code is what the EFTPOS showed");
                this.pairingFlowStateChanged();
            } else {
                this.onPairingSuccess();
            }
            this.startPeriodicPing();
        } else {
            this.onPairingFailed();
        }
    }

    private void handleDropKeysAdvice(Message m) {
        LOG.info("EFTPOS was unpaired. I shall unpair from my end as well.");
        this.doUnpair();
    }

    private void onPairingSuccess() {
        PairingFlowState currentState = this.getCurrentPairingFlowState();
        currentState.setSuccessful(true);
        currentState.setFinished(true);
        currentState.setMessage("Pairing Successful!");
        this.setCurrentStatus(SpiStatus.PAIRED_CONNECTED);
        this.secretsChanged(this.secrets);
        this.pairingFlowStateChanged();
    }

    private void onPairingFailed() {
        this.secrets = null;
        this.spiMessageStamp.setSecrets(null);
        this.conn.disconnect();
        PairingFlowState currentState = this.getCurrentPairingFlowState();
        this.setCurrentStatus(SpiStatus.UNPAIRED);
        currentState.setMessage("Pairing Failed");
        currentState.setFinished(true);
        currentState.setSuccessful(false);
        currentState.setAwaitingCheckFromPos(false);
        this.pairingFlowStateChanged();
    }

    private void doUnpair() {
        this.setCurrentStatus(SpiStatus.UNPAIRED);
        this.conn.disconnect();
        this.secrets = null;
        this.spiMessageStamp.setSecrets(null);
        this.secretsChanged(this.secrets);
    }

    private void handleKeyRollingRequest(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(57);
        }
        KeyRollingResult krRes = KeyRollingHelper.performKeyRolling(m, this.secrets);
        this.secrets = krRes.getNewSecrets();
        this.spiMessageStamp.setSecrets(this.secrets);
        this.send(krRes.getKeyRollingConfirmation());
        this.secretsChanged(this.secrets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSignatureRequired(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(58);
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.isTxResponseUnexpected(m, "Signature Required", true)) {
                return;
            }
            this.getCurrentTxFlowState().signatureRequired(new SignatureRequired(m), "Ask Customer to Sign the Receipt");
        }
        this.txFlowStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAuthCodeRequired(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(59);
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.isTxResponseUnexpected(m, "Auth Code Required", true)) {
                return;
            }
            PhoneForAuthRequired phoneForAuthRequired = new PhoneForAuthRequired(m);
            String msg = "Auth Code Required. Call " + phoneForAuthRequired.getPhoneNumber() + " and quote merchant id " + phoneForAuthRequired.getMerchantId();
            this.getCurrentTxFlowState().phoneForAuthRequired(phoneForAuthRequired, msg);
        }
        this.txFlowStateChanged();
    }

    private void handlePurchaseResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(60);
        }
        this.handleTxResponse(m, TransactionType.PURCHASE, true);
    }

    private void handleCashoutOnlyResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(61);
        }
        this.handleTxResponse(m, TransactionType.CASHOUT_ONLY, true);
    }

    private void handleMotoPurchaseResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(62);
        }
        this.handleTxResponse(m, TransactionType.MOTO, true);
    }

    private void handleRefundResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(63);
        }
        this.handleTxResponse(m, TransactionType.REFUND, true);
    }

    private void handleSettleResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(64);
        }
        this.handleTxResponse(m, TransactionType.SETTLE, false);
    }

    private void handleSettlementEnquiryResponse(Message m) {
        this.handleTxResponse(m, TransactionType.SETTLEMENT_ENQUIRY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTxResponse(@NotNull Message m, @NotNull TransactionType type, boolean checkPosRefId) {
        if (m == null) {
            Spi.$$$reportNull$$$0(65);
        }
        if (type == null) {
            Spi.$$$reportNull$$$0(66);
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.isTxResponseUnexpected(m, type.getName(), checkPosRefId)) {
                return;
            }
            this.getCurrentTxFlowState().completed(m.getSuccessState(), m, (Object)((Object)type) + " transaction ended.");
        }
        this.txFlowStateChanged();
    }

    private boolean isTxResponseUnexpected(@NotNull Message m, @NotNull String typeName, boolean checkPosRefId) {
        boolean posRefIdMatched;
        String incomingPosRefId;
        if (m == null) {
            Spi.$$$reportNull$$$0(67);
        }
        if (typeName == null) {
            Spi.$$$reportNull$$$0(68);
        }
        TransactionFlowState currentState = this.getCurrentTxFlowState();
        if (checkPosRefId) {
            incomingPosRefId = m.getDataStringValue("pos_ref_id");
            posRefIdMatched = currentState.getPosRefId().equals(incomingPosRefId);
        } else {
            incomingPosRefId = null;
            posRefIdMatched = true;
        }
        if (this.getCurrentFlow() != SpiFlow.TRANSACTION || currentState.isFinished() || !posRefIdMatched) {
            String trace = checkPosRefId ? "Incoming Pos Ref ID: " + incomingPosRefId : m.getDecryptedJson();
            LOG.info("Received " + typeName + " response but I was not waiting for one. " + trace);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleErrorEvent(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(69);
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() == SpiFlow.TRANSACTION && !this.getCurrentTxFlowState().isFinished() && this.getCurrentTxFlowState().isAttemptingToCancel() && "NO_TRANSACTION".equals(m.getError())) {
                LOG.info("Was trying to cancel a transaction but there is nothing to cancel. Calling GLT to see what's up");
                this.callGetLastTransaction();
            } else {
                LOG.info("Received error event, but don't know what to do with it. " + m.getDecryptedJson());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleGetLastTransactionResponse(@NotNull Message m) {
        block15: {
            if (m == null) {
                Spi.$$$reportNull$$$0(70);
            }
            Object object = this.txLock;
            synchronized (object) {
                GetLastTransactionResponse gltResponse;
                TransactionFlowState txState;
                block16: {
                    block17: {
                        txState = this.getCurrentTxFlowState();
                        if (this.getCurrentFlow() != SpiFlow.TRANSACTION || txState.isFinished()) {
                            LOG.info("Received glt response but we were not in the middle of a tx. ignoring.");
                            return;
                        }
                        if (!this.getCurrentTxFlowState().isAwaitingGltResponse()) {
                            LOG.info("received a glt response but we had not asked for one within this transaction. Perhaps leftover from previous one. ignoring.");
                            return;
                        }
                        if (!this.getCurrentTxFlowState().getLastGltRequestId().equals(m.getId())) {
                            LOG.info("received a glt response but the message id does not match the glt request that we sent. strange. ignoring.");
                            return;
                        }
                        LOG.info("Got last transaction..");
                        txState.gotGltResponse();
                        gltResponse = new GetLastTransactionResponse(m);
                        txState.setGltResponsePosRefId(gltResponse.getPosRefId());
                        if (gltResponse.wasRetrievedSuccessfully()) break block16;
                        if (!gltResponse.isStillInProgress(txState.getPosRefId())) break block17;
                        if (gltResponse.isWaitingForSignatureResponse() && !txState.isAwaitingSignatureCheck()) {
                            LOG.info("EFTPOS is waiting for us to send it signature accept/decline, but we were not aware of this. The user can only really decline at this stage as there is no receipt to print for signing.");
                            this.getCurrentTxFlowState().signatureRequired(new SignatureRequired(txState.getPosRefId(), m.getId(), "MISSING RECEIPT\n DECLINE AND TRY AGAIN."), "Recovered in Signature Required but we don't have receipt. You may Decline then Retry.");
                            break block15;
                        } else if (gltResponse.isWaitingForAuthCode() && !txState.isAwaitingPhoneForAuth()) {
                            LOG.info("EFTPOS is waiting for us to send it auth code, but we were not aware of this. We can only cancel the transaction at this stage as we don't have enough information to recover from this.");
                            this.getCurrentTxFlowState().phoneForAuthRequired(new PhoneForAuthRequired(txState.getPosRefId(), m.getId(), "UNKNOWN", "UNKNOWN"), "Recovered mid phone-for-auth but don't have details. You may cancel then retry.");
                            break block15;
                        } else {
                            LOG.info("Operation still in progress... keep waiting.");
                            return;
                        }
                    }
                    if (gltResponse.wasTimeOutOfSyncError()) {
                        LOG.info("Time-Out-Of-Sync error in Get Last Transaction response. Let's ignore it and we'll try again.");
                        return;
                    }
                    LOG.info("Unexpected Response in get last transaction during - received posRefId:" + gltResponse.getPosRefId() + " error:" + m.getError() + ". Ignoring.");
                    return;
                }
                if (txState.getType() == TransactionType.GET_LAST_TRANSACTION) {
                    LOG.info("Retrieved last transaction as asked directly by the user.");
                    gltResponse.copyMerchantReceiptToCustomerReceipt();
                    txState.completed(m.getSuccessState(), m, "Last transaction retrieved");
                } else {
                    Message.SuccessState successState = this.gltMatch(gltResponse, txState.getPosRefId());
                    if (successState == Message.SuccessState.UNKNOWN) {
                        LOG.info("Did not match transaction.");
                        txState.unknownCompleted("Failed to recover transaction status. Check EFTPOS. ");
                    } else {
                        gltResponse.copyMerchantReceiptToCustomerReceipt();
                        txState.completed(successState, m, "Transaction ended.");
                    }
                }
            }
        }
        this.txFlowStateChanged();
    }

    private void startTransactionMonitoring() {
        this.stopTransactionMonitoring();
        this.transactionMonitoringThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    boolean needsPublishing = false;
                    Object object = Spi.this.txLock;
                    synchronized (object) {
                        TransactionFlowState txState = Spi.this.getCurrentTxFlowState();
                        if (Spi.this.getCurrentFlow() == SpiFlow.TRANSACTION && !txState.isFinished()) {
                            if (txState.isAttemptingToCancel() && System.currentTimeMillis() > txState.getCancelAttemptTime() + MAX_WAIT_FOR_CANCEL_TX) {
                                LOG.info("Been too long waiting for transaction to cancel.");
                                txState.unknownCompleted("Waited long enough for cancel transaction result. Check EFTPOS. ");
                                needsPublishing = true;
                            } else if (txState.isRequestSent() && System.currentTimeMillis() > txState.getLastStateRequestTime() + CHECK_ON_TX_FREQUENCY) {
                                LOG.info("Checking on our transaction. Last we asked was at " + txState.getLastStateRequestTime() + "...");
                                Spi.this.callGetLastTransaction();
                            }
                        }
                    }
                    if (needsPublishing) {
                        Spi.this.txFlowStateChanged();
                    }
                    try {
                        Thread.sleep(TX_MONITOR_CHECK_FREQUENCY);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.transactionMonitoringThread.start();
    }

    private void stopTransactionMonitoring() {
        if (this.transactionMonitoringThread != null) {
            this.transactionMonitoringThread.interrupt();
            this.transactionMonitoringThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCancelTransactionResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(71);
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.isTxResponseUnexpected(m, "Cancel", true)) {
                return;
            }
            TransactionFlowState txState = this.getCurrentTxFlowState();
            CancelTransactionResponse response = new CancelTransactionResponse(m);
            if (response.isSuccess()) {
                return;
            }
            LOG.warn("Failed to cancel transaction: reason=" + response.getErrorReason() + ", detail=" + response.getErrorDetail());
            txState.cancelFailed("Failed to cancel transaction: " + response.getErrorDetail() + ". Check EFTPOS.");
            this.txFlowStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSetPosInfoResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(72);
        }
        Object object = this.txLock;
        synchronized (object) {
            SetPosInfoResponse response = new SetPosInfoResponse(m);
            if (response.isSuccess()) {
                this.hasSetInfo = true;
                LOG.info("Setting POS info successful");
            } else {
                LOG.warn("Setting POS info failed: reason=" + response.getErrorReason() + ", detail=" + response.getErrorDetail());
            }
        }
    }

    private void handlePrintingResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(73);
        }
        this.printingResponseDelegate.printingResponse(m);
    }

    private void handleTerminalStatusResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(74);
        }
        this.terminalStatusResponseDelegate.terminalStatusResponse(m);
    }

    private void handleBatteryLevelChanged(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(75);
        }
        this.batteryLevelChangedDelegate.batteryLevelChanged(m);
    }

    private void handleTerminalConfigurationResponse(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(76);
        }
        this.terminalConfigurationResponseDelegate.terminalConfigurationResponse(m);
    }

    private void resetConn() {
        this.conn = new Connection(this.eftposAddress);
        this.conn.setEventHandler(new Connection.EventHandler(){

            @Override
            public void onConnectionStateChanged(Connection.State state) {
                Spi.this.onSpiConnectionStatusChanged(state);
            }

            @Override
            public void onMessageReceived(String message) {
                Spi.this.onSpiMessageReceived(message);
            }

            @Override
            public void onError(Throwable thr) {
                Spi.this.onWsErrorReceived(thr);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSpiConnectionStatusChanged(@NotNull Connection.State state) {
        if (state == null) {
            Spi.$$$reportNull$$$0(77);
        }
        switch (state) {
            case CONNECTING: {
                LOG.info("I'm connecting to the EFTPOS at " + this.eftposAddress + "...");
                break;
            }
            case CONNECTED: {
                this.retriesSinceLastDeviceAddressResolution = 0;
                if (this.getCurrentFlow() == SpiFlow.PAIRING && this.getCurrentStatus() == SpiStatus.UNPAIRED) {
                    this.getCurrentPairingFlowState().setMessage("Requesting to pair...");
                    this.pairingFlowStateChanged();
                    PairRequest pr = PairingHelper.newPairRequest();
                    this.send(pr.toMessage());
                    break;
                }
                LOG.info("I'm connected to " + this.eftposAddress + "...");
                this.spiMessageStamp.setSecrets(this.secrets);
                this.startPeriodicPing();
                this.cleanReconnectFuture();
                break;
            }
            case DISCONNECTED: {
                LOG.info("I'm disconnected from " + this.eftposAddress + "...");
                this.mostRecentPingSent = null;
                this.mostRecentPongReceived = null;
                this.missedPongsCount = 0;
                this.stopPeriodicPing();
                if (this.getCurrentStatus() != SpiStatus.UNPAIRED) {
                    this.setCurrentStatus(SpiStatus.PAIRED_CONNECTING);
                    Object object = this.txLock;
                    synchronized (object) {
                        if (this.getCurrentFlow() == SpiFlow.TRANSACTION && !this.getCurrentTxFlowState().isFinished()) {
                            LOG.warn("Lost connection in the middle of a transaction...");
                        }
                    }
                    if (this.conn == null) {
                        return;
                    }
                    if (this.reconnectExecutor == null) {
                        LOG.warn("reconnectExecutor null. Possibly this is still running after dispose?");
                        return;
                    }
                    LOG.info("Will try to reconnect in {}s...", (Object)(RECONNECTION_TIMEOUT / 1000L));
                    this.cleanReconnectFuture();
                    this.reconnectFuture = this.reconnectExecutor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            Connection conn;
                            if (Spi.this.autoAddressResolutionEnabled) {
                                if (Spi.this.retriesSinceLastDeviceAddressResolution >= 5) {
                                    Spi.this.autoResolveEftposAddress();
                                    Spi.this.retriesSinceLastDeviceAddressResolution = 0;
                                } else {
                                    Spi.this.retriesSinceLastDeviceAddressResolution++;
                                }
                            }
                            if (Spi.this.getCurrentStatus() != SpiStatus.UNPAIRED && (conn = Spi.this.conn) != null) {
                                conn.connect();
                            }
                        }
                    }, RECONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
                    break;
                }
                if (this.getCurrentFlow() != SpiFlow.PAIRING) break;
                LOG.warn("Lost connection during pairing.");
                this.getCurrentPairingFlowState().setMessage("Could not Connect to Pair. Check Network and Try Again...");
                this.onPairingFailed();
                this.pairingFlowStateChanged();
                break;
            }
            default: {
                throw new IllegalArgumentException(state.toString());
            }
        }
    }

    private void startPeriodicPing() {
        this.stopPeriodicPing();
        this.periodicPingThread = new Thread(){

            @Override
            public void run() {
                while (!this.isInterrupted() && Spi.this.conn.isConnected() && Spi.this.secrets != null) {
                    Spi.this.doPing();
                    try {
                        Thread.sleep(PONG_TIMEOUT);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    if (!(Spi.this.mostRecentPingSent == null || Spi.this.mostRecentPongReceived != null && Spi.this.mostRecentPongReceived.getId().equals(Spi.this.mostRecentPingSent.getId()))) {
                        Spi.this.missedPongsCount += 1;
                        LOG.warn("EFTPOS didn't reply to my ping. Missed count: " + Spi.this.missedPongsCount + "/" + 2L + ". ");
                        if ((long)Spi.this.missedPongsCount < 2L) {
                            LOG.info("Trying another ping...");
                            continue;
                        }
                        LOG.warn("Disconnecting...");
                        Spi.this.conn.disconnect();
                        break;
                    }
                    Spi.this.missedPongsCount = 0;
                    try {
                        Thread.sleep(PING_FREQUENCY - PONG_TIMEOUT);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.periodicPingThread.start();
    }

    private void stopPeriodicPing() {
        if (this.periodicPingThread != null) {
            this.periodicPingThread.interrupt();
            this.periodicPingThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReadyToTransact() {
        LOG.info("On Ready To Transact!");
        this.setCurrentStatus(SpiStatus.PAIRED_CONNECTED);
        Object object = this.txLock;
        synchronized (object) {
            if (this.getCurrentFlow() == SpiFlow.TRANSACTION && !this.getCurrentTxFlowState().isFinished()) {
                if (this.getCurrentTxFlowState().isRequestSent()) {
                    this.callGetLastTransaction();
                } else {
                    this.send(this.getCurrentTxFlowState().getRequest());
                    this.getCurrentTxFlowState().sent("Asked EFTPOS to accept payment for " + (double)this.getCurrentTxFlowState().getAmountCents() / 100.0);
                    this.txFlowStateChanged();
                }
            } else {
                SpiPayAtTable spiPat;
                if (!this.hasSetInfo) {
                    this.callSetPosInfo();
                }
                if ((spiPat = this.spiPat) != null) {
                    spiPat.pushPayAtTableConfig();
                }
            }
        }
    }

    private void callSetPosInfo() {
        SetPosInfoRequest setPosInfoRequest = new SetPosInfoRequest(this.posVersion, this.posVendorId, "java", Spi.getVersion(), DeviceInfo.getAppDeviceInfo());
        this.send(setPosInfoRequest.toMessage());
    }

    private void doPing() {
        Message ping;
        this.mostRecentPingSent = ping = PingHelper.generatePingRequest();
        this.send(ping);
        this.mostRecentPingSentTime = System.currentTimeMillis();
    }

    private void handleIncomingPong(Message m) {
        this.spiMessageStamp.setServerTimeDelta(m.getServerTimeDelta());
        if (this.mostRecentPongReceived == null) {
            if (this.getCurrentStatus() != SpiStatus.UNPAIRED) {
                LOG.info("First pong of connection and in paired state");
                this.onReadyToTransact();
            } else {
                LOG.info("First pong of connection but pairing process not finalised yet.");
            }
        }
        this.mostRecentPongReceived = m;
        LOG.debug("PongLatency:" + (System.currentTimeMillis() - this.mostRecentPingSentTime));
    }

    private void handleIncomingPing(@NotNull Message m) {
        if (m == null) {
            Spi.$$$reportNull$$$0(78);
        }
        this.send(PongHelper.generatePongResponse(m));
    }

    private void callGetLastTransaction() {
        Message gltMessage = new GetLastTransactionRequest().toMessage();
        this.getCurrentTxFlowState().callingGlt(gltMessage.getId());
        this.send(gltMessage);
    }

    private void onSpiMessageReceived(@NotNull String messageJson) {
        if (messageJson == null) {
            Spi.$$$reportNull$$$0(79);
        }
        Message m = Message.fromJson(messageJson, this.secrets);
        LOG.debug("Received: " + m.getDecryptedJson());
        if (SpiPreauth.isPreauthEvent(m.getEventName())) {
            SpiPreauth spiPreauth = this.spiPreauth;
            if (spiPreauth != null) {
                spiPreauth.handlePreauthMessage(m);
            }
            return;
        }
        String eventName = m.getEventName();
        if ("key_request".equals(eventName)) {
            this.handleKeyRequest(m);
        } else if ("key_check".equals(eventName)) {
            this.handleKeyCheck(m);
        } else if ("pair_response".equals(eventName)) {
            this.handlePairResponse(m);
        } else if ("drop_keys".equals(eventName)) {
            this.handleDropKeysAdvice(m);
        } else if ("purchase_response".equals(eventName)) {
            this.handlePurchaseResponse(m);
        } else if ("refund_response".equals(eventName)) {
            this.handleRefundResponse(m);
        } else if ("cash_response".equals(eventName)) {
            this.handleCashoutOnlyResponse(m);
        } else if ("moto_purchase_response".equals(eventName)) {
            this.handleMotoPurchaseResponse(m);
        } else if ("signature_required".equals(eventName)) {
            this.handleSignatureRequired(m);
        } else if ("authorisation_code_required".equals(eventName)) {
            this.handleAuthCodeRequired(m);
        } else if ("last_transaction".equals(eventName)) {
            this.handleGetLastTransactionResponse(m);
        } else if ("settlement_enquiry_response".equals(eventName)) {
            this.handleSettlementEnquiryResponse(m);
        } else if ("settle_response".equals(eventName)) {
            this.handleSettleResponse(m);
        } else if ("ping".equals(eventName)) {
            this.handleIncomingPing(m);
        } else if ("pong".equals(eventName)) {
            this.handleIncomingPong(m);
        } else if ("request_use_next_keys".equals(eventName)) {
            this.handleKeyRollingRequest(m);
        } else if ("cancel_response".equals(eventName)) {
            this.handleCancelTransactionResponse(m);
        } else if ("set_pos_info_response".equals(eventName)) {
            this.handleSetPosInfoResponse(m);
        } else if ("get_table_config".equals(eventName)) {
            SpiPayAtTable spiPat = this.spiPat;
            if (spiPat != null) {
                spiPat.handleGetTableConfig(m);
            } else {
                this.send(PayAtTableConfig.featureDisableMessage(RequestIdHelper.id("patconf")));
            }
        } else if ("get_bill_details".equals(eventName)) {
            SpiPayAtTable spiPat = this.spiPat;
            if (spiPat != null) {
                spiPat.handleGetBillDetailsRequest(m);
            }
        } else if ("bill_payment".equals(eventName)) {
            SpiPayAtTable spiPat = this.spiPat;
            if (spiPat != null) {
                spiPat.handleBillPaymentAdvice(m);
            }
        } else if ("print_response".equals(eventName)) {
            this.handlePrintingResponse(m);
        } else if ("terminal_status".equals(eventName)) {
            this.handleTerminalStatusResponse(m);
        } else if ("battery_level_changed".equals(eventName)) {
            this.handleBatteryLevelChanged(m);
        } else if ("terminal_configuration".equals(eventName)) {
            this.handleTerminalConfigurationResponse(m);
        } else if ("error".equals(eventName)) {
            this.handleErrorEvent(m);
        } else if ("_INVALID_SIGNATURE_".equals(eventName)) {
            LOG.info("I could not verify message from EFTPOS. You might have to un-pair EFTPOS and then reconnect.");
        } else {
            LOG.info("I don't understand event: " + eventName + ", " + m.getData() + ". Perhaps I have not implemented it yet.");
        }
    }

    private void onWsErrorReceived(@Nullable Throwable error) {
        LOG.error("Received WS error", error);
    }

    boolean send(Message message) {
        String json = message.toJson(this.spiMessageStamp);
        if (this.conn.isConnected()) {
            LOG.debug("Sending: " + message.getDecryptedJson());
            this.conn.send(json);
            return true;
        }
        LOG.debug("Asked to send, but not connected: " + message.getDecryptedJson());
        return false;
    }

    private boolean hasSerialNumberChanged(String updatedSerialNumber) {
        return !this.serialNumber.equals(updatedSerialNumber);
    }

    private boolean hasEftposAddressChanged(String updatedEftposAddress) {
        return !this.eftposAddress.equals(updatedEftposAddress);
    }

    private void autoResolveEftposAddress() {
        if (!this.autoAddressResolutionEnabled) {
            return;
        }
        if (this.serialNumber == null || StringUtils.isWhitespace((String)this.serialNumber)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                DeviceService deviceService = new DeviceService();
                DeviceAddressStatus addressResponse = deviceService.retrieveService(Spi.this.serialNumber, Spi.this.deviceApiKey, Spi.this.acquirerCode, Spi.this.inTestMode);
                if (addressResponse == null) {
                    return;
                }
                if (addressResponse.getAddress() == null) {
                    return;
                }
                if (!Spi.this.hasEftposAddressChanged(addressResponse.getAddress())) {
                    return;
                }
                Spi.this.eftposAddress = "ws://" + addressResponse.getAddress();
                Spi.this.conn.setAddress(Spi.this.eftposAddress);
                DeviceAddressStatus state = new DeviceAddressStatus();
                state.setAddress(addressResponse.getAddress());
                state.setLastUpdated(addressResponse.getLastUpdated());
                Spi.this.setCurrentDeviceStatus(state);
                Spi.this.deviceStatusChanged(Spi.this.getCurrentDeviceStatus());
            }
        }).start();
    }

    public void dispose() {
        LOG.info("Disposing...");
        this.stopPeriodicPing();
        this.stopTransactionMonitoring();
        this.conn.dispose();
        this.conn = null;
        this.cleanReconnectFuture();
        this.reconnectExecutor.shutdownNow();
        this.reconnectExecutor = null;
    }

    private void cleanReconnectFuture() {
        if (this.reconnectFuture != null) {
            this.reconnectFuture.cancel(true);
            this.reconnectFuture = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "posId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialNumber";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eftposAddress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/assemblypayments/spi/Spi";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gltResponse";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "posRefId";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/assemblypayments/spi/Spi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentStatus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFlow";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "initiatePurchaseTx";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "initiateRefundTx";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptSignature";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "submitAuthCode";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelTransaction";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "initiateCashoutOnlyTx";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "initiateMotoPurchaseTx";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "initiateSettleTx";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "initiateSettlementEnquiry";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "initiateGetLastTx";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "initiateRecovery";
                break;
            }
            case 49: 
            case 50: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "gltMatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPosId";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentStatus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentFlow";
                break;
            }
            case 47: 
            case 48: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "gltMatch";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyRequest";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyCheck";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "handlePairResponse";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyRollingRequest";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "handleSignatureRequired";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "handleAuthCodeRequired";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "handlePurchaseResponse";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "handleCashoutOnlyResponse";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "handleMotoPurchaseResponse";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "handleRefundResponse";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "handleSettleResponse";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "handleTxResponse";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isTxResponseUnexpected";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "handleErrorEvent";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "handleGetLastTransactionResponse";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "handleCancelTransactionResponse";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "handleSetPosInfoResponse";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "handlePrintingResponse";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "handleTerminalStatusResponse";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "handleBatteryLevelChanged";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "handleTerminalConfigurationResponse";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "onSpiConnectionStatusChanged";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "handleIncomingPing";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "onSpiMessageReceived";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TerminalConfigurationResponseDelegate {
        public void terminalConfigurationResponse(@NotNull Message var1);
    }

    public static interface BatteryLevelChangedDelegate {
        public void batteryLevelChanged(@NotNull Message var1);
    }

    public static interface TerminalStatusResponseDelegate {
        public void terminalStatusResponse(@NotNull Message var1);
    }

    public static interface PrintingResponseDelegate {
        public void printingResponse(@NotNull Message var1);
    }

    public static class CompatibilityException
    extends Exception {
        public CompatibilityException(@NotNull String message, @NotNull GeneralSecurityException cause) {
            if (message == null) {
                CompatibilityException.$$$reportNull$$$0(0);
            }
            if (cause == null) {
                CompatibilityException.$$$reportNull$$$0(1);
            }
            super(message, cause);
        }

        @Override
        public synchronized GeneralSecurityException getCause() {
            return (GeneralSecurityException)super.getCause();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "com/assemblypayments/spi/Spi$CompatibilityException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface EventHandler<T> {
        public void onEvent(T var1);
    }
}

