/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi;

import com.assemblypayments.spi.Spi;
import com.assemblypayments.spi.model.BillPayment;
import com.assemblypayments.spi.model.BillRetrievalResult;
import com.assemblypayments.spi.model.BillStatusResponse;
import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.PayAtTableConfig;
import com.assemblypayments.spi.model.PaymentHistoryEntry;
import com.assemblypayments.spi.util.RequestIdHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiPayAtTable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"spipat");
    private final Spi spi;
    private final PayAtTableConfig config;
    private GetBillStatusDelegate getBillStatusDelegate;
    private BillPaymentReceivedDelegate billPaymentReceivedDelegate;

    SpiPayAtTable(Spi spi) {
        this.spi = spi;
        this.config = new PayAtTableConfig();
        this.config.setPayAtTableEnabled(true);
        this.config.setOperatorIdEnabled(true);
        this.config.setAllowedOperatorIds(new ArrayList<String>());
        this.config.setEqualSplitEnabled(true);
        this.config.setSplitByAmountEnabled(true);
        this.config.setSummaryReportEnabled(true);
        this.config.setTippingEnabled(true);
        this.config.setLabelOperatorId("Operator ID");
        this.config.setLabelPayButton("Pay at Table");
        this.config.setLabelTableId("Table Number");
    }

    public PayAtTableConfig getConfig() {
        return this.config;
    }

    public void pushPayAtTableConfig() {
        this.spi.send(this.config.toMessage(RequestIdHelper.id("patconf")));
    }

    public void setGetBillStatusDelegate(GetBillStatusDelegate getBillStatusDelegate) {
        this.getBillStatusDelegate = getBillStatusDelegate;
    }

    public void setBillPaymentReceivedDelegate(BillPaymentReceivedDelegate billPaymentReceivedDelegate) {
        this.billPaymentReceivedDelegate = billPaymentReceivedDelegate;
    }

    void handleGetBillDetailsRequest(@NotNull Message m) {
        if (m == null) {
            SpiPayAtTable.$$$reportNull$$$0(0);
        }
        String operatorId = m.getDataStringValue("operator_id");
        String tableId = m.getDataStringValue("table_id");
        assert (this.getBillStatusDelegate != null);
        BillStatusResponse billStatus = this.getBillStatusDelegate.getBillStatus(null, tableId, operatorId);
        billStatus.setTableId(tableId);
        if (billStatus.getTotalAmount() <= 0) {
            LOG.info("Table has 0 total amount, not sending it to EFTPOS");
            billStatus.setResult(BillRetrievalResult.INVALID_TABLE_ID);
        }
        this.spi.send(billStatus.toMessage(m.getId()));
    }

    void handleBillPaymentAdvice(@NotNull Message m) {
        if (m == null) {
            SpiPayAtTable.$$$reportNull$$$0(1);
        }
        BillPayment billPayment = new BillPayment(m);
        assert (this.getBillStatusDelegate != null);
        BillStatusResponse existingBillStatus = this.getBillStatusDelegate.getBillStatus(billPayment.getBillId(), billPayment.getTableId(), billPayment.getOperatorId());
        if (existingBillStatus.getResult() != BillRetrievalResult.SUCCESS) {
            LOG.warn("Could not retrieve bill status for payment advice, sending error to EFTPOS");
            this.spi.send(existingBillStatus.toMessage(m.getId()));
        }
        List<PaymentHistoryEntry> existingPaymentHistory = existingBillStatus.getBillPaymentHistory();
        PaymentHistoryEntry foundExistingEntry = null;
        String referenceId = billPayment.getPurchaseResponse().getTerminalReferenceId();
        if (referenceId != null) {
            for (PaymentHistoryEntry phe : existingPaymentHistory) {
                if (!referenceId.equals(phe.getTerminalRefId())) continue;
                foundExistingEntry = phe;
                break;
            }
        }
        if (foundExistingEntry != null) {
            LOG.warn("Had already received this bill_payment advice from EFTPOS, ignoring");
            this.spi.send(existingBillStatus.toMessage(m.getId()));
            return;
        }
        assert (this.billPaymentReceivedDelegate != null);
        ArrayList<PaymentHistoryEntry> updatedHistoryEntries = new ArrayList<PaymentHistoryEntry>(existingPaymentHistory);
        updatedHistoryEntries.add(new PaymentHistoryEntry(billPayment.getPaymentType().toString().toLowerCase(), billPayment.getPurchaseResponse().toPaymentSummary()));
        String updatedBillData = BillStatusResponse.toBillData(updatedHistoryEntries);
        BillStatusResponse updatedBillStatus = this.billPaymentReceivedDelegate.getBillReceived(billPayment, updatedBillData);
        updatedBillStatus.setBillId(billPayment.getBillId());
        updatedBillStatus.setTableId(billPayment.getTableId());
        if (updatedBillStatus.getResult() != BillRetrievalResult.SUCCESS) {
            LOG.warn("POS threw error when being advised of payment, letting EFTPOS know, and sending existing bill data");
            updatedBillStatus.setBillData(existingBillStatus.getBillData());
        } else {
            updatedBillStatus.setBillData(updatedBillData);
        }
        this.spi.send(updatedBillStatus.toMessage(m.getId()));
    }

    void handleGetTableConfig(@NotNull Message m) {
        if (m == null) {
            SpiPayAtTable.$$$reportNull$$$0(2);
        }
        this.spi.send(this.config.toMessage(m.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "m";
        objectArray2[1] = "com/assemblypayments/spi/SpiPayAtTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleGetBillDetailsRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBillPaymentAdvice";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handleGetTableConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface BillPaymentReceivedDelegate {
        public BillStatusResponse getBillReceived(BillPayment var1, String var2);
    }

    public static interface GetBillStatusDelegate {
        public BillStatusResponse getBillStatus(String var1, String var2, String var3);
    }
}

