/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi;

import com.assemblypayments.spi.Spi;
import com.assemblypayments.spi.model.AccountVerifyRequest;
import com.assemblypayments.spi.model.InitiateTxResult;
import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.PreauthCancelRequest;
import com.assemblypayments.spi.model.PreauthCompletionRequest;
import com.assemblypayments.spi.model.PreauthExtendRequest;
import com.assemblypayments.spi.model.PreauthOpenRequest;
import com.assemblypayments.spi.model.PreauthPartialCancellationRequest;
import com.assemblypayments.spi.model.PreauthTopupRequest;
import com.assemblypayments.spi.model.SpiFlow;
import com.assemblypayments.spi.model.SpiStatus;
import com.assemblypayments.spi.model.TransactionFlowState;
import com.assemblypayments.spi.model.TransactionType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiPreauth {
    private static final Logger LOG = LoggerFactory.getLogger((String)"spipreauth");
    private final Spi spi;
    private final Object txLock;

    SpiPreauth(Spi spi, Object txLock) {
        this.spi = spi;
        this.txLock = txLock;
    }

    public InitiateTxResult initiateAccountVerifyTx(String posRefId) {
        Message verifyMsg = new AccountVerifyRequest(posRefId).toMessage();
        TransactionFlowState tfs = new TransactionFlowState(posRefId, TransactionType.ACCOUNT_VERIFY, 0, verifyMsg, "Waiting for EFTPOS connection to make account verify request");
        String sentMsg = "Asked EFTPOS to verify account";
        return this.initiatePreauthTx(tfs, sentMsg);
    }

    public InitiateTxResult initiateOpenTx(String posRefId, int amountCents) {
        Message msg = new PreauthOpenRequest(amountCents, posRefId).toMessage();
        TransactionFlowState tfs = new TransactionFlowState(posRefId, TransactionType.PREAUTH, amountCents, msg, String.format("Waiting for EFTPOS connection to make preauth request for %.2f", (double)amountCents / 100.0));
        String sentMsg = String.format("Asked EFTPOS to create preauth for %.2f", (double)amountCents / 100.0);
        return this.initiatePreauthTx(tfs, sentMsg);
    }

    public InitiateTxResult initiateTopupTx(String posRefId, String preauthId, int amountCents) {
        Message msg = new PreauthTopupRequest(preauthId, amountCents, posRefId).toMessage();
        TransactionFlowState tfs = new TransactionFlowState(posRefId, TransactionType.PREAUTH, amountCents, msg, String.format("Waiting for EFTPOS connection to make preauth topup request for %.2f", (double)amountCents / 100.0));
        String sentMsg = String.format("Asked EFTPOS to make preauth topup for %.2f", (double)amountCents / 100.0);
        return this.initiatePreauthTx(tfs, sentMsg);
    }

    public InitiateTxResult initiatePartialCancellationTx(String posRefId, String preauthId, int amountCents) {
        Message msg = new PreauthPartialCancellationRequest(preauthId, amountCents, posRefId).toMessage();
        TransactionFlowState tfs = new TransactionFlowState(posRefId, TransactionType.PREAUTH, amountCents, msg, String.format("Waiting for EFTPOS connection to make preauth partial cancellation request for %.2f", (double)amountCents / 100.0));
        String sentMsg = String.format("Asked EFTPOS to make preauth partial cancellation for %.2f", (double)amountCents / 100.0);
        return this.initiatePreauthTx(tfs, sentMsg);
    }

    public InitiateTxResult initiateExtendTx(String posRefId, String preauthId) {
        Message msg = new PreauthExtendRequest(preauthId, posRefId).toMessage();
        TransactionFlowState tfs = new TransactionFlowState(posRefId, TransactionType.PREAUTH, 0, msg, "Waiting for EFTPOS connection to make preauth extend request");
        String sentMsg = "Asked EFTPOS to make preauth extend request";
        return this.initiatePreauthTx(tfs, sentMsg);
    }

    public InitiateTxResult initiateCompletionTx(String posRefId, String preauthId, int amountCents) {
        return this.initiateCompletionTx(posRefId, preauthId, amountCents, 0);
    }

    public InitiateTxResult initiateCompletionTx(String posRefId, String preauthId, int amountCents, int surchargeAmount) {
        PreauthCompletionRequest request = new PreauthCompletionRequest(preauthId, amountCents, posRefId);
        request.setSurchargeAmount(surchargeAmount);
        Message msg = request.toMessage();
        TransactionFlowState tfs = new TransactionFlowState(posRefId, TransactionType.PREAUTH, amountCents, msg, String.format("Waiting for EFTPOS connection to make preauth completion request for %.2f", (double)amountCents / 100.0));
        String sentMsg = String.format("Asked EFTPOS to make preauth completion for %.2f", (double)amountCents / 100.0);
        return this.initiatePreauthTx(tfs, sentMsg);
    }

    public InitiateTxResult initiateCancelTx(String posRefId, String preauthId) {
        Message msg = new PreauthCancelRequest(preauthId, posRefId).toMessage();
        TransactionFlowState tfs = new TransactionFlowState(posRefId, TransactionType.PREAUTH, 0, msg, "Waiting for EFTPOS connection to make preauth cancellation request");
        String sentMsg = "Asked EFTPOS to make preauth cancellation request";
        return this.initiatePreauthTx(tfs, sentMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InitiateTxResult initiatePreauthTx(TransactionFlowState tfs, String sentMsg) {
        if (this.spi.getCurrentStatus() == SpiStatus.UNPAIRED) {
            return new InitiateTxResult(false, "Not Paired");
        }
        Object object = this.txLock;
        synchronized (object) {
            if (this.spi.getCurrentFlow() != SpiFlow.IDLE) {
                return new InitiateTxResult(false, "Not Idle");
            }
            this.spi.setCurrentFlow(SpiFlow.TRANSACTION);
            this.spi.setCurrentTxFlowState(tfs);
            if (this.spi.send(tfs.getRequest())) {
                this.spi.getCurrentTxFlowState().sent(sentMsg);
            }
        }
        this.spi.txFlowStateChanged();
        return new InitiateTxResult(true, "Preauth Initiated");
    }

    void handlePreauthMessage(@NotNull Message m) {
        if (m == null) {
            SpiPreauth.$$$reportNull$$$0(0);
        }
        if ("account_verify_response".equals(m.getEventName())) {
            this.handleAccountVerifyResponse(m);
        } else if ("preauth_response".equals(m.getEventName()) || "preauth_topup_response".equals(m.getEventName()) || "preauth_partial_cancellation_response".equals(m.getEventName()) || "preauth_extend_response".equals(m.getEventName()) || "completion_response".equals(m.getEventName()) || "preauth_cancellation_response".equals(m.getEventName())) {
            this.handlePreauthResponse(m);
        } else {
            LOG.info("I don't understand preauth event: " + m.getEventName() + ", " + m.getData() + ", perhaps I have not implemented it yet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAccountVerifyResponse(@NotNull Message m) {
        if (m == null) {
            SpiPreauth.$$$reportNull$$$0(1);
        }
        Object object = this.txLock;
        synchronized (object) {
            String incomingPosRefId = m.getDataStringValue("pos_ref_id");
            TransactionFlowState currentTxFlowState = this.spi.getCurrentTxFlowState();
            if (this.spi.getCurrentFlow() != SpiFlow.TRANSACTION || currentTxFlowState.isFinished() || !currentTxFlowState.getPosRefId().equals(incomingPosRefId)) {
                LOG.info("Received Account Verify response but I was not waiting for one, incoming Pos Ref ID: " + incomingPosRefId);
                return;
            }
            currentTxFlowState.completed(m.getSuccessState(), m, "Account Verify Transaction Ended.");
        }
        this.spi.txFlowStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePreauthResponse(@NotNull Message m) {
        if (m == null) {
            SpiPreauth.$$$reportNull$$$0(2);
        }
        Object object = this.txLock;
        synchronized (object) {
            String incomingPosRefId = m.getDataStringValue("pos_ref_id");
            TransactionFlowState currentTxFlowState = this.spi.getCurrentTxFlowState();
            if (this.spi.getCurrentFlow() != SpiFlow.TRANSACTION || currentTxFlowState.isFinished() || !currentTxFlowState.getPosRefId().equals(incomingPosRefId)) {
                LOG.info("Received preauth response but I was not waiting for one, incoming Pos Ref ID: " + incomingPosRefId);
                return;
            }
            currentTxFlowState.completed(m.getSuccessState(), m, "Preauth Transaction Ended.");
        }
        this.spi.txFlowStateChanged();
    }

    static boolean isPreauthEvent(@NotNull String eventName) {
        if (eventName == null) {
            SpiPreauth.$$$reportNull$$$0(3);
        }
        return eventName.startsWith("preauth") || "completion_response".equals(eventName) || "completion".equals(eventName) || "account_verify".equals(eventName) || "account_verify_response".equals(eventName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
        }
        objectArray2[1] = "com/assemblypayments/spi/SpiPreauth";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handlePreauthMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleAccountVerifyResponse";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "handlePreauthResponse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPreauthEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

