/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.AbstractTransactionResponse;
import com.assemblypayments.spi.model.Message;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChargeResponse
extends AbstractTransactionResponse {
    private final String schemeName;
    private final String posRefId;

    protected AbstractChargeResponse(@NotNull Message m) {
        if (m == null) {
            AbstractChargeResponse.$$$reportNull$$$0(0);
        }
        super(m);
        this.schemeName = m.getDataStringValue("scheme_name");
        this.posRefId = m.getDataStringValue("pos_ref_id");
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String getPosRefId() {
        return this.posRefId;
    }

    public String getCustomerReceipt() {
        return this.m.getDataStringValue("customer_receipt");
    }

    public String getResponseCode() {
        return this.m.getDataStringValue("host_response_code");
    }

    public String getTerminalReferenceId() {
        return this.m.getDataStringValue("terminal_ref_id");
    }

    public String getCardEntry() {
        return this.m.getDataStringValue("card_entry");
    }

    public String getAccountType() {
        return this.m.getDataStringValue("account_type");
    }

    public String getAuthCode() {
        return this.m.getDataStringValue("auth_code");
    }

    public String getBankDate() {
        return this.m.getDataStringValue("bank_date");
    }

    public String getBankTime() {
        return this.m.getDataStringValue("bank_time");
    }

    public String getMaskedPan() {
        return this.m.getDataStringValue("masked_pan");
    }

    public boolean wasMerchantReceiptPrinted() {
        return this.m.getDataBooleanValue("merchant_receipt_printed", false);
    }

    public boolean wasCustomerReceiptPrinted() {
        return this.m.getDataBooleanValue("customer_receipt_printed", false);
    }

    public Date getSettlementDate() {
        String dateStr = this.m.getDataStringValue("bank_settlement_date");
        try {
            return new SimpleDateFormat("ddMMyyyy", Locale.US).parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/assemblypayments/spi/model/AbstractChargeResponse", "<init>"));
    }
}

