/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.Message;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTransactionResponse {
    protected final Message m;

    protected AbstractTransactionResponse(@NotNull Message m) {
        if (m == null) {
            AbstractTransactionResponse.$$$reportNull$$$0(0);
        }
        Validate.notNull((Object)m, (String)"Cannot construct response with a null message!");
        this.m = m;
    }

    public String getRequestId() {
        return this.m.getId();
    }

    public Message.SuccessState getSuccessState() {
        return this.m.getSuccessState();
    }

    public boolean isSuccess() {
        return this.getSuccessState() == Message.SuccessState.SUCCESS;
    }

    @Deprecated
    public boolean getSuccess() {
        return this.isSuccess();
    }

    public String getRRN() {
        return this.m.getDataStringValue("rrn");
    }

    public String getMerchantReceipt() {
        return this.m.getDataStringValue("merchant_receipt");
    }

    public String getTerminalId() {
        return this.m.getDataStringValue("terminal_id");
    }

    public String getResponseText() {
        return this.m.getDataStringValue("host_response_text");
    }

    public String getResponseValue(String attribute) {
        return this.m.getDataStringValue(attribute);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/assemblypayments/spi/model/AbstractTransactionResponse", "<init>"));
    }
}

