/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.PaymentType;
import com.assemblypayments.spi.model.PurchaseResponse;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class BillPayment {
    private final String billId;
    private final String tableId;
    private final String operatorId;
    private final PaymentType paymentType;
    private final int purchaseAmount;
    private final int tipAmount;
    private final PurchaseResponse purchaseResponse;

    public BillPayment(@NotNull Message m) {
        if (m == null) {
            BillPayment.$$$reportNull$$$0(0);
        }
        Validate.notNull((Object)m, (String)"Cannot construct bill payment with a null message!");
        this.billId = m.getDataStringValue("bill_id");
        this.tableId = m.getDataStringValue("table_id");
        this.operatorId = m.getDataStringValue("operator_id");
        this.paymentType = PaymentType.parse(m.getDataStringValue("payment_type"));
        Message purchaseMsg = new Message(m.getId(), "payment_details", m.getDataMapValue("payment_details"), false);
        this.purchaseResponse = new PurchaseResponse(purchaseMsg);
        this.purchaseAmount = this.purchaseResponse.getPurchaseAmount();
        this.tipAmount = this.purchaseResponse.getTipAmount();
    }

    public String getBillId() {
        return this.billId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public int getPurchaseAmount() {
        return this.purchaseAmount;
    }

    public int getTipAmount() {
        return this.tipAmount;
    }

    public PurchaseResponse getPurchaseResponse() {
        return this.purchaseResponse;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/assemblypayments/spi/model/BillPayment", "<init>"));
    }
}

