/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.BillRetrievalResult;
import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.PaymentHistoryEntry;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class BillStatusResponse {
    private static final Gson GSON = new Gson();
    private BillRetrievalResult result;
    private String billId;
    private String tableId;
    private int totalAmount;
    private int outstandingAmount;
    private String billData;

    public BillRetrievalResult getResult() {
        return this.result;
    }

    public void setResult(BillRetrievalResult result) {
        this.result = result;
    }

    public String getBillId() {
        return this.billId;
    }

    public void setBillId(String billId) {
        this.billId = billId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public int getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(int totalAmount) {
        this.totalAmount = totalAmount;
    }

    public int getOutstandingAmount() {
        return this.outstandingAmount;
    }

    public void setOutstandingAmount(int outstandingAmount) {
        this.outstandingAmount = outstandingAmount;
    }

    public String getBillData() {
        return this.billData;
    }

    public void setBillData(String billData) {
        this.billData = billData;
    }

    public List<PaymentHistoryEntry> getBillPaymentHistory() {
        String billData = this.billData;
        if (billData == null || StringUtils.isWhitespace((String)billData)) {
            return new ArrayList<PaymentHistoryEntry>();
        }
        byte[] bdArray = Base64.decodeBase64((String)billData);
        String bdStr = new String(bdArray, Charsets.UTF_8);
        return (List)GSON.fromJson(bdStr, PaymentHistoryEntry.ListType.class);
    }

    public static String toBillData(List<PaymentHistoryEntry> ph) {
        if (ph.isEmpty()) {
            return "";
        }
        String bphStr = GSON.toJson(ph);
        return Base64.encodeBase64String((byte[])bphStr.getBytes(Charsets.UTF_8));
    }

    public Message toMessage(String messageId) {
        BillRetrievalResult result;
        String tableId;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("success", this.result == BillRetrievalResult.SUCCESS);
        String billId = this.billId;
        if (billId != null && !StringUtils.isWhitespace((String)billId)) {
            data.put("bill_id", billId);
        }
        if ((tableId = this.tableId) != null && !StringUtils.isWhitespace((String)tableId)) {
            data.put("table_id", tableId);
        }
        if ((result = this.result) == BillRetrievalResult.SUCCESS) {
            data.put("bill_total_amount", this.totalAmount);
            data.put("bill_outstanding_amount", this.outstandingAmount);
            data.put("bill_payment_history", this.getBillPaymentHistory());
        } else {
            data.put("error_reason", result.toString());
            data.put("error_detail", result.toString());
        }
        return new Message(messageId, "bill_details", data, true);
    }
}

