/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.Message;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class GetLastTransactionResponse {
    private final Message m;

    public GetLastTransactionResponse(@NotNull Message m) {
        if (m == null) {
            GetLastTransactionResponse.$$$reportNull$$$0(0);
        }
        Validate.notNull((Object)m, (String)"Cannot construct response with a null message!");
        this.m = m;
    }

    public boolean wasRetrievedSuccessfully() {
        return !StringUtils.isEmpty((String)this.getResponseCode());
    }

    public boolean wasTimeOutOfSyncError() {
        return this.m.getError().startsWith("TIME_OUT_OF_SYNC");
    }

    public boolean wasOperationInProgressError() {
        return this.m.getError().startsWith("OPERATION_IN_PROGRESS");
    }

    public boolean isWaitingForSignatureResponse() {
        return this.m.getError().startsWith("OPERATION_IN_PROGRESS_AWAITING_SIGNATURE");
    }

    public boolean isWaitingForAuthCode() {
        return this.m.getError().startsWith("OPERATION_IN_PROGRESS_AWAITING_PHONE_AUTH_CODE");
    }

    public boolean isStillInProgress(String posRefId) {
        return this.wasOperationInProgressError() && this.getPosRefId().equals(posRefId);
    }

    public Message.SuccessState getSuccessState() {
        return this.m.getSuccessState();
    }

    public boolean wasSuccessfulTx() {
        return this.m.getSuccessState() == Message.SuccessState.SUCCESS;
    }

    public String getTxType() {
        return this.getResponseValue("transaction_type");
    }

    public String getPosRefId() {
        return this.m.getDataStringValue("pos_ref_id");
    }

    @Deprecated
    public int getTransactionAmount() {
        return this.m.getDataIntValue("amount_transaction_type");
    }

    @Deprecated
    public String getBankDateTimeString() {
        return this.m.getDataStringValue("bank_date") + this.m.getDataStringValue("bank_time");
    }

    @Deprecated
    public String getRRN() {
        return this.m.getDataStringValue("rrn");
    }

    public String getResponseText() {
        return this.m.getDataStringValue("host_response_text");
    }

    public String getResponseCode() {
        return this.m.getDataStringValue("host_response_code");
    }

    public String getResponseValue(String attribute) {
        return this.m.getDataStringValue(attribute);
    }

    public void copyMerchantReceiptToCustomerReceipt() {
        String cr = this.m.getDataStringValue("customer_receipt");
        String mr = this.m.getDataStringValue("merchant_receipt");
        if (mr.length() > 0 && cr.length() == 0) {
            this.m.getData().put("customer_receipt", mr);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/assemblypayments/spi/model/GetLastTransactionResponse", "<init>"));
    }
}

