/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.MessageEnvelope;
import com.assemblypayments.spi.model.MessageStamp;
import com.assemblypayments.spi.model.Secrets;
import com.assemblypayments.spi.util.Crypto;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Message {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final Gson GSON = new Gson();
    private final transient boolean needsEncryption;
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="event")
    private String eventName;
    @SerializedName(value="data")
    private Map<String, Object> data;
    @SerializedName(value="datetime")
    private String dateTimeStamp;
    @SerializedName(value="pos_id")
    private String posId;
    private transient String incomingHmac;
    private transient String decryptedJson;

    public Message(String id, String eventName, Map<String, Object> data, boolean needsEncryption) {
        this.id = id;
        this.eventName = eventName;
        this.data = data;
        this.needsEncryption = needsEncryption;
    }

    public Message() {
        this.needsEncryption = false;
    }

    public static Message fromJson(String msgJson, Secrets secrets) {
        String decryptedJson;
        MessageEnvelope env = (MessageEnvelope)GSON.fromJson(msgJson, MessageEnvelope.class);
        if (env.getMessage() != null) {
            Message message = env.getMessage();
            message.setDecryptedJson(msgJson);
            return message;
        }
        if (secrets == null) {
            return new Message("UNKNOWN", "NOSECRETS", null, false);
        }
        String sig = Crypto.hmacSignature(secrets.getHmacKeyBytes(), env.getEnc());
        if (!sig.equals(env.getHmac())) {
            return new Message("_", "_INVALID_SIGNATURE_", null, false);
        }
        try {
            decryptedJson = Crypto.aesDecrypt(secrets.getEncKeyBytes(), env.getEnc());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            MessageEnvelope decryptedEnv = (MessageEnvelope)GSON.fromJson(decryptedJson, MessageEnvelope.class);
            Message message = decryptedEnv.getMessage();
            message.setIncomingHmac(env.getHmac());
            message.setDecryptedJson(decryptedJson);
            return decryptedEnv.getMessage();
        }
        catch (JsonSyntaxException e) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("msg", decryptedJson);
            return new Message("UNKNOWN", "UNPARSEABLE", data, false);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public String getDateTimeStamp() {
        return this.dateTimeStamp;
    }

    public String getPosId() {
        return this.posId;
    }

    public String getIncomingHmac() {
        return this.incomingHmac;
    }

    private void setIncomingHmac(String incomingHmac) {
        this.incomingHmac = incomingHmac;
    }

    public String getDecryptedJson() {
        return this.decryptedJson;
    }

    private void setDecryptedJson(String decryptedJson) {
        this.decryptedJson = decryptedJson;
    }

    @NotNull
    public SuccessState getSuccessState() {
        if (this.data == null) {
            SuccessState successState = SuccessState.UNKNOWN;
            if (successState == null) {
                Message.$$$reportNull$$$0(0);
            }
            return successState;
        }
        Object success = this.data.get("success");
        if (success instanceof Boolean) {
            SuccessState successState = (Boolean)success != false ? SuccessState.SUCCESS : SuccessState.FAILED;
            if (successState == null) {
                Message.$$$reportNull$$$0(1);
            }
            return successState;
        }
        SuccessState successState = SuccessState.UNKNOWN;
        if (successState == null) {
            Message.$$$reportNull$$$0(2);
        }
        return successState;
    }

    public String getError() {
        Object e = this.data.get("error_reason");
        if (e instanceof String) {
            return (String)e;
        }
        return null;
    }

    public String getErrorDetail() {
        return this.getDataStringValue("error_detail");
    }

    @NotNull
    public String getDataStringValue(String attribute) {
        Object v = this.data.get(attribute);
        if (v instanceof String) {
            String string = (String)v;
            if (string == null) {
                Message.$$$reportNull$$$0(3);
            }
            return string;
        }
        if ("" == null) {
            Message.$$$reportNull$$$0(4);
        }
        return "";
    }

    public int getDataIntValue(String attribute) {
        Object v = this.data.get(attribute);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof Double) {
            return ((Double)v).intValue();
        }
        if (v instanceof String) {
            return Integer.parseInt((String)v);
        }
        return 0;
    }

    public boolean getDataBooleanValue(String attribute, boolean defaultIfNotFound) {
        Object v = this.data.get(attribute);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return Boolean.parseBoolean((String)v);
        }
        return defaultIfNotFound;
    }

    @NotNull
    public Map<String, Object> getDataMapValue(String attribute) {
        Object v = this.data.get(attribute);
        if (v instanceof Map) {
            Map map = (Map)v;
            if (map == null) {
                Message.$$$reportNull$$$0(5);
            }
            return map;
        }
        Map<String, Object> map = Collections.emptyMap();
        if (map == null) {
            Message.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public List<Object> getDataListValue(String attribute) {
        Object v = this.data.get(attribute);
        if (v instanceof List) {
            List list = (List)v;
            if (list == null) {
                Message.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<Object> list = Collections.emptyList();
        if (list == null) {
            Message.$$$reportNull$$$0(8);
        }
        return list;
    }

    public long getServerTimeDelta() {
        long now = System.currentTimeMillis();
        try {
            long msgTime = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.US).parse(this.dateTimeStamp).getTime();
            return msgTime - now;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson(MessageStamp stamp) {
        String encMsg;
        long now = System.currentTimeMillis();
        long adjustedTime = now + stamp.getServerTimeDelta();
        this.dateTimeStamp = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.US).format(new Date(adjustedTime));
        if (!this.needsEncryption) {
            this.posId = stamp.getPosId();
        }
        this.decryptedJson = GSON.toJson((Object)new MessageEnvelope(this));
        if (!this.needsEncryption) {
            return this.decryptedJson;
        }
        try {
            encMsg = Crypto.aesEncrypt(stamp.getSecrets().getEncKeyBytes(), this.decryptedJson);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        String hmacSig = Crypto.hmacSignature(stamp.getSecrets().getHmacKeyBytes(), encMsg);
        MessageEnvelope encrMessageEnvelope = new MessageEnvelope(encMsg, hmacSig, stamp.getPosId());
        return GSON.toJson((Object)encrMessageEnvelope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/assemblypayments/spi/model/Message";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataStringValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataMapValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataListValue";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static interface Compatible {
        public Message toMessage();
    }

    public static enum SuccessState {
        UNKNOWN,
        SUCCESS,
        FAILED;

    }
}

