/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.PurchaseResponse;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class PreauthResponse {
    private final String posRefId;
    private final String preauthId;
    private final PurchaseResponse details;
    private final Message m;

    public PreauthResponse(@NotNull Message m) {
        if (m == null) {
            PreauthResponse.$$$reportNull$$$0(0);
        }
        Validate.notNull((Object)m, (String)"Cannot construct response with a null message!");
        this.m = m;
        this.preauthId = m.getDataStringValue("preauth_id");
        this.details = new PurchaseResponse(m);
        this.posRefId = this.details.getPosRefId();
    }

    public String getPosRefId() {
        return this.posRefId;
    }

    public String getPreauthId() {
        return this.preauthId;
    }

    public PurchaseResponse getDetails() {
        return this.details;
    }

    public int getBalanceAmount() {
        String txType = this.m.getDataStringValue("transaction_type");
        if ("PRE-AUTH".equals(txType)) {
            return this.m.getDataIntValue("preauth_amount");
        }
        if ("TOPUP".equals(txType)) {
            return this.m.getDataIntValue("balance_amount");
        }
        if ("CANCEL".equals(txType)) {
            return this.m.getDataIntValue("balance_amount");
        }
        if ("PRE-AUTH EXT".equals(txType)) {
            return this.m.getDataIntValue("balance_amount");
        }
        if ("PCOMP".equals(txType)) {
            return 0;
        }
        if ("PRE-AUTH CANCEL".equals(txType)) {
            return 0;
        }
        return 0;
    }

    public int getPreviousBalanceAmount() {
        String txType = this.m.getDataStringValue("transaction_type");
        if ("PRE-AUTH".equals(txType)) {
            return 0;
        }
        if ("TOPUP".equals(txType)) {
            return this.m.getDataIntValue("existing_preauth_amount");
        }
        if ("CANCEL".equals(txType)) {
            return this.m.getDataIntValue("existing_preauth_amount");
        }
        if ("PRE-AUTH EXT".equals(txType)) {
            return this.m.getDataIntValue("existing_preauth_amount");
        }
        if ("PCOMP".equals(txType)) {
            return this.m.getDataIntValue("completion_amount");
        }
        if ("PRE-AUTH CANCEL".equals(txType)) {
            return this.m.getDataIntValue("preauth_amount");
        }
        return 0;
    }

    public int getCompletionAmount() {
        String txType = this.m.getDataStringValue("transaction_type");
        if ("PCOMP".equals(txType)) {
            return this.m.getDataIntValue("completion_amount");
        }
        return 0;
    }

    public int getCompletionSurchargeAmount() {
        String txType = this.m.getDataStringValue("transaction_type");
        if ("PCOMP".equals(txType)) {
            return this.m.getDataIntValue("surcharge_amount");
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/assemblypayments/spi/model/PreauthResponse", "<init>"));
    }
}

