/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.AbstractChargeRequest;
import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.util.RequestIdHelper;
import java.util.HashMap;

public class PurchaseRequest
extends AbstractChargeRequest
implements Message.Compatible {
    private final int purchaseAmount;
    private int tipAmount;
    private int cashoutAmount;
    private boolean promptForCashout;
    private int surchargeAmount;

    public PurchaseRequest(int amountCents, String posRefId) {
        super(posRefId);
        this.purchaseAmount = amountCents;
    }

    public int getPurchaseAmount() {
        return this.purchaseAmount;
    }

    public int getTipAmount() {
        return this.tipAmount;
    }

    public void setTipAmount(int tipAmount) {
        this.tipAmount = tipAmount;
    }

    public int getCashoutAmount() {
        return this.cashoutAmount;
    }

    public void setCashoutAmount(int cashoutAmount) {
        this.cashoutAmount = cashoutAmount;
    }

    public boolean isPromptForCashout() {
        return this.promptForCashout;
    }

    public void setPromptForCashout(boolean promptForCashout) {
        this.promptForCashout = promptForCashout;
    }

    public int getSurchargeAmount() {
        return this.surchargeAmount;
    }

    public void setSurchargeAmount(int surchargeAmount) {
        this.surchargeAmount = surchargeAmount;
    }

    @Deprecated
    public String getId() {
        return this.getPosRefId();
    }

    @Deprecated
    public int getAmountCents() {
        return this.purchaseAmount;
    }

    public String amountSummary() {
        return String.format("Purchase: %.2f; Tip: %.2f; Cashout: %.2f; Surcharge: %.2f;", (double)this.getPurchaseAmount() / 100.0, (double)this.getTipAmount() / 100.0, (double)this.getCashoutAmount() / 100.0, (double)this.getSurchargeAmount() / 100.0);
    }

    @Override
    public Message toMessage() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("purchase_amount", this.getPurchaseAmount());
        data.put("tip_amount", this.getTipAmount());
        data.put("cash_amount", this.getCashoutAmount());
        data.put("prompt_for_cashout", this.isPromptForCashout());
        data.put("surcharge_amount", this.getSurchargeAmount());
        return this.toMessage(RequestIdHelper.id("prchs"), "purchase", data, true);
    }
}

