/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import java.util.Map;

public class SchemeSettlementEntry {
    private final String schemeName;
    private final boolean settleByAcquirer;
    private final int totalCount;
    private final int totalValue;

    public SchemeSettlementEntry(String schemeName, boolean settleByAcquirer, int totalCount, int totalValue) {
        this.schemeName = schemeName;
        this.settleByAcquirer = settleByAcquirer;
        this.totalCount = totalCount;
        this.totalValue = totalValue;
    }

    public SchemeSettlementEntry(Map<String, Object> jo) {
        this.schemeName = (String)jo.get("scheme_name");
        this.settleByAcquirer = "yes".equals(((String)jo.get("settle_by_acquirer")).toLowerCase());
        int totalValue = 0;
        try {
            totalValue = Integer.parseInt((String)jo.get("total_value"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.totalValue = totalValue;
        int totalCount = 0;
        try {
            totalCount = Integer.parseInt((String)jo.get("total_count"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.totalCount = totalCount;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public boolean isSettleByAcquirer() {
        return this.settleByAcquirer;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getTotalValue() {
        return this.totalValue;
    }

    public String toString() {
        return "SchemeName: " + this.schemeName + ", SettleByAcquirer: " + this.settleByAcquirer + ", TotalCount: " + this.totalCount + ", TotalValue: " + this.totalValue;
    }
}

