/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.AbstractTransactionResponse;
import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.SchemeSettlementEntry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Settlement
extends AbstractTransactionResponse {
    public Settlement(@NotNull Message m) {
        if (m == null) {
            Settlement.$$$reportNull$$$0(0);
        }
        super(m);
    }

    public int getSettleByAcquirerCount() {
        return this.m.getDataIntValue("accumulated_settle_by_acquirer_count");
    }

    public int getSettleByAcquirerValue() {
        return this.m.getDataIntValue("accumulated_settle_by_acquirer_value");
    }

    public int getTotalCount() {
        return this.m.getDataIntValue("accumulated_total_count");
    }

    public int getTotalValue() {
        return this.m.getDataIntValue("accumulated_total_value");
    }

    public long getPeriodStartTime() {
        String timeStr = this.m.getDataStringValue("settlement_period_start_time");
        String dateStr = this.m.getDataStringValue("settlement_period_start_date");
        try {
            return new SimpleDateFormat("HH:mmddMMMyy", Locale.US).parse(timeStr + dateStr).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse PeriodStartTime", e);
        }
    }

    public long getPeriodEndTime() {
        String timeStr = this.m.getDataStringValue("settlement_period_end_time");
        String dateStr = this.m.getDataStringValue("settlement_period_end_date");
        try {
            return new SimpleDateFormat("HH:mmddMMMyy", Locale.US).parse(timeStr + dateStr).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse PeriodEndTime", e);
        }
    }

    public long getTriggeredTime() {
        String timeStr = this.m.getDataStringValue("settlement_triggered_time");
        String dateStr = this.m.getDataStringValue("settlement_triggered_date");
        try {
            return new SimpleDateFormat("HH:mm:ssddMMMyy", Locale.US).parse(timeStr + dateStr).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Cannot parse TriggeredTime", e);
        }
    }

    @Deprecated
    public String getReceipt() {
        return this.getMerchantReceipt();
    }

    public String getTransactionRange() {
        return this.m.getDataStringValue("transaction_range");
    }

    @Override
    public String getTerminalId() {
        return this.m.getDataStringValue("terminal_id");
    }

    public Iterable<SchemeSettlementEntry> getSchemeSettlementEntries() {
        List<Object> schemes = this.m.getDataListValue("schemes");
        ArrayList<SchemeSettlementEntry> entries = new ArrayList<SchemeSettlementEntry>();
        for (Object scheme : schemes) {
            if (!(scheme instanceof Map)) continue;
            entries.add(new SchemeSettlementEntry((Map)scheme));
        }
        return entries;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/assemblypayments/spi/model/Settlement", "<init>"));
    }
}

