/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.model;

import com.assemblypayments.spi.model.Message;
import com.assemblypayments.spi.model.PhoneForAuthRequired;
import com.assemblypayments.spi.model.SignatureRequired;
import com.assemblypayments.spi.model.TransactionType;

public class TransactionFlowState {
    private String posRefId;
    private TransactionType type;
    private String displayMessage;
    private int amountCents;
    private boolean requestSent;
    private long requestTime;
    private long lastStateRequestTime;
    private String lastGltRequestId;
    private boolean attemptingToCancel;
    private boolean awaitingSignatureCheck;
    private boolean awaitingPhoneForAuth;
    private boolean finished;
    private Message.SuccessState success;
    private Message response;
    private SignatureRequired signatureRequiredMessage;
    private PhoneForAuthRequired phoneForAuthRequiredMessage;
    private long cancelAttemptTime;
    private Message request;
    private boolean awaitingGltResponse;
    private String gltResponsePosRefId;

    public TransactionFlowState(String posRefId, TransactionType type, int amountCents, Message message, String msg) {
        this.posRefId = posRefId;
        this.type = type;
        this.amountCents = amountCents;
        this.requestSent = false;
        this.awaitingSignatureCheck = false;
        this.finished = false;
        this.success = Message.SuccessState.UNKNOWN;
        this.request = message;
        this.displayMessage = msg;
    }

    public void sent(String msg) {
        this.requestSent = true;
        this.requestTime = System.currentTimeMillis();
        this.lastStateRequestTime = System.currentTimeMillis();
        this.displayMessage = msg;
    }

    public void cancelling(String msg) {
        this.attemptingToCancel = true;
        this.cancelAttemptTime = System.currentTimeMillis();
        this.displayMessage = msg;
    }

    public void cancelFailed(String msg) {
        this.attemptingToCancel = false;
        this.displayMessage = msg;
    }

    public void callingGlt(String gltRequestId) {
        this.awaitingGltResponse = true;
        this.lastStateRequestTime = System.currentTimeMillis();
        this.lastGltRequestId = gltRequestId;
    }

    public void gotGltResponse() {
        this.awaitingGltResponse = false;
    }

    public void failed(Message response, String msg) {
        this.success = Message.SuccessState.FAILED;
        this.finished = true;
        this.response = response;
        this.displayMessage = msg;
    }

    public void signatureRequired(SignatureRequired spiMessage, String msg) {
        this.signatureRequiredMessage = spiMessage;
        this.awaitingSignatureCheck = true;
        this.displayMessage = msg;
    }

    public void signatureResponded(String msg) {
        this.awaitingSignatureCheck = false;
        this.displayMessage = msg;
    }

    public void phoneForAuthRequired(PhoneForAuthRequired spiMessage, String msg) {
        this.phoneForAuthRequiredMessage = spiMessage;
        this.awaitingPhoneForAuth = true;
        this.displayMessage = msg;
    }

    public void authCodeSent(String msg) {
        this.awaitingPhoneForAuth = false;
        this.displayMessage = msg;
    }

    public void completed(Message.SuccessState state, Message response, String msg) {
        this.success = state;
        this.response = response;
        this.finished = true;
        this.attemptingToCancel = false;
        this.awaitingGltResponse = false;
        this.awaitingSignatureCheck = false;
        this.displayMessage = msg;
    }

    public void unknownCompleted(String msg) {
        this.success = Message.SuccessState.UNKNOWN;
        this.response = null;
        this.finished = true;
        this.attemptingToCancel = false;
        this.awaitingGltResponse = false;
        this.awaitingSignatureCheck = false;
        this.displayMessage = msg;
    }

    public String getPosRefId() {
        return this.posRefId;
    }

    public void setPosRefId(String posRefId) {
        this.posRefId = posRefId;
    }

    @Deprecated
    public String getId() {
        return this.getPosRefId();
    }

    @Deprecated
    public void setId(String id) {
        this.setPosRefId(id);
    }

    public TransactionType getType() {
        return this.type;
    }

    public void setType(TransactionType type) {
        this.type = type;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public int getAmountCents() {
        return this.amountCents;
    }

    public void setAmountCents(int amountCents) {
        this.amountCents = amountCents;
    }

    public boolean isRequestSent() {
        return this.requestSent;
    }

    public void setRequestSent(boolean requestSent) {
        this.requestSent = requestSent;
    }

    public long getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(long requestTime) {
        this.requestTime = requestTime;
    }

    public long getLastStateRequestTime() {
        return this.lastStateRequestTime;
    }

    public void setLastStateRequestTime(long lastStateRequestTime) {
        this.lastStateRequestTime = lastStateRequestTime;
    }

    public String getLastGltRequestId() {
        return this.lastGltRequestId;
    }

    public void setLastGltRequestId(String lastGltRequestId) {
        this.lastGltRequestId = lastGltRequestId;
    }

    public boolean isAttemptingToCancel() {
        return this.attemptingToCancel;
    }

    public void setAttemptingToCancel(boolean attemptingToCancel) {
        this.attemptingToCancel = attemptingToCancel;
    }

    public boolean isAwaitingSignatureCheck() {
        return this.awaitingSignatureCheck;
    }

    public void setAwaitingSignatureCheck(boolean awaitingSignatureCheck) {
        this.awaitingSignatureCheck = awaitingSignatureCheck;
    }

    public boolean isAwaitingPhoneForAuth() {
        return this.awaitingPhoneForAuth;
    }

    public void setAwaitingPhoneForAuth(boolean awaitingPhoneForAuth) {
        this.awaitingPhoneForAuth = awaitingPhoneForAuth;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public Message.SuccessState getSuccess() {
        return this.success;
    }

    public void setSuccess(Message.SuccessState success) {
        this.success = success;
    }

    public Message getResponse() {
        return this.response;
    }

    public void setResponse(Message response) {
        this.response = response;
    }

    public SignatureRequired getSignatureRequiredMessage() {
        return this.signatureRequiredMessage;
    }

    public void setSignatureRequiredMessage(SignatureRequired signatureRequiredMessage) {
        this.signatureRequiredMessage = signatureRequiredMessage;
    }

    public PhoneForAuthRequired getPhoneForAuthRequiredMessage() {
        return this.phoneForAuthRequiredMessage;
    }

    public void setPhoneForAuthRequiredMessage(PhoneForAuthRequired phoneForAuthRequiredMessage) {
        this.phoneForAuthRequiredMessage = phoneForAuthRequiredMessage;
    }

    public long getCancelAttemptTime() {
        return this.cancelAttemptTime;
    }

    public void setCancelAttemptTime(long cancelAttemptTime) {
        this.cancelAttemptTime = cancelAttemptTime;
    }

    public Message getRequest() {
        return this.request;
    }

    public void setRequest(Message request) {
        this.request = request;
    }

    public boolean isAwaitingGltResponse() {
        return this.awaitingGltResponse;
    }

    public void setAwaitingGltResponse(boolean awaitingGltResponse) {
        this.awaitingGltResponse = awaitingGltResponse;
    }

    public String getGltResponsePosRefId() {
        return this.gltResponsePosRefId;
    }

    public void setGltResponsePosRefId(String gltResponsePosRefId) {
        this.gltResponsePosRefId = gltResponsePosRefId;
    }
}

