/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.service;

import com.assemblypayments.spi.model.DeviceAddressStatus;
import com.google.gson.Gson;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceService {
    private static final Logger LOG = LoggerFactory.getLogger((String)"spi");
    private OkHttpClient okHttpClient = new OkHttpClient();
    private Gson gson = new Gson();

    public DeviceAddressStatus retrieveService(String serialNumber, String apiKey, String acquirerCode, boolean isTestMode) {
        String envSuffix = "";
        DeviceAddressStatus deviceAddressStatus = new DeviceAddressStatus();
        if (isTestMode) {
            envSuffix = "-sb";
        }
        String deviceAddressUrl = String.format("https://device-address-api%s.%s.msp.assemblypayments.com/v1/%s/ip", envSuffix, acquirerCode, serialNumber);
        try {
            Request request = new Request.Builder().url(deviceAddressUrl).addHeader("ASM-MSP-DEVICE-ADDRESS-API-KEY", apiKey).build();
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.body() != null) {
                deviceAddressStatus = (DeviceAddressStatus)this.gson.fromJson(response.body().string(), DeviceAddressStatus.class);
            }
            return deviceAddressStatus;
        }
        catch (IOException ex) {
            LOG.error("DeviceAddressStatus: " + ex.getMessage());
            return deviceAddressStatus;
        }
    }
}

