/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.util;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;

public final class Crypto {
    private static final char[] HEX_ALPHABET = "0123456789ABCDEF".toCharArray();

    private Crypto() {
    }

    public static String aesDecrypt(byte[] key, String encMessage) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        byte[] inputBuffer = Crypto.hexStringToByteArray(encMessage);
        IvParameterSpec iv = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)secretKeySpec, iv);
        byte[] plainTextBytes = cipher.doFinal(inputBuffer);
        return new String(plainTextBytes, Charsets.UTF_8);
    }

    public static String aesEncrypt(byte[] key, String message) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        byte[] inputBuffer = message.getBytes(Charsets.UTF_8);
        IvParameterSpec iv = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(1, (Key)secretKeySpec, iv);
        byte[] cipherTextBytes = cipher.doFinal(inputBuffer);
        return Crypto.byteArrayToHexString(cipherTextBytes);
    }

    public static String hmacSignature(byte[] key, String messageToSign) {
        byte[] msgBytes = messageToSign.getBytes(Charsets.UTF_8);
        Mac mac = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_SHA_256, (byte[])key);
        return Crypto.byteArrayToHexString(mac.doFinal(msgBytes));
    }

    public static String byteArrayToHexString(byte[] ba) {
        char[] hexChars = new char[ba.length * 2];
        for (int j = 0; j < ba.length; ++j) {
            int v = ba[j] & 0xFF;
            hexChars[j * 2] = HEX_ALPHABET[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ALPHABET[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToByteArray(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    public static void checkCompatibility() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, CompatibilityValidationException {
        byte[] key = new byte[32];
        String message = "MESSAGE";
        String cipherText = Crypto.aesEncrypt(key, "MESSAGE");
        String plainText = Crypto.aesDecrypt(key, cipherText);
        if (!"MESSAGE".equals(plainText)) {
            throw new CompatibilityValidationException("Decrypted text mismatch");
        }
    }

    public static class CompatibilityValidationException
    extends GeneralSecurityException {
        public CompatibilityValidationException(String message) {
            super(message);
        }
    }
}

