/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.util;

import com.assemblypayments.spi.model.KeyRequest;
import com.assemblypayments.spi.model.KeyResponse;
import com.assemblypayments.spi.model.PairRequest;
import com.assemblypayments.spi.model.Secrets;
import com.assemblypayments.spi.model.SecretsAndKeyResponse;
import com.assemblypayments.spi.util.Crypto;
import com.assemblypayments.spi.util.DiffieHellman;
import java.math.BigInteger;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public final class PairingHelper {
    private PairingHelper() {
    }

    public static PairRequest newPairRequest() {
        return new PairRequest();
    }

    public static SecretsAndKeyResponse generateSecretsAndKeyResponse(KeyRequest keyRequest) {
        PublicKeyAndSecret encPubAndSec = PairingHelper.calculateMyPublicKeyAndSecret(keyRequest.getAenc());
        String benc = encPubAndSec.getMyPublicKey();
        String senc = encPubAndSec.getSharedSecretKey();
        PublicKeyAndSecret hmacPubAndSec = PairingHelper.calculateMyPublicKeyAndSecret(keyRequest.getAhmac());
        String bhmac = hmacPubAndSec.getMyPublicKey();
        String shmac = hmacPubAndSec.getSharedSecretKey();
        Secrets secrets = new Secrets(senc, shmac);
        KeyResponse keyResponse = new KeyResponse(keyRequest.getRequestId(), benc, bhmac);
        return new SecretsAndKeyResponse(secrets, keyResponse);
    }

    private static PublicKeyAndSecret calculateMyPublicKeyAndSecret(String theirPublicKey) {
        BigInteger modp2048P = new BigInteger("32317006071311007300338913926423828248817941241140239112842009751400741706634354222619689417363569347117901737909704191754605873209195028853758986185622153212175412514901774520270235796078236248884246189477587641105928646099411723245426622522193230540919037680524235519125679715870117001058055877651038861847280257976054903569732561526167081339361799541336476559160368317896729073178384589680639671900977202194168647225871031411336429319536193471636533209717077448227988588565369208645296636077250268955505928362751121174096972998068410554359584866583291642136218231078990999448652468262416972035911852507045361090559");
        BigInteger modp2048G = BigInteger.valueOf(2L);
        BigInteger theirPublicBI = PairingHelper.spiAHexStringToBigInteger(theirPublicKey);
        BigInteger myPrivateBI = DiffieHellman.randomPrivateKey(modp2048P);
        BigInteger myPublicBI = DiffieHellman.publicKey(modp2048P, modp2048G, myPrivateBI);
        BigInteger secretBI = DiffieHellman.secret(modp2048P, theirPublicBI, myPrivateBI);
        String myPublic = myPublicBI.toString(16).toUpperCase();
        String secret = PairingHelper.dhSecretToSPISecret(secretBI);
        return new PublicKeyAndSecret(myPublic, secret);
    }

    public static BigInteger spiAHexStringToBigInteger(String hexStringA) {
        return new BigInteger("00" + hexStringA.toLowerCase(), 16);
    }

    public static String dhSecretToSPISecret(BigInteger secretBI) {
        String mySecretHex = secretBI.toString(16).toUpperCase();
        if (mySecretHex.length() == 513) {
            mySecretHex = mySecretHex.substring(1);
        }
        if (mySecretHex.length() < 512) {
            mySecretHex = StringUtils.leftPad((String)mySecretHex, (int)512, (char)'0');
        }
        MessageDigest digest = DigestUtils.getSha256Digest();
        return Crypto.byteArrayToHexString(digest.digest(Crypto.hexStringToByteArray(mySecretHex)));
    }

    private static class PublicKeyAndSecret {
        private final String myPublicKey;
        private final String sharedSecretKey;

        public PublicKeyAndSecret(String myPublicKey, String sharedSecretKey) {
            this.myPublicKey = myPublicKey;
            this.sharedSecretKey = sharedSecretKey;
        }

        public String getMyPublicKey() {
            return this.myPublicKey;
        }

        public String getSharedSecretKey() {
            return this.sharedSecretKey;
        }
    }
}

