/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.util;

import com.assemblypayments.spi.model.PurchaseRequest;
import com.assemblypayments.spi.model.RefundRequest;

public final class PurchaseHelper {
    private PurchaseHelper() {
    }

    public static PurchaseRequest createPurchaseRequest(int purchaseAmount, String posRefId) {
        return PurchaseHelper.createPurchaseRequest(purchaseAmount, posRefId, 0, 0, false);
    }

    public static PurchaseRequest createPurchaseRequest(int purchaseAmount, String posRefId, int tipAmount, int cashoutAmount, boolean promptForCashout) {
        return PurchaseHelper.createPurchaseRequest(purchaseAmount, posRefId, tipAmount, cashoutAmount, promptForCashout, 0);
    }

    public static PurchaseRequest createPurchaseRequest(int purchaseAmount, String posRefId, int tipAmount, int cashoutAmount, boolean promptForCashout, int surchargeAmount) {
        PurchaseRequest request = new PurchaseRequest(purchaseAmount, posRefId);
        request.setCashoutAmount(cashoutAmount);
        request.setTipAmount(tipAmount);
        request.setPromptForCashout(promptForCashout);
        request.setSurchargeAmount(surchargeAmount);
        return request;
    }

    public static RefundRequest createRefundRequest(int amountCents, String purchaseId) {
        return PurchaseHelper.createRefundRequest(amountCents, purchaseId, false);
    }

    public static RefundRequest createRefundRequest(int amountCents, String purchaseId, boolean isSuppressMerchantPassword) {
        RefundRequest request = new RefundRequest(amountCents, purchaseId);
        request.setSuppressMerchantPassword(isSuppressMerchantPassword);
        return request;
    }
}

