/*
 * Decompiled with CFR 0.152.
 */
package com.assemblypayments.spi.util;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class RandomHelper {
    private static final SecureRandom RANDOM_GEN = new SecureRandom();

    private RandomHelper() {
    }

    public static BigInteger randomBigIntMethod1(BigInteger max) {
        BigInteger randBigInt;
        byte[] bytes = max.toByteArray();
        do {
            RANDOM_GEN.nextBytes(bytes);
            int n = bytes.length - 1;
            bytes[n] = (byte)(bytes[n] & 0x7F);
        } while ((randBigInt = new BigInteger(bytes)).compareTo(max) >= 0);
        return randBigInt;
    }

    public static BigInteger randomBigIntMethod2(BigInteger max) {
        String maxIntString = max.toString();
        StringBuilder randomIntString = new StringBuilder();
        boolean below = false;
        int iN = maxIntString.length();
        for (int i = 0; i < iN; ++i) {
            char thisDigit = maxIntString.charAt(i);
            int maxDigit = !below ? thisDigit - 48 : 9;
            int rDigit = RANDOM_GEN.nextInt(10);
            if (rDigit > maxDigit) {
                rDigit = 0;
            }
            randomIntString.append(rDigit);
            if (rDigit >= maxDigit) continue;
            below = true;
        }
        return new BigInteger(randomIntString.toString());
    }
}

