/*
 * Decompiled with CFR 0.152.
 */
package ordermate.encryption;

import java.security.SecureRandom;
import java.util.Random;
import ordermate.encryption.BinConverter;
import ordermate.encryption.BlowfishCBC;
import ordermate.encryption.SHA1;

public class BlowfishEasy {
    BlowfishCBC m_bfish;
    static SecureRandom _srnd = new SecureRandom();

    public BlowfishEasy(String sPassword) {
        SHA1 sh = null;
        sh = new SHA1();
        int nI = 0;
        int nC = sPassword.length();
        while (nI < nC) {
            sh.update((byte)(sPassword.charAt(nI) & 0xFF));
            ++nI;
        }
        sh.finalize();
        byte[] hash = new byte[20];
        sh.getDigest(hash, 0);
        this.m_bfish = new BlowfishCBC(hash, 0, hash.length, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encryptString(String sPlainText) {
        long lCBCIV;
        SecureRandom secureRandom = _srnd;
        synchronized (secureRandom) {
            lCBCIV = _srnd.nextLong();
        }
        return this.encStr(sPlainText, lCBCIV);
    }

    public String encryptString(String sPlainText, Random rndGen) {
        return this.encStr(sPlainText, rndGen.nextLong());
    }

    private String encStr(String sPlainText, long lNewCBCIV) {
        int nStrLen = sPlainText.length();
        byte[] buf = new byte[(nStrLen << 1 & 0xFFFFFFF8) + 8];
        int nPos = 0;
        int nI = 0;
        while (nI < nStrLen) {
            char cActChar = sPlainText.charAt(nI);
            buf[nPos++] = (byte)(cActChar >> 8 & 0xFF);
            buf[nPos++] = (byte)(cActChar & 0xFF);
            ++nI;
        }
        byte bPadVal = (byte)(buf.length - (nStrLen << 1));
        while (nPos < buf.length) {
            buf[nPos++] = bPadVal;
        }
        this.m_bfish.setCBCIV(lNewCBCIV);
        this.m_bfish.encrypt(buf, 0, buf, 0, buf.length);
        byte[] newCBCIV = new byte[8];
        BinConverter.longToByteArray(lNewCBCIV, newCBCIV, 0);
        return String.valueOf(BinConverter.bytesToHexStr(newCBCIV, 0, 8)) + BinConverter.bytesToHexStr(buf, 0, buf.length);
    }

    public String decryptString(String sCipherText) {
        int nLen = sCipherText.length() >> 1 & 0xFFFFFFF8;
        if (8 > nLen) {
            return null;
        }
        byte[] cbciv = new byte[8];
        int nNumOfBytes = BinConverter.hexStrToBytes(sCipherText, cbciv, 0, 0, 8);
        if (nNumOfBytes < 8) {
            return null;
        }
        this.m_bfish.setCBCIV(cbciv, 0);
        if ((nLen -= 8) == 0) {
            return "";
        }
        byte[] buf = new byte[nLen];
        nNumOfBytes = BinConverter.hexStrToBytes(sCipherText, buf, 16, 0, nLen);
        if (nNumOfBytes < nLen) {
            return null;
        }
        this.m_bfish.decrypt(buf, 0, buf, 0, buf.length);
        int nPadByte = buf[buf.length - 1] & 0xFF;
        if (8 < nPadByte) {
            nPadByte = 0;
        }
        if ((nNumOfBytes -= nPadByte) < 0) {
            return "";
        }
        return BinConverter.byteArrayToStr(buf, 0, nNumOfBytes);
    }

    public void destroy() {
        this.m_bfish.cleanUp();
    }
}

