/*
 * Decompiled with CFR 0.152.
 */
package ordermate.encryption;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import ordermate.encryption.BlowfishCBC;
import ordermate.encryption.SHA1;

public class BlowfishInputStream
extends InputStream {
    PushbackInputStream m_is;
    BlowfishCBC m_bfc;
    byte[] m_buf;
    int m_nBufPos;
    int m_nBufCount;

    void init(byte[] key, int nOfs, int nLen, InputStream is) throws IOException {
        this.m_nBufCount = 0;
        this.m_nBufPos = 0;
        this.m_is = new PushbackInputStream(new BufferedInputStream(is));
        SHA1 sh = new SHA1();
        sh.update(key, nOfs, nLen);
        sh.finalize();
        byte[] ckey = sh.getDigest();
        this.m_bfc = new BlowfishCBC(ckey, 0, ckey.length, 0L);
        this.m_buf = new byte[8];
        int nI = 0;
        int nC = this.m_buf.length;
        while (nI < nC) {
            int nVal = this.m_is.read();
            if (-1 == nVal) {
                throw new IOException("truncated stream, IV is missing");
            }
            this.m_buf[nI] = (byte)nVal;
            ++nI;
        }
        this.m_bfc.setCBCIV(this.m_buf, 0);
    }

    void fillBuffer() throws IOException {
        int nVal;
        int nI = 0;
        int nC = this.m_buf.length;
        while (nI < nC) {
            nVal = this.m_is.read();
            if (-1 == nVal) {
                throw new IOException("truncated stream, unexpected end");
            }
            this.m_buf[nI] = (byte)nVal;
            ++nI;
        }
        this.m_bfc.decrypt(this.m_buf, 0, this.m_buf, 0, this.m_buf.length);
        nVal = this.m_is.read();
        if (-1 == nVal) {
            nC = this.m_buf[this.m_buf.length - 1];
            if (nC > this.m_buf.length || nC < 0) {
                throw new IOException("unknown padding value detected");
            }
            nI = this.m_nBufCount = this.m_buf.length - nC;
            while (nI < this.m_buf.length) {
                if (this.m_buf[nI] != (byte)nC) {
                    throw new IOException("invalid padding data detected");
                }
                ++nI;
            }
            this.m_bfc.cleanUp();
            this.m_bfc = null;
        } else {
            this.m_is.unread(nVal);
            this.m_nBufCount = this.m_buf.length;
        }
        this.m_nBufPos = 0;
    }

    public BlowfishInputStream(byte[] key, int nOfs, int nLen, InputStream is) throws IOException {
        this.init(key, nOfs, nLen, is);
    }

    public BlowfishInputStream(String sPassPhrase, InputStream is) throws IOException {
        int nC = sPassPhrase.length();
        byte[] key = new byte[nC];
        int nI = 0;
        while (nI < nC) {
            key[nI] = (byte)(sPassPhrase.charAt(nI) & 0xFF);
            ++nI;
        }
        this.init(key, 0, nC, is);
    }

    public int read() throws IOException {
        while (this.m_nBufCount <= this.m_nBufPos) {
            if (this.m_bfc == null) {
                return -1;
            }
            this.fillBuffer();
        }
        return this.m_buf[this.m_nBufPos++] & 0xFF;
    }

    public void close() throws IOException {
        this.m_is.close();
    }
}

