/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.ui.swing.DPFPEnrollmentControl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class BalloonControl
extends JPanel {
    private static final String infoIconFilename = "/images/info.png";
    private static final BufferedImage infoIcon;
    private static Color fillColor;
    private static Color penColor;
    private final Component attachedComponent;
    private final JLabel caption = new JLabel(new ImageIcon(infoIcon));
    private final JLabel label = new JLabel();
    private boolean suspended = false;
    private int columns;
    private Timer timer = new Timer(1000, new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            BalloonControl.this.dismiss();
        }
    });

    public static void popup(Component component, String string) {
        BalloonControl.popup(component, string, "");
    }

    public static void popup(Component component, String string, String string2) {
        BalloonControl.popup(component, string, string2, 50);
    }

    public static void popup(Component component, String string, String string2, int n) {
        BalloonControl.popup(component, string, string2, n, 10);
    }

    public static void popup(Component component, String string, String string2, int n, int n2) {
        BalloonControl balloonControl = new BalloonControl(component, n, n2);
        balloonControl.setTitle(string2);
        balloonControl.setText(string);
        balloonControl.setVisible(true);
    }

    BalloonControl(Component component, int n, int n2) {
        this.attachedComponent = component;
        this.columns = n;
        this.setOpaque(false);
        this.setBorder(new BalloonBorder(n2));
        this.setLayout(new BorderLayout());
        this.caption.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.caption.setFont(UIManager.getFont("ToolTip.font").deriveFont(1));
        this.caption.setHorizontalAlignment(2);
        this.label.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.label.setFont(UIManager.getFont("ToolTip.font"));
        this.add((Component)this.caption, "First");
        this.add((Component)this.label, "Center");
        component.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                if (BalloonControl.this.isShowing()) {
                    BalloonControl.this.updateLocation();
                }
            }
        });
        component.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorMoved(HierarchyEvent hierarchyEvent) {
                if (BalloonControl.this.isShowing()) {
                    BalloonControl.this.updateLocation();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                BalloonControl.this.setSuspended(false);
                BalloonControl.this.dismiss();
                mouseEvent.consume();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                BalloonControl.this.setSuspended(true);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                BalloonControl.this.setSuspended(false);
            }
        });
        this.setVisible(false);
    }

    private void updateLocation() {
        BalloonBorder balloonBorder = (BalloonBorder)this.getBorder();
        int n = balloonBorder.radius;
        Rectangle rectangle = this.getParent().getBounds();
        Rectangle rectangle2 = SwingUtilities.convertRectangle(this.attachedComponent.getParent(), this.attachedComponent.getBounds(), this.getParent());
        Point point = new Point((int)rectangle2.getCenterX(), (int)rectangle2.getCenterY());
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        dimension.setSize(Math.min(dimension.width, dimension2.width), Math.min(dimension.height, dimension2.height));
        Point point2 = new Point(Math.max(rectangle2.x - dimension.width + n, Math.min(rectangle.width - dimension.width - 1, point.x - n)), point.y + dimension.height < rectangle.height - 1 ? Math.min(point.y, rectangle.height - dimension.height - 1) : (point.y - dimension.height > 0 ? Math.max(point.y - dimension.height, 1) : n));
        this.setBounds(point2.x - n, point2.y, dimension.width, dimension.height);
        balloonBorder.spot.x = point.x - point2.x + balloonBorder.radius;
        balloonBorder.spot.y = point.y > point2.y ? dimension.height : 0;
        this.validate();
    }

    public void setTitle(String string) {
        this.caption.setText(string);
    }

    public void setText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.startsWith("<html>")) {
            stringBuilder.append("<html>");
        }
        String string2 = string.replaceAll("<br\\s*?>", "\n");
        int n = 0;
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            while (c == '<' && (i = string2.indexOf(62, i) + 1) < n2) {
                c = string2.charAt(i);
            }
            if (c == '\n') {
                n = 0;
            }
            if (c == ' ') {
                n4 = i;
            }
            if (++n <= this.columns) continue;
            stringBuilder.append(string2.substring(n3, n4)).append("<br>");
            i = n3 = ++n4;
            n = 0;
        }
        stringBuilder.append(string2.substring(n3));
        if (!string.endsWith("</html>")) {
            stringBuilder.append("</html>");
        }
        this.label.setText(stringBuilder.toString().replaceAll("\n", "<br>"));
    }

    public void setVisible(boolean bl) {
        if (!this.isVisible() && bl) {
            JLayeredPane jLayeredPane = JLayeredPane.getLayeredPaneAbove(this.attachedComponent);
            if (jLayeredPane != null) {
                jLayeredPane.add((Component)this, JLayeredPane.POPUP_LAYER);
                this.label.setMaximumSize(new Dimension(jLayeredPane.getSize().width / 2, jLayeredPane.getSize().height / 2));
            }
            this.updateLocation();
        }
        super.setVisible(bl);
        this.timer.setRepeats(false);
        if (bl) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public void setSuspended(boolean bl) {
        this.suspended = bl;
        if (!bl) {
            this.setVisible(true);
        }
    }

    public void dismiss() {
        if (!this.suspended) {
            this.setVisible(false);
            this.getParent().remove(this);
        } else {
            this.suspended = false;
        }
    }

    static {
        fillColor = UIManager.getColor("ToolTip.background");
        penColor = UIManager.getColor("ToolTip.foreground");
        try {
            infoIcon = ImageIO.read(DPFPEnrollmentControl.class.getResourceAsStream(infoIconFilename));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static class BalloonBorder
    implements Border {
        private Insets insets;
        public int radius = 0;
        public Point spot;

        BalloonBorder(int n) {
            this.radius = n;
            this.insets = new Insets(n + 1, 1, n + 1, 1);
            this.spot = new Point(this.radius, 0);
        }

        public void setSpot(Point point) {
            this.spot = point;
        }

        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(n, n2 + this.radius, n3, n4 - 2 * this.radius);
            int n5 = this.spot.x < n3 / 2 ? 1 : -1;
            int n6 = this.spot.y < n4 / 2 ? 1 : -1;
            int n7 = this.radius * n5;
            int n8 = (this.radius + 1) * n6;
            graphics.setColor(fillColor);
            graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.radius, this.radius);
            graphics.setColor(penColor);
            graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, this.radius, this.radius);
            int[] nArray = new int[]{this.spot.x, this.spot.x + n7, this.spot.x};
            int[] nArray2 = new int[]{this.spot.y + n8, this.spot.y + n8, this.spot.y};
            graphics.setColor(fillColor);
            graphics.fillPolygon(nArray, nArray2, 3);
            graphics.setColor(penColor);
            graphics.drawLine(nArray[0], nArray2[0] - n6, nArray[2], nArray2[2]);
            graphics.drawLine(nArray[1], nArray2[1] - n6, nArray[2], nArray2[2]);
        }
    }
}

