/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.ui.swing.CancelEvent;
import com.digitalpersona.onetouch.ui.swing.CancelListener;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class CancelControl
extends JEditorPane {
    private static ResourceBundle labels = ResourceBundle.getBundle("dpfpui");

    public CancelControl() {
        super("text/html", labels.getString("IDS_FOOTER"));
        this.setOpaque(false);
        this.setEditable(false);
        this.setFont(UIManager.getFont("Panel.font"));
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    CancelControl.this.notifyCancelListeners();
                }
            }
        });
    }

    private void notifyCancelListeners() {
        CancelEvent cancelEvent = new CancelEvent(this);
        for (CancelListener cancelListener : (CancelListener[])this.getListeners(CancelListener.class)) {
            try {
                cancelListener.enrollmentCancelled(cancelEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void addCancelListener(CancelListener cancelListener) {
        this.listenerList.add(CancelListener.class, cancelListener);
    }

    void removeCancelListener(CancelListener cancelListener) {
        this.listenerList.remove(CancelListener.class, cancelListener);
    }
}

