/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPCaptureFeedback;
import com.digitalpersona.onetouch.DPFPDataPurpose;
import com.digitalpersona.onetouch.DPFPFeatureSet;
import com.digitalpersona.onetouch.DPFPFingerIndex;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPSample;
import com.digitalpersona.onetouch.capture.DPFPCapture;
import com.digitalpersona.onetouch.capture.event.DPFPDataEvent;
import com.digitalpersona.onetouch.capture.event.DPFPDataListener;
import com.digitalpersona.onetouch.processing.DPFPEnrollment;
import com.digitalpersona.onetouch.processing.DPFPFeatureExtraction;
import com.digitalpersona.onetouch.processing.DPFPImageQualityException;
import com.digitalpersona.onetouch.processing.DPFPTemplateStatus;
import com.digitalpersona.onetouch.readers.DPFPReaderDescription;
import com.digitalpersona.onetouch.readers.DPFPReaderImpressionType;
import com.digitalpersona.onetouch.readers.DPFPReadersCollection;
import com.digitalpersona.onetouch.ui.swing.BalloonControl;
import com.digitalpersona.onetouch.ui.swing.CancelControl;
import com.digitalpersona.onetouch.ui.swing.CancelEvent;
import com.digitalpersona.onetouch.ui.swing.CancelListener;
import com.digitalpersona.onetouch.ui.swing.CaptureEvent;
import com.digitalpersona.onetouch.ui.swing.CaptureListener;
import com.digitalpersona.onetouch.ui.swing.ExplanationControl;
import com.digitalpersona.onetouch.ui.swing.MiniHandsControl;
import com.digitalpersona.onetouch.ui.swing.ScoreboardControl;
import com.digitalpersona.onetouch.ui.swing.SensorControl;
import com.digitalpersona.onetouch.ui.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

class CapturePanel
extends JPanel {
    private final transient JTextComponent prompt = Utilities.getXTextPane();
    private final transient SensorControl sensorControl = new SensorControl();
    private final transient MiniHandsControl miniHandsControl = new MiniHandsControl();
    private final transient ExplanationControl explanationControl = new ExplanationControl();
    private final transient CancelControl cancelControl = new CancelControl();
    private final transient ScoreboardControl scoreboardControl = new ScoreboardControl();
    private transient DPFPCapture capture = DPFPGlobal.getCaptureFactory().createCapture();
    DPFPEnrollment enrollment = DPFPGlobal.getEnrollmentFactory().createEnrollment();
    protected transient boolean finishing = false;
    protected transient boolean paused = false;
    private transient DPFPReaderImpressionType impressionType = DPFPReaderImpressionType.READER_IMPRESSION_TYPE_AREA;
    private transient String serialNumber;
    private transient DPFPFingerIndex finger;
    private static ResourceBundle labels = ResourceBundle.getBundle("dpfpui");

    public CapturePanel() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setOpaque(false);
        this.prompt.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.add((Component)this.prompt, "First");
        JPanel jPanel = Utilities.getXBox();
        jPanel.add(this.sensorControl);
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.miniHandsControl);
        JPanel jPanel2 = Utilities.getXBox();
        jPanel2.add(this.scoreboardControl);
        JPanel jPanel3 = Utilities.getXBorder();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 0));
        jPanel3.add((Component)jPanel2, "First");
        this.explanationControl.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel3.add((Component)this.explanationControl, "Center");
        jPanel3.add((Component)this.cancelControl, "Last");
        this.add((Component)jPanel, "Before");
        this.add((Component)jPanel3, "Center");
        this.cancelControl.addCancelListener(new CancelListener(){

            public void enrollmentCancelled(CancelEvent cancelEvent) {
                CapturePanel.this.paused = true;
                if (JOptionPane.showConfirmDialog(CapturePanel.this, String.format(labels.getString("IDS_CANCEL_PROMPT"), Utilities.fingerprintName(CapturePanel.this.finger)), labels.getString("IDS_CANCEL_TITLE"), 0) == 0) {
                    CapturePanel.this.cancel();
                } else {
                    CapturePanel.this.paused = false;
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getID() == 1400 && (hierarchyEvent.getChangeFlags() & 4L) != 0L && !CapturePanel.this.isShowing()) {
                    CapturePanel.this.stop();
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("foreground")) {
                    if (CapturePanel.this.prompt != null) {
                        CapturePanel.this.prompt.setForeground((Color)propertyChangeEvent.getNewValue());
                    }
                    if (CapturePanel.this.explanationControl != null) {
                        CapturePanel.this.explanationControl.setForeground((Color)propertyChangeEvent.getNewValue());
                    }
                    if (CapturePanel.this.cancelControl != null) {
                        CapturePanel.this.cancelControl.setForeground((Color)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("font")) {
                    if (CapturePanel.this.prompt != null) {
                        CapturePanel.this.prompt.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                    if (CapturePanel.this.explanationControl != null) {
                        CapturePanel.this.explanationControl.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                    if (CapturePanel.this.cancelControl != null) {
                        CapturePanel.this.cancelControl.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                }
            }
        });
        this.capture.addDataListener(new DPFPDataListener(){

            public void dataAcquired(final DPFPDataEvent dPFPDataEvent) {
                if (CapturePanel.this.finishing || CapturePanel.this.paused) {
                    return;
                }
                if (CapturePanel.this.serialNumber == null && dPFPDataEvent.getSource() != null) {
                    try {
                        CapturePanel.this.updateImpressionType((String)dPFPDataEvent.getSource());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            try {
                                DPFPSample dPFPSample = dPFPDataEvent.getSample();
                                if (dPFPSample == null) {
                                    CapturePanel.this.sensorControl.showFailed();
                                    return;
                                }
                                CapturePanel.this.sensorControl.showTouched();
                                DPFPFeatureExtraction dPFPFeatureExtraction = DPFPGlobal.getFeatureExtractionFactory().createFeatureExtraction();
                                DPFPFeatureSet dPFPFeatureSet = dPFPFeatureExtraction.createFeatureSet(dPFPSample, DPFPDataPurpose.DATA_PURPOSE_ENROLLMENT);
                                CapturePanel.this.enrollment.addFeatures(dPFPFeatureSet);
                                CapturePanel.this.scoreboardControl.setScore(CapturePanel.this.scoreboardControl.getScore() + 1);
                                CapturePanel.this.explanationControl.displayQuality(CapturePanel.this.impressionType, DPFPCaptureFeedback.CAPTURE_FEEDBACK_GOOD);
                                if (CapturePanel.this.enrollment.getTemplateStatus() == DPFPTemplateStatus.TEMPLATE_STATUS_READY) {
                                    CaptureEvent captureEvent = new CaptureEvent(CapturePanel.this, 1, CapturePanel.this.finger, CapturePanel.this.enrollment.getTemplate());
                                    for (CaptureListener captureListener : (CaptureListener[])CapturePanel.this.getListeners(CaptureListener.class)) {
                                        captureListener.fingerCaptured(captureEvent);
                                    }
                                }
                            }
                            catch (DPFPImageQualityException dPFPImageQualityException) {
                                CapturePanel.this.sensorControl.showFailed();
                                CapturePanel.this.explanationControl.displayQuality(CapturePanel.this.impressionType, dPFPImageQualityException.getCaptureFeedback());
                                if (CapturePanel.this.enrollment.getTemplateStatus() == DPFPTemplateStatus.TEMPLATE_STATUS_FAILED) {
                                    CapturePanel.this.reset();
                                    CapturePanel.this.showPopup(CapturePanel.this.finger, String.format(labels.getString("IDS_BAD_IMAGES"), Utilities.fingerName(CapturePanel.this.finger)), labels.getString("IDS_REG_FAILED"));
                                }
                                CapturePanel.this.showPopup(CapturePanel.this.finger, Utilities.getFeedbackString(CapturePanel.this.impressionType, dPFPImageQualityException.getCaptureFeedback()), labels.getString("IDS_SCAN_BAD_IMAGE"));
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void start(DPFPFingerIndex dPFPFingerIndex) {
        if (!this.isStopped()) {
            return;
        }
        this.finger = dPFPFingerIndex;
        this.miniHandsControl.setFinger(dPFPFingerIndex);
        this.explanationControl.setFinger(dPFPFingerIndex);
        String string = this.getReaderSerialNumber();
        if (string != null) {
            this.updateImpressionType(string);
        }
        this.prompt.setText(String.format(labels.getString("IDS_SCAN_HEADER"), Utilities.fingerName(dPFPFingerIndex)));
        this.capture.setReaderSerialNumber(string);
        this.reset();
        this.capture.startCapture();
    }

    public void reset() {
        this.enrollment.clear();
        this.scoreboardControl.setScore(0);
        this.explanationControl.displayStart(this.impressionType);
    }

    public void stop() {
        if (this.capture != null && !this.finishing) {
            this.finishing = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        CapturePanel.this.capture.stopCapture();
                        for (CaptureListener captureListener : (CaptureListener[])CapturePanel.this.getListeners(CaptureListener.class)) {
                            captureListener.captureStopped();
                        }
                        CapturePanel.this.finishing = false;
                        CapturePanel.this.paused = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public boolean isStopped() {
        return this.capture == null || !this.capture.isStarted() || this.finishing;
    }

    public void cancel() {
        this.stop();
        CaptureEvent captureEvent = new CaptureEvent(this, 0, this.finger, null);
        for (CaptureListener captureListener : (CaptureListener[])this.getListeners(CaptureListener.class)) {
            captureListener.fingerCancelled(captureEvent);
        }
    }

    public DPFPCapture getCapture() {
        return this.capture;
    }

    public DPFPFingerIndex getFinger() {
        return this.finger;
    }

    public void showPopup(DPFPFingerIndex dPFPFingerIndex, String string, String string2) {
        BalloonControl.popup(this.scoreboardControl, string, string2);
    }

    public String getReaderSerialNumber() {
        return this.serialNumber;
    }

    public void setReaderSerialNumber(String string) {
        this.serialNumber = string;
    }

    public void addCaptureListener(CaptureListener captureListener) {
        this.listenerList.add(CaptureListener.class, captureListener);
    }

    public void removeCaptureListener(CaptureListener captureListener) {
        this.listenerList.remove(CaptureListener.class, captureListener);
    }

    private void updateImpressionType(String string) {
        DPFPReadersCollection dPFPReadersCollection = DPFPGlobal.getReadersFactory().getReaders();
        DPFPReaderDescription dPFPReaderDescription = dPFPReadersCollection.get(string);
        this.impressionType = dPFPReaderDescription.getImpressionType();
    }
}

