/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPFingerIndex;
import com.digitalpersona.onetouch.capture.event.DPFPReaderStatusEvent;
import com.digitalpersona.onetouch.capture.event.DPFPReaderStatusListener;
import com.digitalpersona.onetouch.ui.swing.CaptureEvent;
import com.digitalpersona.onetouch.ui.swing.CaptureListener;
import com.digitalpersona.onetouch.ui.swing.CapturePanel;
import com.digitalpersona.onetouch.ui.swing.DPFPEnrollmentEvent;
import com.digitalpersona.onetouch.ui.swing.DPFPEnrollmentListener;
import com.digitalpersona.onetouch.ui.swing.DPFPEnrollmentVetoException;
import com.digitalpersona.onetouch.ui.swing.FingerToggleListener;
import com.digitalpersona.onetouch.ui.swing.FingerTogglelEvent;
import com.digitalpersona.onetouch.ui.swing.HandsPanel;
import com.digitalpersona.onetouch.ui.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DPFPEnrollmentControl
extends JPanel
implements Serializable {
    private static final long serialVersionUID = 752362817229178959L;
    private static final String HANDS_PAGE = "Hands";
    private static final String CAPTURE_PAGE = "Capture";
    private transient HandsPanel handsPanel = new HandsPanel();
    private transient CapturePanel capturePanel = new CapturePanel();
    private transient JPanel top = new TopPanel();
    private transient JPanel center = new JPanel(new CardLayout());
    static final int PREFFERED_WIDTH = 480;
    static final int PREFFERED_HEIGHT = 320;
    static final String DPFPUI_PROPERTIES = "dpfpui";
    static final String ENROLLED_FINGERS_PROPERTY = "enrolledFingers";
    static final String MAX_ENROLLED_FINGER_COUNT = "maxEnrollFingerCount";
    static final String READER_SERIAL_NUMBER_PROPERTY = "readerSerialNumber";
    private static ResourceBundle labels = ResourceBundle.getBundle("dpfpui");

    public DPFPEnrollmentControl() {
        this.setPreferredSize(new Dimension(480, 320));
        this.center.setOpaque(false);
        this.center.add((Component)this.handsPanel, HANDS_PAGE);
        this.center.add((Component)this.capturePanel, CAPTURE_PAGE);
        this.setLayout(new BorderLayout());
        this.add((Component)this.top, "First");
        this.add((Component)this.center, "Center");
        this.center.setBorder(BorderFactory.createEtchedBorder());
        this.handsPanel.addFingerToggleListener(new FingerToggleListener(){

            public void fingerAdded(FingerTogglelEvent fingerTogglelEvent) {
                DPFPEnrollmentControl.this.capturePanel.start(fingerTogglelEvent.getFinger());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void fingerRemoved(FingerTogglelEvent fingerTogglelEvent) {
                DPFPEnrollmentEvent dPFPEnrollmentEvent;
                DPFPFingerIndex dPFPFingerIndex;
                block14: {
                    EnumSet<DPFPFingerIndex> enumSet;
                    block13: {
                        enumSet = DPFPEnrollmentControl.this.handsPanel.getEnrolledFingers();
                        dPFPFingerIndex = fingerTogglelEvent.getFinger();
                        enumSet.remove(dPFPFingerIndex);
                        dPFPEnrollmentEvent = new DPFPEnrollmentEvent(this, 1, dPFPFingerIndex);
                        try {
                            try {
                                for (DPFPEnrollmentListener dPFPEnrollmentListener : (DPFPEnrollmentListener[])DPFPEnrollmentControl.this.getListeners(DPFPEnrollmentListener.class)) {
                                    dPFPEnrollmentListener.fingerDeleted(dPFPEnrollmentEvent);
                                }
                                Object var10_10 = null;
                                if (dPFPEnrollmentEvent.getStopCapture()) {
                                    DPFPEnrollmentControl.this.capturePanel.stop();
                                }
                                if (!dPFPEnrollmentEvent.getPerformed()) break block13;
                                DPFPEnrollmentControl.this.handsPanel.setEnrolledFingers(enumSet);
                                break block14;
                            }
                            catch (DPFPEnrollmentVetoException dPFPEnrollmentVetoException) {
                                dPFPEnrollmentEvent.setPerformed(false);
                                Object var10_11 = null;
                                if (dPFPEnrollmentEvent.getStopCapture()) {
                                    DPFPEnrollmentControl.this.capturePanel.stop();
                                }
                                if (dPFPEnrollmentEvent.getPerformed()) {
                                    DPFPEnrollmentControl.this.handsPanel.setEnrolledFingers(enumSet);
                                } else {
                                    enumSet.add(dPFPFingerIndex);
                                }
                                if (dPFPEnrollmentEvent.getPerformed()) return;
                                DPFPEnrollmentControl.this.showPopup(dPFPFingerIndex, String.format(labels.getString("IDS_FP_NOT_DELETED"), Utilities.fingerprintName(dPFPFingerIndex)), labels.getString("IDS_FP_NOT_DELETED_TITLE"));
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            if (dPFPEnrollmentEvent.getStopCapture()) {
                                DPFPEnrollmentControl.this.capturePanel.stop();
                            }
                            if (dPFPEnrollmentEvent.getPerformed()) {
                                DPFPEnrollmentControl.this.handsPanel.setEnrolledFingers(enumSet);
                            } else {
                                enumSet.add(dPFPFingerIndex);
                            }
                            if (dPFPEnrollmentEvent.getPerformed()) throw throwable;
                            DPFPEnrollmentControl.this.showPopup(dPFPFingerIndex, String.format(labels.getString("IDS_FP_NOT_DELETED"), Utilities.fingerprintName(dPFPFingerIndex)), labels.getString("IDS_FP_NOT_DELETED_TITLE"));
                            throw throwable;
                        }
                    }
                    enumSet.add(dPFPFingerIndex);
                }
                if (dPFPEnrollmentEvent.getPerformed()) return;
                DPFPEnrollmentControl.this.showPopup(dPFPFingerIndex, String.format(labels.getString("IDS_FP_NOT_DELETED"), Utilities.fingerprintName(dPFPFingerIndex)), labels.getString("IDS_FP_NOT_DELETED_TITLE"));
            }
        });
        this.capturePanel.addCaptureListener(new CaptureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void fingerCaptured(CaptureEvent captureEvent) {
                DPFPEnrollmentEvent dPFPEnrollmentEvent;
                DPFPFingerIndex dPFPFingerIndex;
                block14: {
                    EnumSet<DPFPFingerIndex> enumSet;
                    block13: {
                        enumSet = DPFPEnrollmentControl.this.handsPanel.getEnrolledFingers();
                        dPFPFingerIndex = captureEvent.getFinger();
                        enumSet.add(dPFPFingerIndex);
                        dPFPEnrollmentEvent = new DPFPEnrollmentEvent(this, 0, dPFPFingerIndex, captureEvent.getTemplate());
                        try {
                            try {
                                for (DPFPEnrollmentListener dPFPEnrollmentListener : (DPFPEnrollmentListener[])DPFPEnrollmentControl.this.getListeners(DPFPEnrollmentListener.class)) {
                                    dPFPEnrollmentListener.fingerEnrolled(dPFPEnrollmentEvent);
                                }
                                Object var10_10 = null;
                                if (dPFPEnrollmentEvent.getStopCapture()) {
                                    DPFPEnrollmentControl.this.capturePanel.stop();
                                }
                                if (!dPFPEnrollmentEvent.getPerformed()) break block13;
                                DPFPEnrollmentControl.this.handsPanel.setEnrolledFingers(enumSet);
                                break block14;
                            }
                            catch (DPFPEnrollmentVetoException dPFPEnrollmentVetoException) {
                                dPFPEnrollmentEvent.setPerformed(false);
                                Object var10_11 = null;
                                if (dPFPEnrollmentEvent.getStopCapture()) {
                                    DPFPEnrollmentControl.this.capturePanel.stop();
                                }
                                if (dPFPEnrollmentEvent.getPerformed()) {
                                    DPFPEnrollmentControl.this.handsPanel.setEnrolledFingers(enumSet);
                                } else {
                                    enumSet.remove(dPFPFingerIndex);
                                }
                                if (dPFPEnrollmentEvent.getPerformed()) return;
                                DPFPEnrollmentControl.this.showPopup(dPFPFingerIndex, String.format(labels.getString("IDS_FP_NOT_ENROLLED"), Utilities.fingerprintName(dPFPFingerIndex)), labels.getString("IDS_FP_NOT_ENROLLED_TITLE"));
                                DPFPEnrollmentControl.this.capturePanel.reset();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_12 = null;
                            if (dPFPEnrollmentEvent.getStopCapture()) {
                                DPFPEnrollmentControl.this.capturePanel.stop();
                            }
                            if (dPFPEnrollmentEvent.getPerformed()) {
                                DPFPEnrollmentControl.this.handsPanel.setEnrolledFingers(enumSet);
                            } else {
                                enumSet.remove(dPFPFingerIndex);
                            }
                            if (dPFPEnrollmentEvent.getPerformed()) throw throwable;
                            DPFPEnrollmentControl.this.showPopup(dPFPFingerIndex, String.format(labels.getString("IDS_FP_NOT_ENROLLED"), Utilities.fingerprintName(dPFPFingerIndex)), labels.getString("IDS_FP_NOT_ENROLLED_TITLE"));
                            DPFPEnrollmentControl.this.capturePanel.reset();
                            throw throwable;
                        }
                    }
                    enumSet.remove(dPFPFingerIndex);
                }
                if (dPFPEnrollmentEvent.getPerformed()) return;
                DPFPEnrollmentControl.this.showPopup(dPFPFingerIndex, String.format(labels.getString("IDS_FP_NOT_ENROLLED"), Utilities.fingerprintName(dPFPFingerIndex)), labels.getString("IDS_FP_NOT_ENROLLED_TITLE"));
                DPFPEnrollmentControl.this.capturePanel.reset();
            }

            public void fingerCancelled(CaptureEvent captureEvent) {
                DPFPEnrollmentControl.this.showPage(DPFPEnrollmentControl.HANDS_PAGE);
            }

            public void captureStopped() {
                DPFPEnrollmentControl.this.showPage(DPFPEnrollmentControl.HANDS_PAGE);
            }
        });
        this.capturePanel.getCapture().addReaderStatusListener(new DPFPReaderStatusListener(){

            public void readerConnected(DPFPReaderStatusEvent dPFPReaderStatusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DPFPEnrollmentControl.this.showPage(DPFPEnrollmentControl.CAPTURE_PAGE);
                    }
                });
            }

            public void readerDisconnected(DPFPReaderStatusEvent dPFPReaderStatusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DPFPEnrollmentControl.this.capturePanel.cancel();
                        DPFPEnrollmentControl.this.showPopup(DPFPEnrollmentControl.this.capturePanel.getFinger(), labels.getString("IDS_REG_DISCONNECT"), labels.getString("IDS_REG_CANCELLED"));
                    }
                });
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("enabled")) {
                    if (DPFPEnrollmentControl.this.handsPanel != null) {
                        DPFPEnrollmentControl.this.handsPanel.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                    }
                    if (DPFPEnrollmentControl.this.capturePanel != null) {
                        DPFPEnrollmentControl.this.capturePanel.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("foreground")) {
                    if (DPFPEnrollmentControl.this.handsPanel != null) {
                        DPFPEnrollmentControl.this.handsPanel.setForeground((Color)propertyChangeEvent.getNewValue());
                    }
                    if (DPFPEnrollmentControl.this.capturePanel != null) {
                        DPFPEnrollmentControl.this.capturePanel.setForeground((Color)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("font")) {
                    if (DPFPEnrollmentControl.this.handsPanel != null) {
                        DPFPEnrollmentControl.this.handsPanel.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                    if (DPFPEnrollmentControl.this.capturePanel != null) {
                        DPFPEnrollmentControl.this.capturePanel.setFont((Font)propertyChangeEvent.getNewValue());
                    }
                }
            }
        });
        this.showPage(HANDS_PAGE);
    }

    private void showPage(String string) {
        CardLayout cardLayout = (CardLayout)this.center.getLayout();
        cardLayout.show(this.center, string);
    }

    private void showPopup(DPFPFingerIndex dPFPFingerIndex, String string, String string2) {
        if (this.capturePanel.isStopped()) {
            this.showPage(HANDS_PAGE);
            this.handsPanel.showPopup(dPFPFingerIndex, string, string2);
        } else {
            this.showPage(CAPTURE_PAGE);
            this.capturePanel.showPopup(dPFPFingerIndex, string, string2);
        }
    }

    public EnumSet<DPFPFingerIndex> getEnrolledFingers() {
        return this.handsPanel.getEnrolledFingers();
    }

    public void setEnrolledFingers(EnumSet<DPFPFingerIndex> enumSet) {
        EnumSet<DPFPFingerIndex> enumSet2 = this.getEnrolledFingers();
        this.handsPanel.setEnrolledFingers(enumSet);
        this.firePropertyChange(ENROLLED_FINGERS_PROPERTY, enumSet2, this.getEnrolledFingers());
    }

    public int getMaxEnrollFingerCount() {
        return this.handsPanel.getMaxEnrollFingerCount();
    }

    public void setMaxEnrollFingerCount(int n) {
        int n2 = this.getMaxEnrollFingerCount();
        this.handsPanel.setMaxEnrollFingerCount(n);
        this.firePropertyChange(MAX_ENROLLED_FINGER_COUNT, n2, this.getMaxEnrollFingerCount());
    }

    public String getReaderSerialNumber() {
        return this.capturePanel.getReaderSerialNumber();
    }

    public void setReaderSerialNumber(String string) {
        String string2 = this.getReaderSerialNumber();
        this.capturePanel.stop();
        this.capturePanel.setReaderSerialNumber(string);
        this.firePropertyChange(READER_SERIAL_NUMBER_PROPERTY, string2, this.getReaderSerialNumber());
    }

    public void addEnrollmentListener(DPFPEnrollmentListener dPFPEnrollmentListener) {
        this.listenerList.add(DPFPEnrollmentListener.class, dPFPEnrollmentListener);
    }

    public void removeEnrollmentListener(DPFPEnrollmentListener dPFPEnrollmentListener) {
        this.listenerList.remove(DPFPEnrollmentListener.class, dPFPEnrollmentListener);
    }

    static class TopPanel
    extends JPanel {
        private static final String topFingerName = "/images/topfinger.png";
        private static final ImageIcon topFingerIcon;

        public TopPanel() {
            SpringLayout springLayout = new SpringLayout();
            this.setLayout(springLayout);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBackground(Color.WHITE);
            JLabel jLabel = new JLabel("<html><font size='5'>" + labels.getString("IDS_WTITLE") + "</font></html>");
            JLabel jLabel2 = new JLabel("<html><font size='2'>" + labels.getString("IDS_SUBTITLE") + "</font></html>");
            JLabel jLabel3 = new JLabel(topFingerIcon);
            this.add(jLabel);
            springLayout.putConstraint("West", (Component)jLabel, 8, "West", (Component)this);
            springLayout.putConstraint("North", (Component)jLabel, 4, "North", (Component)this);
            this.add(jLabel2);
            springLayout.putConstraint("West", (Component)jLabel2, 20, "West", (Component)jLabel);
            springLayout.putConstraint("North", (Component)jLabel2, 4, "South", (Component)jLabel);
            this.add(jLabel3);
            springLayout.putConstraint("East", (Component)jLabel3, -8, "East", (Component)this);
            springLayout.putConstraint("North", (Component)jLabel3, 2, "North", (Component)this);
            springLayout.putConstraint("South", (Component)this, 4, "South", (Component)jLabel3);
        }

        static {
            try {
                topFingerIcon = new ImageIcon(ImageIO.read(DPFPEnrollmentControl.class.getResourceAsStream(topFingerName)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

