/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPCaptureFeedback;
import com.digitalpersona.onetouch.DPFPFingerIndex;
import com.digitalpersona.onetouch.readers.DPFPReaderImpressionType;
import com.digitalpersona.onetouch.ui.swing.Utilities;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.UIManager;

class ExplanationControl
extends JEditorPane {
    private DPFPFingerIndex finger;
    private static ResourceBundle labels = ResourceBundle.getBundle("dpfpui");

    public ExplanationControl() {
        super("text/html", labels.getString("IDS_FOOTER"));
        this.setOpaque(false);
        this.setEditable(false);
        this.setFont(UIManager.getFont("Panel.font"));
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }

    public void displayStart(DPFPReaderImpressionType dPFPReaderImpressionType) {
        String string = dPFPReaderImpressionType == DPFPReaderImpressionType.READER_IMPRESSION_TYPE_SWIPE ? labels.getString("IDS_SWIPE_SCAN_BEGIN") : labels.getString("IDS_SCAN_BEGIN");
        this.setText(String.format(string, Utilities.fingerName(this.finger)));
    }

    public void displayQuality(DPFPReaderImpressionType dPFPReaderImpressionType, DPFPCaptureFeedback dPFPCaptureFeedback) {
        this.setText(Utilities.getFeedbackString(dPFPReaderImpressionType, dPFPCaptureFeedback));
    }

    public void displayReaderStatus(int n) {
        if (n == 2) {
            this.setText(labels.getString("IDS_DISCONNECT_IDENTIFY_TEXT"));
        }
    }

    public void setFinger(DPFPFingerIndex dPFPFingerIndex) {
        this.finger = dPFPFingerIndex;
    }
}

