/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPFingerIndex;
import com.digitalpersona.onetouch.ui.swing.BalloonControl;
import com.digitalpersona.onetouch.ui.swing.DPFPEnrollmentControl;
import com.digitalpersona.onetouch.ui.swing.Utilities;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.util.EnumMap;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class FingerControl
extends JLabel {
    private DPFPFingerIndex finger;
    private int state;
    private static final String format = "/images/finger_%d_%d.png";
    private static final EnumMap<DPFPFingerIndex, ImageIcon[]> fingerIcons = new EnumMap(DPFPFingerIndex.class);
    private static final EnumMap<DPFPFingerIndex, Point> fingerLocations = new EnumMap(DPFPFingerIndex.class);
    private static final int[] fingerMnemonics = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
    private static final int SELECTION_MASK = 1;
    private static final int ENROLLMENT_MASK = 2;
    private static ResourceBundle labels = ResourceBundle.getBundle("dpfpui");

    public FingerControl(DPFPFingerIndex dPFPFingerIndex) {
        this.finger = dPFPFingerIndex;
        this.state = 0;
        this.setLocation(fingerLocations.get(dPFPFingerIndex));
        Dimension dimension = new Dimension(fingerIcons.get(dPFPFingerIndex)[0].getIconWidth(), fingerIcons.get(dPFPFingerIndex)[0].getIconHeight());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.updateImage();
    }

    private void updateImage() {
        this.setIcon(fingerIcons.get(this.finger)[this.state]);
    }

    public void setSelected(boolean bl) {
        this.state = bl ? this.state | 1 : this.state & 0xFFFFFFFE;
        this.updateImage();
    }

    public void setEnrolled(boolean bl) {
        boolean bl2 = this.isEnrolled() != bl;
        this.state = bl ? this.state | 2 : this.state & 0xFFFFFFFD;
        this.updateImage();
        if (this.isValid() && this.isVisible() && bl2) {
            String string = bl ? labels.getString("IDS_FP_ENROLLED_TITLE") : labels.getString("IDS_FP_DELETED_TITLE");
            String string2 = bl ? String.format(labels.getString("IDS_FP_ENROLLED"), Utilities.fingerprintName(this.finger)) : String.format(labels.getString("IDS_FP_DELETED"), Utilities.fingerprintName(this.finger));
            BalloonControl.popup(this, string2, string);
        }
    }

    public boolean isSelected() {
        return (this.state & 1) != 0;
    }

    public boolean isEnrolled() {
        return (this.state & 2) != 0;
    }

    static {
        try {
            for (DPFPFingerIndex dPFPFingerIndex : DPFPFingerIndex.values()) {
                int n = dPFPFingerIndex.ordinal();
                ImageIcon[] imageIconArray = new ImageIcon[4];
                for (int i = 0; i < imageIconArray.length; ++i) {
                    imageIconArray[i] = new ImageIcon(ImageIO.read(DPFPEnrollmentControl.class.getResourceAsStream(String.format(format, n, i))));
                }
                fingerIcons.put(dPFPFingerIndex, imageIconArray);
            }
            fingerLocations.put(DPFPFingerIndex.LEFT_PINKY, new Point(20, 20));
            fingerLocations.put(DPFPFingerIndex.LEFT_RING, new Point(40, 0));
            fingerLocations.put(DPFPFingerIndex.LEFT_MIDDLE, new Point(64, 0));
            fingerLocations.put(DPFPFingerIndex.LEFT_INDEX, new Point(80, 20));
            fingerLocations.put(DPFPFingerIndex.LEFT_THUMB, new Point(96, 80));
            fingerLocations.put(DPFPFingerIndex.RIGHT_THUMB, new Point(152, 80));
            fingerLocations.put(DPFPFingerIndex.RIGHT_INDEX, new Point(168, 20));
            fingerLocations.put(DPFPFingerIndex.RIGHT_MIDDLE, new Point(188, 0));
            fingerLocations.put(DPFPFingerIndex.RIGHT_RING, new Point(220, 0));
            fingerLocations.put(DPFPFingerIndex.RIGHT_PINKY, new Point(248, 20));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

