/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPFingerIndex;
import com.digitalpersona.onetouch.ui.swing.BalloonControl;
import com.digitalpersona.onetouch.ui.swing.DPFPEnrollmentControl;
import com.digitalpersona.onetouch.ui.swing.FingerControl;
import com.digitalpersona.onetouch.ui.swing.FingerToggleListener;
import com.digitalpersona.onetouch.ui.swing.FingerTogglelEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HandsControl
extends JPanel {
    private static final String maskFilename = "/images/hands1.png";
    private static final BufferedImage maskImage;
    private static final String palmsFilename = "/images/palms.png";
    private static final BufferedImage palmsImage;
    private EnumSet<DPFPFingerIndex> fingers = EnumSet.noneOf(DPFPFingerIndex.class);
    private EnumMap<DPFPFingerIndex, FingerControl> fingerLabels = new EnumMap(DPFPFingerIndex.class);

    public HandsControl() {
        this.setOpaque(false);
        this.setLayout(null);
        Dimension dimension = new Dimension(maskImage.getWidth(), maskImage.getHeight());
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        JLabel jLabel = new JLabel(new ImageIcon(palmsImage));
        jLabel.setSize(dimension);
        jLabel.setLocation(0, 0);
        jLabel.setVisible(true);
        this.add(jLabel);
        for (DPFPFingerIndex dPFPFingerIndex : DPFPFingerIndex.values()) {
            FingerControl fingerControl = new FingerControl(dPFPFingerIndex);
            this.fingerLabels.put(dPFPFingerIndex, fingerControl);
            this.add(fingerControl);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                block5: {
                    if (!HandsControl.this.isEnabled()) {
                        return;
                    }
                    Point point = mouseEvent.getPoint();
                    int n = HandsControl.this.getFingerForPoint(point);
                    if (n == -1) break block5;
                    DPFPFingerIndex dPFPFingerIndex = DPFPFingerIndex.values()[n];
                    if (HandsControl.this.fingers.contains(dPFPFingerIndex)) {
                        FingerTogglelEvent fingerTogglelEvent = new FingerTogglelEvent(HandsControl.this, 0, dPFPFingerIndex);
                        for (FingerToggleListener fingerToggleListener : (FingerToggleListener[])HandsControl.this.getListeners(FingerToggleListener.class)) {
                            fingerToggleListener.fingerRemoved(fingerTogglelEvent);
                        }
                    } else {
                        FingerTogglelEvent fingerTogglelEvent = new FingerTogglelEvent(HandsControl.this, 1, dPFPFingerIndex);
                        for (FingerToggleListener fingerToggleListener : (FingerToggleListener[])HandsControl.this.getListeners(FingerToggleListener.class)) {
                            fingerToggleListener.fingerAdded(fingerTogglelEvent);
                        }
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){
            private int previousFinger = -1;

            public void mouseDragged(MouseEvent mouseEvent) {
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (!HandsControl.this.isEnabled()) {
                    return;
                }
                Point point = mouseEvent.getPoint();
                int n = HandsControl.this.getFingerForPoint(point);
                if (this.previousFinger == n) {
                    return;
                }
                if (this.previousFinger != -1) {
                    ((FingerControl)HandsControl.this.fingerLabels.get(DPFPFingerIndex.values()[this.previousFinger])).setSelected(false);
                }
                this.previousFinger = n;
                if (n != -1) {
                    HandsControl.this.setCursor(Cursor.getPredefinedCursor(12));
                    ((FingerControl)HandsControl.this.fingerLabels.get(DPFPFingerIndex.values()[n])).setSelected(true);
                } else {
                    HandsControl.this.setCursor(Cursor.getPredefinedCursor(0));
                }
                HandsControl.this.repaint();
            }
        });
    }

    public EnumSet<DPFPFingerIndex> getEnrolledFingers() {
        return this.fingers;
    }

    public void setEnrolledFingers(EnumSet<DPFPFingerIndex> enumSet) {
        this.fingers = enumSet;
        for (DPFPFingerIndex dPFPFingerIndex : DPFPFingerIndex.values()) {
            this.fingerLabels.get(dPFPFingerIndex).setEnrolled(enumSet.contains(dPFPFingerIndex));
        }
    }

    public void showPopup(DPFPFingerIndex dPFPFingerIndex, String string, String string2) {
        BalloonControl.popup(this.fingerLabels.get(dPFPFingerIndex), string, string2);
    }

    public void addFingerToggleListener(FingerToggleListener fingerToggleListener) {
        this.listenerList.add(FingerToggleListener.class, fingerToggleListener);
    }

    public void removeFingerToggleListener(FingerToggleListener fingerToggleListener) {
        this.listenerList.remove(FingerToggleListener.class, fingerToggleListener);
    }

    private int getFingerForPoint(Point point) {
        if (point.x < 0 || point.x >= maskImage.getWidth() || point.y < 0 || point.y >= maskImage.getHeight()) {
            return -1;
        }
        int n = maskImage.getRGB(point.x, point.y);
        int n2 = (n & 0xF0) >> 4;
        if ((n & 0xF) == 0 && (n & 0xFF) == (n >> 8 & 0xFF) && (n & 0xFF) == (n >> 16 & 0xFF) && n2 >= 1 && n2 <= 10) {
            return n2 - 1;
        }
        return -1;
    }

    static {
        try {
            maskImage = ImageIO.read(DPFPEnrollmentControl.class.getResourceAsStream(maskFilename));
            palmsImage = ImageIO.read(DPFPEnrollmentControl.class.getResourceAsStream(palmsFilename));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

