/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPFingerIndex;
import com.digitalpersona.onetouch.ui.swing.FingerToggleListener;
import com.digitalpersona.onetouch.ui.swing.FingerTogglelEvent;
import com.digitalpersona.onetouch.ui.swing.HandsControl;
import com.digitalpersona.onetouch.ui.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HandsPanel
extends JPanel {
    private static ResourceBundle labels = ResourceBundle.getBundle("dpfpui");
    private int maxCount;
    private HandsControl handsControl = new HandsControl();
    private JEditorPane promptLabel = Utilities.getXTextPane();

    public HandsPanel() {
        this.setOpaque(false);
        this.promptLabel.setText(labels.getString("IDS_REGPAGE_HEADER"));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        JPanel jPanel = Utilities.getXBox();
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        jPanel.add(this.handsControl);
        this.add((Component)this.promptLabel, "First");
        this.add((Component)jPanel, "Center");
        this.maxCount = DPFPFingerIndex.values().length;
        this.handsControl.addFingerToggleListener(new FingerToggleListener(){

            public void fingerAdded(FingerTogglelEvent fingerTogglelEvent) {
                if (HandsPanel.this.getEnrolledFingers().size() < HandsPanel.this.maxCount) {
                    for (FingerToggleListener fingerToggleListener : (FingerToggleListener[])HandsPanel.this.getListeners(FingerToggleListener.class)) {
                        try {
                            fingerToggleListener.fingerAdded(fingerTogglelEvent);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(HandsPanel.this, labels.getString("IDS_MAX_FINGERS"), labels.getString("IDS_WIZARD_TITLE"), 0);
                }
            }

            public void fingerRemoved(FingerTogglelEvent fingerTogglelEvent) {
                for (FingerToggleListener fingerToggleListener : (FingerToggleListener[])HandsPanel.this.getListeners(FingerToggleListener.class)) {
                    try {
                        fingerToggleListener.fingerRemoved(fingerTogglelEvent);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("enabled")) {
                    if (HandsPanel.this.promptLabel != null) {
                        HandsPanel.this.promptLabel.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                    }
                    if (HandsPanel.this.handsControl != null) {
                        HandsPanel.this.handsControl.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("foreground")) {
                    if (HandsPanel.this.promptLabel != null) {
                        HandsPanel.this.promptLabel.setForeground((Color)propertyChangeEvent.getNewValue());
                    }
                } else if (string.equals("font") && HandsPanel.this.promptLabel != null) {
                    HandsPanel.this.promptLabel.setFont((Font)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public EnumSet<DPFPFingerIndex> getEnrolledFingers() {
        return this.handsControl.getEnrolledFingers();
    }

    public void setEnrolledFingers(EnumSet<DPFPFingerIndex> enumSet) {
        this.handsControl.setEnrolledFingers(enumSet);
    }

    public int getMaxEnrollFingerCount() {
        return this.maxCount;
    }

    public void setMaxEnrollFingerCount(int n) {
        this.maxCount = n;
    }

    public void showPopup(DPFPFingerIndex dPFPFingerIndex, String string, String string2) {
        this.handsControl.showPopup(dPFPFingerIndex, string, string2);
    }

    public void addFingerToggleListener(FingerToggleListener fingerToggleListener) {
        this.listenerList.add(FingerToggleListener.class, fingerToggleListener);
    }

    public void removeFingerToggleListener(FingerToggleListener fingerToggleListener) {
        this.listenerList.remove(FingerToggleListener.class, fingerToggleListener);
    }
}

