/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.ui.swing.DPFPEnrollmentControl;
import java.awt.Dimension;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

class ScoreboardControl
extends JLabel {
    private static final String[] filenames = new String[]{"/images/score0.png", "/images/score1.png", "/images/score2.png", "/images/score3.png", "/images/score4.png"};
    private static final ImageIcon[] icons;
    private int score = 0;

    public ScoreboardControl() {
        super(icons[0]);
        Icon icon = this.getIcon();
        this.setLayout(null);
        Dimension dimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.setHorizontalAlignment(10);
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(final int n) {
        this.score = n;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScoreboardControl.this.setIcon(icons[n]);
            }
        });
    }

    static {
        try {
            icons = new ImageIcon[filenames.length];
            for (int i = 0; i < icons.length; ++i) {
                ScoreboardControl.icons[i] = new ImageIcon(ImageIO.read(DPFPEnrollmentControl.class.getResourceAsStream(filenames[i])));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

