/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPCaptureFeedback;
import com.digitalpersona.onetouch.DPFPFingerIndex;
import com.digitalpersona.onetouch.readers.DPFPReaderImpressionType;
import java.awt.BorderLayout;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

class Utilities {
    private static ResourceBundle labels = ResourceBundle.getBundle("dpfpui");

    Utilities() {
    }

    public static JPanel getXBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setOpaque(false);
        return jPanel;
    }

    public static JPanel getXBorder() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        return jPanel;
    }

    public static JEditorPane getXTextPane() {
        return Utilities.getXTextPane("");
    }

    public static JEditorPane getXTextPane(String string) {
        JEditorPane jEditorPane = new JEditorPane("text/html", string);
        jEditorPane.setOpaque(false);
        jEditorPane.setEditable(false);
        jEditorPane.setFont(UIManager.getFont("Panel.font"));
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        return jEditorPane;
    }

    public static String getFeedbackString(DPFPReaderImpressionType dPFPReaderImpressionType, DPFPCaptureFeedback dPFPCaptureFeedback) {
        if (dPFPReaderImpressionType == DPFPReaderImpressionType.READER_IMPRESSION_TYPE_AREA) {
            switch (dPFPCaptureFeedback) {
                case CAPTURE_FEEDBACK_GOOD: {
                    return labels.getString("IDS_CC_QUALITY_0");
                }
                case CAPTURE_FEEDBACK_TOO_LIGHT: {
                    return labels.getString("IDS_CC_QUALITY_2");
                }
                case CAPTURE_FEEDBACK_TOO_DARK: {
                    return labels.getString("IDS_CC_QUALITY_3");
                }
                case CAPTURE_FEEDBACK_TOO_NOISY: {
                    return labels.getString("IDS_CC_QUALITY_4");
                }
                case CAPTURE_FEEDBACK_LOW_CONTRAST: {
                    return labels.getString("IDS_CC_QUALITY_5");
                }
            }
            return labels.getString("IDS_CC_QUALITY_U");
        }
        switch (dPFPCaptureFeedback) {
            case CAPTURE_FEEDBACK_GOOD: {
                return labels.getString("IDS_SWIPE_QUALITY_SCAN_SUCCESS");
            }
            case CAPTURE_FEEDBACK_TOO_LIGHT: 
            case CAPTURE_FEEDBACK_TOO_DARK: 
            case CAPTURE_FEEDBACK_TOO_NOISY: 
            case CAPTURE_FEEDBACK_LOW_CONTRAST: 
            case CAPTURE_FEEDBACK_NONE: 
            case CAPTURE_FEEDBACK_NOT_ENOUGH_FEATURES: 
            case CAPTURE_FEEDBACK_NO_CENTRAL_REGION: {
                return labels.getString("IDS_SWIPE_QUALITY_SCAN_CENTER");
            }
            case CAPTURE_FEEDBACK_NO_FINGER: 
            case CAPTURE_FEEDBACK_TOO_HIGH: 
            case CAPTURE_FEEDBACK_TOO_LOW: 
            case CAPTURE_FEEDBACK_TOO_SHORT: {
                return labels.getString("IDS_SWIPE_QUALITY_SCAN_JOINT");
            }
            case CAPTURE_FEEDBACK_TOO_LEFT: 
            case CAPTURE_FEEDBACK_TOO_RIGHT: 
            case CAPTURE_FEEDBACK_TOO_STRANGE: 
            case CAPTURE_FEEDBACK_TOO_SKEWED: {
                return labels.getString("IDS_SWIPE_QUALITY_SCAN_CENTER");
            }
            case CAPTURE_FEEDBACK_TOO_FAST: {
                return labels.getString("IDS_SWIPE_QUALITY_TOO_FAST");
            }
            case CAPTURE_FEEDBACK_TOO_SLOW: {
                return labels.getString("IDS_SWIPE_QUALITY_TOO_SLOW");
            }
        }
        return "";
    }

    public static String fingerName(DPFPFingerIndex dPFPFingerIndex) {
        return labels.getString("IDS_FINGER_" + dPFPFingerIndex.ordinal());
    }

    public static String fingerprintName(DPFPFingerIndex dPFPFingerIndex) {
        return labels.getString("IDS_FINGERPRINT_" + dPFPFingerIndex.ordinal());
    }
}

