/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.onetouch.ui.swing;

import com.digitalpersona.onetouch.DPFPDataPurpose;
import com.digitalpersona.onetouch.DPFPFeatureSet;
import com.digitalpersona.onetouch.DPFPGlobal;
import com.digitalpersona.onetouch.DPFPSample;
import com.digitalpersona.onetouch.capture.DPFPCapture;
import com.digitalpersona.onetouch.capture.event.DPFPDataEvent;
import com.digitalpersona.onetouch.capture.event.DPFPDataListener;
import com.digitalpersona.onetouch.processing.DPFPFeatureExtraction;
import com.digitalpersona.onetouch.processing.DPFPImageQualityException;
import com.digitalpersona.onetouch.ui.swing.DPFPVerificationEvent;
import com.digitalpersona.onetouch.ui.swing.DPFPVerificationListener;
import com.digitalpersona.onetouch.ui.swing.DPFPVerificationVetoException;
import com.digitalpersona.onetouch.ui.swing.VerificationSensorControl;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DPFPVerificationControl
extends JPanel {
    private static final long serialVersionUID = 642123616397849523L;
    private transient DPFPCapture capture = null;
    private transient VerificationSensorControl sensor = new VerificationSensorControl();
    private transient boolean finishing = false;
    private String serialNumber = null;
    public static final String READER_SERIAL_NUMBER_PROPERTY = "readerSerialNumber";

    public DPFPVerificationControl() {
        this.add(this.sensor);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getID() == 1400 && (hierarchyEvent.getChangeFlags() & 4L) != 0L && !DPFPVerificationControl.this.isShowing()) {
                    DPFPVerificationControl.this.stop();
                }
            }
        });
    }

    public String getReaderSerialNumber() {
        return this.serialNumber;
    }

    public void setReaderSerialNumber(String string) {
        String string2 = this.getReaderSerialNumber();
        this.stop();
        this.serialNumber = string;
        this.firePropertyChange(READER_SERIAL_NUMBER_PROPERTY, string2, this.getReaderSerialNumber());
    }

    public void addVerificationListener(DPFPVerificationListener dPFPVerificationListener) {
        this.listenerList.add(DPFPVerificationListener.class, dPFPVerificationListener);
    }

    public void removeVerificationListener(DPFPVerificationListener dPFPVerificationListener) {
        this.listenerList.remove(DPFPVerificationListener.class, dPFPVerificationListener);
    }

    public void start() {
        this.sensor.showNormal();
        this.capture = DPFPGlobal.getCaptureFactory().createCapture(this.serialNumber);
        this.capture.addDataListener(new DPFPDataListener(){

            public void dataAcquired(final DPFPDataEvent dPFPDataEvent) {
                if (DPFPVerificationControl.this.finishing) {
                    return;
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            block17: {
                                DPFPSample dPFPSample = dPFPDataEvent.getSample();
                                if (dPFPSample == null) {
                                    DPFPVerificationControl.this.sensor.showFailed(true);
                                    return;
                                }
                                DPFPFeatureExtraction dPFPFeatureExtraction = DPFPGlobal.getFeatureExtractionFactory().createFeatureExtraction();
                                try {
                                    DPFPVerificationEvent dPFPVerificationEvent;
                                    block16: {
                                        DPFPFeatureSet dPFPFeatureSet = dPFPFeatureExtraction.createFeatureSet(dPFPSample, DPFPDataPurpose.DATA_PURPOSE_VERIFICATION);
                                        dPFPVerificationEvent = new DPFPVerificationEvent(DPFPVerificationControl.this, dPFPFeatureSet);
                                        try {
                                            for (DPFPVerificationListener dPFPVerificationListener : (DPFPVerificationListener[])DPFPVerificationControl.this.getListeners(DPFPVerificationListener.class)) {
                                                dPFPVerificationListener.captureCompleted(dPFPVerificationEvent);
                                            }
                                            if (!dPFPVerificationEvent.getStopCapture()) break block16;
                                        }
                                        catch (DPFPVerificationVetoException dPFPVerificationVetoException) {
                                            block18: {
                                                try {
                                                    dPFPVerificationEvent.setMatched(false);
                                                    if (!dPFPVerificationEvent.getStopCapture()) break block18;
                                                }
                                                catch (Throwable throwable) {
                                                    if (dPFPVerificationEvent.getStopCapture()) {
                                                        DPFPVerificationControl.this.capture.stopCapture();
                                                    }
                                                    if (dPFPVerificationEvent.getMatched()) {
                                                        DPFPVerificationControl.this.sensor.showMatched(!dPFPVerificationEvent.getStopCapture());
                                                    } else {
                                                        DPFPVerificationControl.this.sensor.showFailed(!dPFPVerificationEvent.getStopCapture());
                                                    }
                                                    throw throwable;
                                                }
                                                DPFPVerificationControl.this.capture.stopCapture();
                                            }
                                            if (dPFPVerificationEvent.getMatched()) {
                                                DPFPVerificationControl.this.sensor.showMatched(!dPFPVerificationEvent.getStopCapture());
                                            } else {
                                                DPFPVerificationControl.this.sensor.showFailed(!dPFPVerificationEvent.getStopCapture());
                                            }
                                            break block17;
                                        }
                                        DPFPVerificationControl.this.capture.stopCapture();
                                    }
                                    if (dPFPVerificationEvent.getMatched()) {
                                        DPFPVerificationControl.this.sensor.showMatched(!dPFPVerificationEvent.getStopCapture());
                                    } else {
                                        DPFPVerificationControl.this.sensor.showFailed(!dPFPVerificationEvent.getStopCapture());
                                    }
                                }
                                catch (DPFPImageQualityException dPFPImageQualityException) {
                                    DPFPVerificationControl.this.sensor.showFailed(true);
                                }
                                catch (Exception exception) {
                                    DPFPVerificationControl.this.sensor.showFailed(true);
                                }
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.capture.startCapture();
    }

    public void stop() {
        if (this.capture != null && !this.finishing) {
            this.finishing = true;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        DPFPVerificationControl.this.sensor.showFailed(false);
                        DPFPVerificationControl.this.capture.stopCapture();
                        DPFPVerificationControl.this.capture = null;
                        DPFPVerificationControl.this.finishing = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public boolean isStopping() {
        return this.finishing;
    }
}

