/*
 * Decompiled with CFR 0.152.
 */
package au.com.ordermate.xmlintegration.adyen;

import au.com.ordermate.xmlintegration.adyen.AdyenSurchargeCurrency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AdyenSurchargeConfiguration", propOrder={"Brand", "Currencies", "Sources"})
public class AdyenSurchargeConfiguration {
    @XmlElement(name="brand")
    protected String Brand;
    @XmlElement(name="currencies")
    protected AdyenSurchargeCurrency[] Currencies;
    @XmlElement(name="sources")
    protected String[] Sources;

    public String getBrand() {
        return this.Brand;
    }

    public AdyenSurchargeCurrency[] getCurrencies() {
        return this.Currencies;
    }

    public AdyenSurchargeCurrency getCurrency() {
        if (this.Currencies == null || this.Currencies.length == 0) {
            ArrayList<AdyenSurchargeCurrency> curList = new ArrayList<AdyenSurchargeCurrency>();
            curList.add(new AdyenSurchargeCurrency());
            this.Currencies = curList.toArray(new AdyenSurchargeCurrency[0]);
        }
        return this.Currencies[0];
    }

    public void setAmount(BigDecimal amt) {
        this.Currencies[0].setAmount(amt);
    }

    public void setPercentage(BigDecimal per) {
        this.Currencies[0].setPercentage(per);
    }

    public void setCurrencyCode(String code) {
        if (this.Currencies == null || this.Currencies.length == 0) {
            ArrayList<AdyenSurchargeCurrency> curList = new ArrayList<AdyenSurchargeCurrency>();
            curList.add(new AdyenSurchargeCurrency());
            this.Currencies = curList.toArray(new AdyenSurchargeCurrency[0]);
        }
        this.Currencies[0].setCurrencyCode(code);
    }

    public String[] getSources() {
        if (this.Sources == null) {
            ArrayList srcList = new ArrayList();
            this.Sources = srcList.toArray(new String[0]);
        }
        return this.Sources;
    }

    public void setBrand(String brand) {
        this.Brand = brand;
    }

    public void setCurrencies(AdyenSurchargeCurrency[] currencies) {
        this.Currencies = currencies;
    }

    public void setSources(String[] sources) {
        this.Sources = sources;
    }

    public boolean usesCredit() {
        return Arrays.asList(this.getSources()).contains("Credit");
    }

    public boolean usesDebit() {
        return Arrays.asList(this.getSources()).contains("Debit");
    }

    public void addSource(String src) {
        if (!Arrays.asList(this.getSources()).contains(src)) {
            ArrayList<String> srcList = new ArrayList<String>();
            Collections.addAll(srcList, this.Sources);
            srcList.add(src);
            this.Sources = srcList.toArray(new String[0]);
        }
    }

    public void removeSource(String src) {
        if (Arrays.asList(this.getSources()).contains(src)) {
            ArrayList srcList = new ArrayList();
            Collections.addAll(srcList, this.Sources);
            srcList.remove(src);
            this.Sources = srcList.toArray(new String[0]);
        }
    }
}

