/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import au.com.ordermate.configuration.Config;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.OrderMate;
import ordermate.gui.themes.OrderMateTheme;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;
import waitermate.guikit.TabScreen;

public abstract class CompositeScreen
extends AbstractScreen {
    private JTabbedPane tabs = new JTabbedPane();
    private List<TabScreen> states;
    private TabScreen currentState;
    private boolean isVisible;

    public CompositeScreen() {
        OrderMateTheme.setupTabbedPane((JTabbedPane)this.tabs);
        this.tabs.setFont(OrderMateTheme.getLargeFont());
        this.states = new ArrayList<TabScreen>();
        this.tabs.addChangeListener(new InnerChangeListener());
        this.tabs.setName("Tabs");
    }

    public boolean hasSubStates() {
        return this.states.size() > 0;
    }

    public final void addGuiState(TabScreen state, String name) {
        this.addGuiState(this.tabs.getTabCount(), state, name);
    }

    protected final void addGuiState(int index, TabScreen state, String name) {
        if (this.states.contains(state)) {
            throw new IllegalArgumentException("State to add is already a substate");
        }
        this.states.add(index, state);
        state.setTabName(name);
        state.setParent(this);
        this.tabs.insertTab(name, null, state.getMainArea(), null, index);
        this.tabs.validate();
        if (this.currentState == null) {
            this.currentState = state;
        }
    }

    public final void selectState(int index) {
        if (index >= 0 && index < this.tabs.getTabCount()) {
            this.tabs.setSelectedIndex(index);
            this.tabChanged();
        }
    }

    public final void selectState(String name) {
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            if (!this.tabs.getTitleAt(i).equalsIgnoreCase(name)) continue;
            this.tabs.setSelectedIndex(i);
            i = this.tabs.getTabCount();
            this.tabChanged();
        }
    }

    public final void selectState(Component comp) {
        int index;
        if (comp != null && (index = this.tabs.indexOfComponent(comp)) >= 0) {
            this.tabs.setSelectedIndex(index);
            this.tabChanged();
        }
    }

    protected List<TabScreen> getSubStates() {
        return this.states;
    }

    protected final void removeGuiState(TabScreen state) {
        if (!this.states.contains(state)) {
            throw new IllegalArgumentException("State is not present, cannot remove it :" + state);
        }
        state.tearDown();
        this.states.remove(state);
        state.setParent(null);
        if (this.tabs.indexOfComponent(state.getMainArea()) > -1) {
            this.tabs.remove(state.getMainArea());
        }
        this.currentState = this.currentState == state && this.states.size() > 0 ? this.states.get(0) : null;
    }

    protected final List getGUIStates(Class tabScreenClass) {
        ArrayList<TabScreen> statesOfClass = new ArrayList<TabScreen>();
        for (TabScreen screen : this.states) {
            if (!screen.getClass().isAssignableFrom(tabScreenClass)) continue;
            statesOfClass.add(screen);
        }
        return statesOfClass;
    }

    @Override
    public JComponent getMainArea() {
        return this.tabs;
    }

    @Override
    public NavBar getNavBar() {
        if (this.states.isEmpty()) {
            if (Config.isDebuging()) {
                throw new IllegalStateException("CompositeScreen " + this.getClass() + " has no sub states");
            }
            OrderMate.LOG.warn("CompositeScreen " + this.getClass() + " has no sub states");
            return null;
        }
        TabScreen screen = this.currentState;
        if (screen == null) {
            screen = this.states.get(0);
            this.setCurrentState(screen);
        }
        return screen.getNavBar();
    }

    public TabScreen getCurrentState() {
        if (this.currentState == null) {
            Component selectedTab = this.tabs.getSelectedComponent();
            for (TabScreen screen : this.states) {
                if (!screen.getMainArea().equals(selectedTab)) continue;
                this.currentState = screen;
            }
        }
        return this.currentState;
    }

    public TabScreen removeState(String name) {
        int tabIx = this.tabs.indexOfTab(name);
        if (tabIx < 0) {
            throw new IllegalArgumentException("This state doesn't exist: " + name);
        }
        this.tabs.remove(tabIx);
        TabScreen removed = this.states.remove(tabIx);
        if (removed == null) {
            throw new IllegalStateException("The state " + name + " has not been removed from the list " + this.states);
        }
        removed.displose();
        return removed;
    }

    @Override
    public void setUp() {
        this.isVisible = true;
        this.getCurrentState();
        if (this.currentState == null) {
            OrderMate.LOG.warn("Calling setup with null current state");
        } else {
            this.currentState.setUp();
        }
        this.displayed.emit();
    }

    @Override
    public void tearDown() {
        this.getCurrentState();
        if (this.currentState != null) {
            this.currentState.tearDown();
        }
        this.isVisible = false;
        this.hidden.emit();
    }

    protected void tabChanged() {
        boolean isDifferent;
        boolean bl = isDifferent = this.currentState != this.states.get(this.tabs.getSelectedIndex());
        if (this.currentState != null && isDifferent) {
            this.currentState.tearDown();
        }
        this.currentState = this.states.get(this.tabs.getSelectedIndex());
        super.display();
    }

    public void setTabName(TabScreen screen, String tabName) {
        int index = this.tabs.indexOfComponent(screen.getMainArea());
        if (index >= 0) {
            this.tabs.setTitleAt(index, tabName);
        }
    }

    protected void setCurrentState(TabScreen screen) {
        if (this.currentState != screen) {
            if (this.currentState != null) {
                this.currentState.tearDown();
            }
            this.currentState = screen;
            this.currentState.setUp();
        }
        this.tabs.setSelectedComponent(screen.getMainArea());
    }

    public void setTabVisible(TabScreen screen, boolean visible) {
        int index = this.tabs.indexOfComponent(screen.getMainArea());
        if (index >= 0) {
            this.tabs.getComponentAt(index).setVisible(visible);
        }
    }

    public void setTabColour(final TabScreen screen, final Color color) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int index = CompositeScreen.this.tabs.indexOfComponent(screen.getMainArea());
                if (index >= 0) {
                    CompositeScreen.this.tabs.setBackgroundAt(index, color);
                }
            }
        });
    }

    public boolean hasScreen(TabScreen screen) {
        return this.states.contains(screen);
    }

    public int indexOfState(String tabName) {
        int index = -1;
        for (int i = 0; i < this.tabs.getTabCount(); ++i) {
            if (!this.tabs.getTitleAt(i).equalsIgnoreCase(tabName)) continue;
            index = i;
            i = this.tabs.getTabCount();
        }
        return index;
    }

    private class InnerChangeListener
    implements ChangeListener {
        private InnerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == CompositeScreen.this.tabs && CompositeScreen.this.isVisible) {
                CompositeScreen.this.tabChanged();
            }
        }
    }
}

