/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.components.DrawerToggleButton;

public class NavBar
extends JPanel
implements ActionListener {
    public final Signal back = Signals.createSignal();
    public final Signal forwards = Signals.createSignal();
    public final Signal ok = Signals.createSignal();
    public final Signal cancel = Signals.createSignal();
    public final Signal logout = Signals.createSignal();
    public final Signal config = Signals.createSignal();
    public final Signal print = Signals.createSignal();
    public final Signal admin = Signals.createSignal();
    public final Signal clear = Signals.createSignal();
    private static final int BORDER_WIDTH = 10;
    private JButton backButton;
    private JButton forwardsButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton logoutButton;
    private JButton configButton;
    private JButton printButton;
    private JButton adminButton;
    private JButton clearButton;
    private final JLabel centerImage;
    private final JPanel leftBox = new JPanel();
    private final JPanel rightBox;

    public NavBar() {
        this.leftBox.setOpaque(false);
        this.leftBox.setLayout(new BoxLayout(this.leftBox, 0));
        this.rightBox = new JPanel();
        this.rightBox.setOpaque(false);
        this.rightBox.setLayout(new BoxLayout(this.rightBox, 0));
        this.centerImage = new JLabel();
        this.centerImage.setName("centerImage");
        this.centerImage.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.centerImage.setFont(OrderMateTheme.getMediumFont());
        this.centerImage.setHorizontalAlignment(0);
        if (this.showBackground()) {
            this.setBackground(UIManager.getColor("TextArea.background"));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.leftBox, "West");
        this.add((Component)this.rightBox, "East");
        this.add((Component)this.centerImage, "Center");
    }

    private boolean showBackground() {
        return true;
    }

    private AbstractButton setupButton(AbstractButton toSetup, Icon icon, String text, String name, Insets insets) {
        toSetup.setIcon(icon);
        toSetup.setText(text);
        toSetup.setName(name);
        return this.setupButton(toSetup, insets);
    }

    private <T extends AbstractButton> T setupButton(final T toSetup, Insets insets) {
        toSetup.setHorizontalTextPosition(0);
        toSetup.setVerticalTextPosition(3);
        toSetup.setForeground(UIManager.getColor("TextArea.foreground"));
        if (insets != null) {
            toSetup.setMargin(insets);
        }
        toSetup.addActionListener(this);
        OrderMateTheme.setupTransparentButton(toSetup);
        toSetup.setBorderPainted(true);
        toSetup.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                e.consume();
                toSetup.doClick();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                e.consume();
            }
        });
        return toSetup;
    }

    public DrawerToggleButton constructDrawerToggleButton(String text, ImageIcon openIcon, ImageIcon closedIcon) {
        DrawerToggleButton newButton = new DrawerToggleButton((Icon)openIcon, (Icon)closedIcon);
        newButton.setText(text);
        OrderMateTheme.setupTransparentButton((AbstractButton)newButton);
        newButton.setHorizontalTextPosition(0);
        newButton.setVerticalTextPosition(3);
        newButton.setName(text);
        return newButton;
    }

    public DrawerToggleButton constructDrawerToggleButton(String text) {
        return this.constructDrawerToggleButton(text, IconLoader.get((String)"/waitermate/guikit/images/selectTypeUp.png"), IconLoader.get((String)"/waitermate/guikit/images/selectTypeDown.png"));
    }

    public JButton constructButton(Icon icon, String text, String name) {
        return this.constructButton(icon, text, name, null, null);
    }

    public JButton constructButton(Icon icon, String text, String name, Signal signal) {
        return this.constructButton(icon, text, name, null, signal);
    }

    public JButton constructButton(Icon icon, String text, String name, Insets insets) {
        return this.constructButton(icon, text, name, insets, null);
    }

    public JButton constructButton(BasicAction action) {
        return this.setupButton(new JButton((Action)action), null);
    }

    public JButton constructButton(Icon icon, String text, String name, Insets insets, final Signal signal) {
        JButton button = (JButton)this.setupButton(new JButton(), icon, text, name, insets);
        if (signal != null) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    signal.emit();
                }
            });
        }
        return button;
    }

    public JToggleButton constructToggleButton(Icon icon, String text) {
        return (JToggleButton)this.setupButton(new JToggleButton(), icon, text, text, null);
    }

    public void addLeft(Component toAdd) {
        this.leftBox.add(toAdd);
        this.revalidate();
        this.repaint();
    }

    public void addLeft(Component toAdd, int index) {
        if (index >= this.leftBox.getComponentCount()) {
            this.leftBox.add(toAdd);
        }
        this.leftBox.add(toAdd, index);
        this.revalidate();
        this.repaint();
    }

    public void removeLeft(Component toRemove) {
        this.leftBox.remove(toRemove);
        this.revalidate();
        this.repaint();
    }

    public void addRight(Component toAdd) {
        this.rightBox.add(toAdd);
        this.revalidate();
        this.repaint();
    }

    public void removeRight(Component toRemove) {
        this.rightBox.remove(toRemove);
        this.revalidate();
        this.repaint();
    }

    public void removeAllRight() {
        this.rightBox.removeAll();
        this.revalidate();
        this.repaint();
    }

    protected JComponent getRightBox() {
        return this.rightBox;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.backButton) {
            this.back.emit();
        } else if (source == this.forwardsButton) {
            this.forwards.emit();
        } else if (source == this.okButton) {
            this.ok.emit();
        } else if (source == this.cancelButton) {
            this.cancel.emit();
        } else if (source == this.configButton) {
            this.config.emit();
        } else if (source == this.logoutButton) {
            this.logout.emit();
        } else if (source == this.printButton) {
            this.print.emit();
        } else if (source == this.adminButton) {
            this.admin.emit();
        } else if (source == this.clearButton) {
            this.clear.emit();
        }
    }

    public JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.setupButton(this.backButton, IconLoader.get((String)"/waitermate/guikit/images/back.png"), Internationalization.getLiteralFor((String)"BACK"), "backButton", null);
        }
        return this.backButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.setupButton(this.cancelButton, IconLoader.get((String)"/waitermate/guikit/images/cancel.png"), Internationalization.getLiteralFor((String)"CANCEL"), "cancelButton", null);
        }
        return this.cancelButton;
    }

    public JButton getConfigButton() {
        if (this.configButton == null) {
            this.configButton = new JButton();
            this.setupButton(this.configButton, IconLoader.get((String)"/waitermate/guikit/images/accountAdmin.png"), Internationalization.getLiteralFor((String)"ACCOUNT_ADMIN"), "configButton", null);
        }
        return this.configButton;
    }

    public JButton getAdminButton() {
        if (this.adminButton == null) {
            this.adminButton = new JButton();
            this.setupButton(this.adminButton, IconLoader.get((String)"/waitermate/guikit/images/admin.png"), Internationalization.getLiteralFor((String)"SYSTEM_ADMIN"), "adminButton", null);
        }
        return this.adminButton;
    }

    public JButton getForwardsButton() {
        if (this.forwardsButton == null) {
            this.forwardsButton = new JButton();
            this.setupButton(this.forwardsButton, IconLoader.get((String)"/waitermate/guikit/images/forward.png"), Internationalization.getLiteralFor((String)"FORWARD"), "forwardsButton", null);
        }
        return this.forwardsButton;
    }

    public JButton getLogoutButton() {
        if (this.logoutButton == null) {
            this.logoutButton = new JButton();
            this.setupButton(this.logoutButton, IconLoader.get((String)"/waitermate/guikit/images/lock.png"), Internationalization.getLiteralFor((String)"LOGOUT"), "logoutButton", null);
        }
        return this.logoutButton;
    }

    public JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.setupButton(this.okButton, IconLoader.get((String)"/waitermate/guikit/images/ok.png"), Internationalization.getLiteralFor((String)"OK"), "okButton", null);
        }
        return this.okButton;
    }

    public JButton getPrintButton() {
        if (this.printButton == null) {
            this.printButton = new JButton();
            this.setupButton(this.printButton, IconLoader.get((String)"/waitermate/guikit/images/print.png"), Internationalization.getLiteralFor((String)"PRINT_BILL"), "printButton", null);
        }
        return this.printButton;
    }

    public JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.setupButton(this.clearButton, IconLoader.get((String)"/waitermate/guikit/images/clear.png"), Internationalization.getLiteralFor((String)"CLEAR"), "clearButton", null);
        }
        return this.clearButton;
    }

    public void setText(String text) {
        this.centerImage.setText(text);
    }

    public String getText() {
        return this.centerImage.getText();
    }

    public void setImage(String filename) {
        this.centerImage.setIcon(filename != null ? IconLoader.get((String)filename) : null);
    }

    public void setCenterFont(Font newFont) {
        this.centerImage.setFont(newFont);
    }

    protected JLabel getCentreLabel() {
        return this.centerImage;
    }

    public void hideAllButtons() {
        Component[] components = this.leftBox.getComponents();
        boolean secondTime = false;
        do {
            for (int i = 0; i < components.length; ++i) {
                components[i].setVisible(false);
            }
            components = this.rightBox.getComponents();
        } while (secondTime = !secondTime);
    }

    public void setOkButton(JButton newOkButton) {
        this.okButton = newOkButton;
    }
}

