/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import ordermate.OrderMate;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.users.User;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.ModalCondition;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResourceMenu;
import waitermate.guikit.UIActionLogger;
import waitermate.guikit.components.DrawerToggleButton;

public class ScreenResource {
    public static final Color DRAWER_BACKGROUND_COLOR = new Color(255, 255, 255, 200);
    private static final int NAV_RATIO = 5;
    private static Rectangle navArea = new Rectangle(0, 4, 5, 1);
    private static Rectangle mainArea = new Rectangle(0, 0, 5, 4);
    private static Rectangle fullscreen_area = new Rectangle(0, 0, 5, 5);
    private static final int ANNIMATION_SPEED_MILLISEC = 250;
    static JFrame target;
    static JPanel mainPanel;
    private static ScreenResourceMenu menu;
    private static AbstractScreen currentScreen;
    private static JComponent currentNavArea;
    private static JComponent currentMainArea;
    private static DrawerToggleButton currentDrawerButton;
    private static Animator currentDrawerAnimation;
    private static boolean currentDrawerIsClosing;
    private static AbstractScreen tempScreen;
    private static GlassPanel glass;
    private static Map<JComponent, JDialog> dialogMap;
    private static JDialog baseDialog;
    private static final List<JDialog> dialogPool;
    private static final int DIALOG_RETENTION = 1;
    private static Object modalWait;
    private static boolean consumeMouseEvents;
    private static boolean greyoverLatched;
    private static DroppingQueue dropIt;
    private static final DefaultModalCondition defaultCondition;

    public static final GlassPanel getGlassPanel() {
        glass.setVisible(true);
        return glass;
    }

    public static synchronized void setTargetFrameBorderLayout(JFrame newTarget) {
        mainPanel.setLayout(new BorderLayout());
        ScreenResource.setTarget(newTarget);
        navArea = null;
        mainArea = null;
        fullscreen_area = null;
        ScreenResource.setupGlassPane();
    }

    public static synchronized void setTargetFrame(JFrame newTarget, Rectangle mainAreaBounds, Rectangle navBarBounds) {
        ScreenResource.setTarget(newTarget);
        ExperimentalFeature exp = ExperimentalFeature.find((String)"GlassPane Consume Events");
        boolean bl = consumeMouseEvents = exp != null && exp.getBooleanValue(Boolean.FALSE) != false;
        if (consumeMouseEvents) {
            OrderMate.LOG.info("Consuming grey-over events");
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            dropIt = new DroppingQueue(target);
            eventQueue.push(dropIt);
        }
        if (navBarBounds != null) {
            navArea = new Rectangle(navBarBounds);
        }
        if (mainAreaBounds != null) {
            mainArea = new Rectangle(mainAreaBounds);
        }
        fullscreen_area = new Rectangle(0, 0, Math.max(ScreenResource.navArea.width + ScreenResource.navArea.x, ScreenResource.mainArea.width + ScreenResource.mainArea.x), ScreenResource.navArea.height + ScreenResource.mainArea.height + ScreenResource.mainArea.y);
        ScreenResource.setupGlassPane();
    }

    private static void setupGlassPane() {
        glass = new GlassPanel();
        target.setGlassPane(glass);
        glass.setVisible(true);
        dialogPool.clear();
    }

    private static void setTarget(JFrame newTarget) {
        if (target != null) {
            throw new IllegalStateException("Target component can only be set once");
        }
        target = newTarget;
        target.add((Component)mainPanel, "Center");
    }

    public static JFrame getTarget() {
        if (target == null) {
            throw new IllegalStateException("Cannot call get target until target frame has been set");
        }
        return target;
    }

    public static void disposeTarget() {
        target.dispose();
        target = null;
    }

    public static final synchronized void refreshScreen() {
        ScreenResource.getScreen().display();
    }

    public static synchronized void setScreen(AbstractScreen toShow) {
        if (toShow != null && UIActionLogger.getInstance() != null) {
            UIActionLogger.getInstance().screenChanging(toShow);
        }
        boolean addMainArea = false;
        boolean addNavBar = false;
        if (toShow == null) {
            throw new IllegalArgumentException("Cannot set screen as NULL");
        }
        if (currentDrawerButton != null) {
            currentDrawerButton.closeDrawer();
        }
        if (consumeMouseEvents) {
            dropIt.pause();
        }
        if (currentMainArea != null && !currentMainArea.equals(toShow.getMainArea())) {
            mainPanel.remove(currentMainArea);
            addMainArea = true;
        } else if (currentMainArea == null) {
            addMainArea = true;
        }
        if (currentNavArea != null && !currentNavArea.equals(toShow.getNavBar())) {
            mainPanel.remove(currentNavArea);
            addNavBar = true;
        } else if (currentNavArea == null) {
            addNavBar = true;
        }
        if (currentScreen != null) {
            currentScreen.tearDown();
        }
        currentScreen = toShow;
        currentMainArea = currentScreen.getMainArea();
        currentNavArea = currentScreen.getNavBar();
        currentScreen.setUp();
        if (mainArea == null) {
            ScreenResource.addToBorderLayout(addMainArea, addNavBar);
        } else {
            ScreenResource.addToGridPaperLayout(addMainArea, addNavBar);
        }
        if (addMainArea || addNavBar) {
            target.validate();
            target.repaint();
        }
        NotificationManager.getInstance().notifyScreenChanged.emit((Object)currentScreen);
        if (UIActionLogger.getInstance() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIActionLogger.getInstance().screenChanged(currentScreen);
                }
            });
        }
        if (consumeMouseEvents) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    dropIt.resume();
                }
            });
        }
    }

    private static final void addToBorderLayout(boolean addMainArea, boolean addNavBar) {
        if (currentScreen.hasNavBar() && addNavBar) {
            mainPanel.add((Component)currentScreen.getNavBar(), "South");
        }
        if (addMainArea) {
            mainPanel.add((Component)currentScreen.getMainArea(), "Center");
        }
    }

    private static final void addToGridPaperLayout(boolean addMainArea, boolean addNavBar) {
        Rectangle MAIN_AREA_SIZE = fullscreen_area;
        if (currentScreen.hasNavBar()) {
            MAIN_AREA_SIZE = mainArea;
            if (addNavBar) {
                mainPanel.add((Component)currentNavArea, navArea);
            }
        }
        if (addMainArea) {
            mainPanel.add((Component)currentMainArea, MAIN_AREA_SIZE);
        }
    }

    public static synchronized void startPopupDrawer(DrawerToggleButton button) {
        int width;
        if (!currentScreen.hasNavBar()) {
            throw new IllegalStateException("Popup drawers can only be used when a nav bar is present");
        }
        button.getDrawer().setBackground(DRAWER_BACKGROUND_COLOR);
        if (currentDrawerButton != null) {
            currentDrawerButton.closeDrawerSlamShut();
        }
        if (currentDrawerAnimation != null) {
            currentDrawerAnimation.stop();
        }
        currentDrawerButton = button;
        final JComponent currentDrawer = currentDrawerButton.getDrawer();
        int bottom = currentMainArea.getHeight();
        int height = currentDrawer.getPreferredSize().height;
        if (height > currentMainArea.getHeight()) {
            height = currentMainArea.getHeight();
        }
        if ((width = currentDrawer.getPreferredSize().width) > target.getWidth() * 3 / 4) {
            width = target.getWidth() * 3 / 4;
        }
        currentDrawer.setSize(width, currentDrawer.getHeight());
        ScreenResource.getGlassPanel().add(currentDrawer);
        PropertySetter locationSetter = new PropertySetter((Object)currentDrawer, "location", (Object[])new Point[]{new Point(0, bottom - currentDrawer.getHeight()), new Point(0, bottom - height)});
        PropertySetter sizeSetter = new PropertySetter((Object)currentDrawer, "size", (Object[])new Dimension[]{currentDrawer.getSize(), new Dimension(currentDrawer.getWidth(), height)});
        currentDrawerAnimation = new Animator(250);
        currentDrawerAnimation.addTarget((TimingTarget)locationSetter);
        currentDrawerAnimation.addTarget((TimingTarget)sizeSetter);
        currentDrawerAnimation.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void timingEvent(float fraction) {
                currentDrawer.validate();
            }
        });
        currentDrawerAnimation.start();
    }

    public static boolean isCurrentDrawer(DrawerToggleButton button) {
        if (button == null) {
            return false;
        }
        return button.equals(currentDrawerButton);
    }

    public static synchronized void stopPopupDrawer() {
        if (currentDrawerIsClosing) {
            return;
        }
        currentDrawerIsClosing = true;
        if (currentDrawerButton == null) {
            throw new IllegalArgumentException("Cannnot stopPopupDrawer when no drawer displayed");
        }
        final JComponent currentDrawer = currentDrawerButton.getDrawer();
        int bottom = currentMainArea.getHeight();
        if (currentDrawerAnimation != null) {
            currentDrawerAnimation.stop();
        }
        PropertySetter locationSetter = new PropertySetter((Object)currentDrawer, "location", (Object[])new Point[]{new Point(0, bottom - currentDrawer.getHeight()), new Point(0, bottom)});
        PropertySetter sizeSetter = new PropertySetter((Object)currentDrawer, "size", (Object[])new Dimension[]{currentDrawer.getSize(), new Dimension(currentDrawer.getWidth(), 0)});
        currentDrawerAnimation = new Animator(250);
        currentDrawerAnimation.addTarget((TimingTarget)locationSetter);
        currentDrawerAnimation.addTarget((TimingTarget)sizeSetter);
        currentDrawerAnimation.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void timingEvent(float fraction) {
                currentDrawer.validate();
            }

            public void end() {
                glass.remove(currentDrawer);
                currentDrawerButton = null;
                currentDrawerAnimation = null;
                currentDrawerIsClosing = false;
            }
        });
        currentDrawerAnimation.start();
    }

    public static synchronized void startModalScreen(AbstractScreen screen) {
        if (currentScreen != null) {
            tempScreen = currentScreen;
        }
        if (UIActionLogger.getInstance() != null) {
            UIActionLogger.getInstance().dialogStarted(screen);
        }
        ScreenResource.setScreen(screen);
        try {
            ScreenResource.waitOnModal(currentMainArea);
        }
        catch (InterruptedException e) {
            ScreenResource.stopModalScreen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stopModalScreen() {
        if (tempScreen != null) {
            Object object = modalWait;
            synchronized (object) {
                modalWait.notifyAll();
            }
            ScreenResource.setScreen(tempScreen);
            if (UIActionLogger.getInstance() != null) {
                UIActionLogger.getInstance().dialogStopped();
            }
        } else {
            throw new IllegalStateException("Stop modal screen called before start modal screen");
        }
        tempScreen = null;
    }

    public static synchronized void startModalWindow(JPanel theWindow) {
        ScreenResource.startModalWindow(theWindow, null, false);
    }

    public static synchronized void startModalWindow(JPanel theWindow, Point location) {
        ScreenResource.startModalWindow(theWindow, location, false);
    }

    public static synchronized void startModalWindow(JPanel theWindow, Point location, boolean useBaseDialog) {
        JDialog dialog;
        if (ScreenResource.isShowing(theWindow)) {
            OrderMate.LOG.warn("Re-showing a dialog that is already showing. Duplicating dialogs may render the screen unusable.");
        }
        JDialog jDialog = dialog = useBaseDialog ? ScreenResource.getBaseDialog() : ScreenResource.getAvailableDialog();
        if (dialog.isVisible()) {
            JComponent baseComponent = null;
            for (JComponent key : dialogMap.keySet()) {
                if (!dialogMap.get(key).equals(baseDialog)) continue;
                baseComponent = key;
                break;
            }
            if (baseComponent != null) {
                dialogMap.remove(baseComponent);
            }
            dialog.getContentPane().removeAll();
        }
        JComponent contentPane = (JComponent)dialog.getContentPane();
        contentPane.add((Component)theWindow, "Center");
        if (!dialog.isVisible()) {
            ScreenResource.startModalWindow(dialog, theWindow, location);
        } else {
            dialogMap.put(theWindow, dialog);
            if (theWindow.getPreferredSize().getHeight() > (double)ScreenResource.getMaxDialogDimension().height || theWindow.getPreferredSize().getWidth() > (double)ScreenResource.getMaxDialogDimension().width) {
                theWindow.setPreferredSize(ScreenResource.getMaxDialogDimension());
            }
            dialog.setLocationRelativeTo(target);
            dialog.pack();
            dialog.repaint();
        }
    }

    private static Dimension refreshDialogSize(JDialog newDialog, Dimension max) {
        OrderMate.LOG.warn("Dialog size was invalid: Width - " + newDialog.getSize().width + ", Height - " + newDialog.getSize().height);
        if (newDialog.getPreferredSize().height > 0 || newDialog.getPreferredSize().width > 0) {
            return newDialog.getPreferredSize();
        }
        return new Dimension(max.width / 2, max.height / 2);
    }

    private static synchronized void startModalWindow(JDialog newDialog, JPanel centralComponent, Point location) {
        dialogMap.put(centralComponent, newDialog);
        if (glass != null) {
            glass.setGreyOverlayShowing(true);
        }
        Dimension max = ScreenResource.getMaxDialogDimension();
        newDialog.pack();
        if (newDialog.getSize().height <= 0 || newDialog.getSize().width <= 0) {
            newDialog.setSize(ScreenResource.refreshDialogSize(newDialog, max));
        }
        if (newDialog.getPreferredSize().width > max.width) {
            double heightFactor = (double)newDialog.getPreferredSize().width / (double)max.width * 2.0 - 1.0;
            double scaledHeight = (double)newDialog.getPreferredSize().height * heightFactor;
            newDialog.setSize(max.width, Math.min((int)scaledHeight, max.height));
        }
        if (location != null) {
            newDialog.setLocation(location);
        } else {
            newDialog.setLocationRelativeTo(target);
        }
        newDialog.setVisible(true);
    }

    public static int getNavHeight() {
        return ScreenResource.target.getSize().height / 5;
    }

    private static synchronized JDialog getAvailableDialog() {
        for (JDialog dialog : dialogPool) {
            if (dialog.isVisible()) continue;
            return dialog;
        }
        JDialog newDialog = new JDialog((Frame)target, true);
        JComponent cp = (JComponent)newDialog.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBorder(new BevelBorder(0));
        newDialog.setName("Dialog");
        newDialog.setUndecorated(true);
        newDialog.setDefaultCloseOperation(0);
        dialogPool.add(newDialog);
        return newDialog;
    }

    private static synchronized JDialog getBaseDialog() {
        if (baseDialog == null) {
            baseDialog = new JDialog((Frame)target, true);
            JComponent cp = (JComponent)baseDialog.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.setBorder(new BevelBorder(0));
            baseDialog.setName("Dialog");
            baseDialog.setUndecorated(true);
            baseDialog.setDefaultCloseOperation(0);
            dialogPool.add(baseDialog);
        }
        return baseDialog;
    }

    public static boolean isShowing(JComponent toCheck) {
        return dialogMap.containsKey(toCheck);
    }

    public static synchronized void stopWindow(JComponent toStop) {
        if (!ScreenResource.isShowing(toStop)) {
            return;
        }
        JDialog hideDialog = dialogMap.remove(toStop);
        hideDialog.getContentPane().remove(toStop);
        hideDialog.validate();
        hideDialog.update(hideDialog.getGraphics());
        hideDialog.setVisible(false);
        if (dialogMap.isEmpty() && glass != null) {
            glass.setGreyOverlayShowing(false);
        }
        if (UIActionLogger.getInstance() != null) {
            UIActionLogger.getInstance().dialogStopped();
        }
        if (dialogPool.size() > 1) {
            dialogPool.remove(hideDialog);
        }
    }

    public static synchronized void stopAllPopoutWindows() {
        for (JComponent comp : dialogMap.keySet()) {
            ScreenResource.stopWindow(comp);
        }
    }

    public static AbstractScreen getScreen() {
        return currentScreen;
    }

    public static boolean isDialogShowing() {
        return !dialogMap.isEmpty();
    }

    public static Collection<JDialog> getDialogs() {
        return new ArrayList<JDialog>(dialogMap.values());
    }

    public static synchronized void startModal() {
        defaultCondition.setModal(true);
        try {
            ScreenResource.waitOnModal(defaultCondition);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.info("Interrupted while waiting", (Throwable)e);
            ScreenResource.stopModal();
        }
    }

    public static synchronized void stopModal() {
        defaultCondition.setModal(false);
    }

    private static synchronized void waitOnModal(Component waitComponent) throws InterruptedException {
        if (waitComponent.isVisible() && !waitComponent.isShowing()) {
            for (Container parent = waitComponent.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.isVisible()) continue;
                parent.setVisible(true);
            }
        }
        ScreenResource.waitOnModal(new ComponentModalCondition(waitComponent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitOnModal(ModalCondition condition) throws InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            EventQueue theQueue = target.getToolkit().getSystemEventQueue();
            while (condition.isModal()) {
                try {
                    AWTEvent event = theQueue.getNextEvent();
                    Object src = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (src instanceof Component) {
                        ((Component)src).dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        ((MenuComponent)src).dispatchEvent(event);
                        continue;
                    }
                    OrderMate.LOG.error("unable to dispatch event: " + event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            while (condition.isModal()) {
                Object object = modalWait;
                synchronized (object) {
                    modalWait.wait();
                }
            }
        }
    }

    public static void addToOverlay(Component comp) {
        if (!glass.isAncestorOf(comp)) {
            glass.add(comp);
        }
    }

    public static void removeFromOverlay(Component comp) {
        glass.remove(comp);
    }

    public static void accountChanged(Account account, User user) {
        NotificationManager.getInstance().notifyAccountChanged.emit((Object)account, (Object)user);
    }

    public static void setMenu(ScreenResourceMenu newMenu) {
        if (menu != null) {
            target.remove(menu);
        }
        menu = newMenu;
        target.add((Component)newMenu, "North");
    }

    public static void setMainPanelLayout(LayoutManager layoutMgr) {
        mainPanel.setLayout(layoutMgr);
    }

    public static void showMenu(boolean show) {
        if (menu != null) {
            menu.setVisible(show);
        }
    }

    public static int getMenuHeight() {
        return menu != null && menu.isVisible() ? menu.getHeight() : 0;
    }

    public static Dimension getMaxDialogDimension() {
        return ScreenResource.getScreenSizeByFactor(0.85);
    }

    private static Dimension getScreenSizeByFactor(double factor) {
        Dimension screen = null;
        screen = target == null ? Toolkit.getDefaultToolkit().getScreenSize() : ScreenResource.getTarget().getSize();
        Dimension dim = new Dimension((int)((double)screen.width * factor), (int)((double)screen.height * factor));
        return dim;
    }

    static {
        mainPanel = new JPanel();
        dialogMap = new LinkedHashMap<JComponent, JDialog>();
        dialogPool = new ArrayList<JDialog>();
        modalWait = new Object();
        consumeMouseEvents = false;
        greyoverLatched = false;
        defaultCondition = new DefaultModalCondition();
    }

    static class DroppingQueue
    extends EventQueue {
        private JFrame target;
        private boolean dropping = false;

        DroppingQueue(JFrame target) {
            this.target = target;
        }

        public void pause() {
            this.dropping = true;
            OrderMate.LOG.info("Consuming.");
        }

        public void resume() {
            this.dropping = false;
            OrderMate.LOG.info("Resuming.");
        }

        @Override
        protected void dispatchEvent(AWTEvent event) {
            if (event instanceof MouseEvent && event.getID() == 501 && this.dropping && event.getSource() instanceof JFrame && ((JFrame)event.getSource()).getRootPane() == this.target.getRootPane()) {
                OrderMate.LOG.info("Event Consumed");
                return;
            }
            super.dispatchEvent(event);
        }
    }

    public static class GlassPanel
    extends JPanel {
        private static final Color NORMAL = new Color(255, 255, 255, 0);
        private static final Color DIALOG = new Color(0, 0, 0, 128);
        private boolean doGrey = true;
        private Animator currentAnim;

        public GlassPanel() {
            this.setLayout(null);
            this.setOpaque(false);
            this.setBackground(NORMAL);
            this.doGrey = SystemProperty.getInstance().isFadeBackground();
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.getBackground().getAlpha() > 1) {
                greyoverLatched = true;
                g.setColor(this.getBackground());
                Rectangle clip = g.getClipBounds();
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
            } else if (greyoverLatched) {
                greyoverLatched = false;
                if (consumeMouseEvents) {
                    // empty if block
                }
            }
            super.paintComponent(g);
        }

        public void setGreyOverlayShowing(boolean showing) {
            if (!this.doGrey) {
                return;
            }
            this.setVisible(true);
            if (showing) {
                if (this.currentAnim != null) {
                    this.currentAnim.stop();
                }
                this.currentAnim = PropertySetter.createAnimator((int)250, (Object)this, (String)"background", (Object[])new Color[]{this.getBackground(), DIALOG});
                this.currentAnim.start();
            } else {
                if (this.currentAnim != null) {
                    this.currentAnim.stop();
                }
                this.setBackground(NORMAL);
            }
        }
    }

    private static class DefaultModalCondition
    implements ModalCondition {
        private boolean modal;

        private DefaultModalCondition() {
        }

        public void setModal(boolean isModal) {
            this.modal = isModal;
        }

        @Override
        public boolean isModal() {
            return this.modal;
        }
    }

    private static class ComponentModalCondition
    implements ModalCondition {
        private Component component;

        public ComponentModalCondition(Component theComponent) {
            this.component = theComponent;
        }

        @Override
        public boolean isModal() {
            return this.component.isShowing();
        }
    }
}

