/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import ordermate.OrderMate;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class SignalEmittingTimer {
    private static final int ONE_SECOND = 1000;
    private Timer initialDelayTimer;
    private PopupWindow theWindow;
    private final Signal hiddenSignal;

    public SignalEmittingTimer(int delayInSec, final int countDownInSec, AbstractScreen screen, final Signal toEmit, final String message, final String positiveAction) {
        this.hiddenSignal = screen.hidden;
        if (countDownInSec == 0 && delayInSec == 0) {
            return;
        }
        if (countDownInSec == 0 || delayInSec == 0) {
            OrderMate.LOG.warn("Attempt to construct a signal emitting timer with zero countdown or zero delay");
            return;
        }
        if (!screen.isDisplaying()) {
            return;
        }
        this.hiddenSignal.connect((Object)this, "stop");
        this.initialDelayTimer = new Timer(delayInSec * 1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SignalEmittingTimer.this.doAction(countDownInSec, toEmit, message, positiveAction);
            }
        });
        this.initialDelayTimer.setRepeats(false);
        this.initialDelayTimer.start();
    }

    protected void doAction(int countDownInSec, Signal toEmit, String message, String positiveAction) {
        CancelableTimerPanel timerPanel = new CancelableTimerPanel(message, countDownInSec, toEmit);
        this.theWindow = Dialogs.createDialog(timerPanel, message, positiveAction, null, true, false, true);
        this.theWindow.getNavBar().ok.connect((Object)timerPanel, "gotUserOk");
        if (!ScreenResource.isDialogShowing()) {
            this.theWindow.start();
        }
    }

    public void stop() {
        if (this.initialDelayTimer != null) {
            this.initialDelayTimer.stop();
        }
        this.hiddenSignal.disconnect((Object)this);
    }

    private class CancelableTimerPanel
    extends JPanel {
        JLabel theLabel = new JLabel();
        final Timer countDownTimer;
        int currentCountdown;
        private final Signal toEmit;

        private CancelableTimerPanel(final String msg, int countDownFrom, Signal emit) {
            this.currentCountdown = countDownFrom;
            this.theLabel.setText(this.formatMessage(msg));
            this.add(this.theLabel);
            this.toEmit = emit;
            this.countDownTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    --CancelableTimerPanel.this.currentCountdown;
                    if (CancelableTimerPanel.this.currentCountdown >= 0) {
                        CancelableTimerPanel.this.theLabel.setText(CancelableTimerPanel.this.formatMessage(msg));
                    } else {
                        CancelableTimerPanel.this.countDownTimer.stop();
                        if (ScreenResource.isShowing(SignalEmittingTimer.this.theWindow)) {
                            SignalEmittingTimer.this.theWindow.gotOk();
                            CancelableTimerPanel.this.setVisible(false);
                            CancelableTimerPanel.this.toEmit.emit();
                        }
                    }
                }
            });
            this.countDownTimer.start();
        }

        private String formatMessage(String msg) {
            return "<HTML>" + msg + " " + Internationalization.getLiteralFor((String)"IN") + " <b>" + this.currentCountdown + " " + Internationalization.getLiteralFor((String)"SECONDS") + "</b></html>";
        }

        public void gotUserOk() {
            this.toEmit.emit();
            this.countDownTimer.stop();
        }
    }
}

