/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import au.com.ordermate.OrderMateLog;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ordermate.database.hardware.Terminal;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.modify.ComponentListener;
import org.apache.logging.log4j.core.Logger;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.dialogs.PopupWindow;

public final class UIActionLogger
implements ComponentListener,
ActionListener,
ChangeListener {
    private static UIActionLogger instance;
    private Logger log;

    public static UIActionLogger init() {
        if (instance == null) {
            instance = new UIActionLogger();
        }
        return instance;
    }

    public static UIActionLogger getInstance() {
        return instance;
    }

    private UIActionLogger() {
        String name = "Actions-" + Terminal.getLocalHost().getLabel();
        String baseDirectory = System.getProperty("log.root") + "Waitermate\\";
        this.log = OrderMateLog.createLogger((String)baseDirectory, (String)name, (String)"%d{HH:mm:ss.SSS} %m%n");
    }

    public void componentAdded(Component comp) {
        if (comp instanceof JPanel) {
            this.log.info("blip");
            if (!comp.isDisplayable()) {
                return;
            }
            if (comp.getName() != null) {
                this.log.info(comp.getName() + " shown");
            } else {
                Container parent;
                for (parent = comp.getParent(); parent != null && parent.getName() != null; parent = parent.getParent()) {
                }
                if (parent != null) {
                    if (parent instanceof JDialog) {
                        this.log.info(parent.hashCode() + " " + parent.getName() + " window shown");
                    } else if (parent instanceof PopupWindow) {
                        if (((PopupWindow)parent).getNavBar() != null) {
                            this.log.info(parent.hashCode() + " " + parent.getName() + " " + ((PopupWindow)parent).getNavBar().getText() + " popup shown");
                        } else {
                            this.log.info(parent.hashCode() + " " + parent.getName() + " popup shown");
                        }
                    } else if (parent.getName() != null) {
                        this.log.info(parent.getName() + " shown");
                    }
                }
            }
        } else if (comp instanceof AbstractButton) {
            ActionListener[] actionListeners;
            Keypad keypad;
            if (comp.getName() == null || !comp.getName().startsWith("NumKeypad") || comp.getParent() == null || !(comp.getParent() instanceof Keypad) || "loginKeypad".equals((keypad = (Keypad)comp.getParent()).getName())) {
                // empty if block
            }
            if ((actionListeners = ((AbstractButton)comp).getActionListeners()).length == 0) {
                ((AbstractButton)comp).addActionListener(this);
            } else {
                boolean found = false;
                for (ActionListener listener : actionListeners) {
                    if (listener != this) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ((AbstractButton)comp).addActionListener(this);
                }
            }
        } else if (comp instanceof JTabbedPane) {
            ((JTabbedPane)comp).addChangeListener(this);
        }
    }

    public void componentRemoved(Component comp) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton but = (AbstractButton)e.getSource();
        if (but.getTopLevelAncestor() instanceof JDialog || but.getTopLevelAncestor() == null) {
            this.log.info(((AbstractButton)e.getSource()).getName() + " : " + but.getText() + " pressed in Dialog");
        } else {
            this.log.info(((AbstractButton)e.getSource()).getName() + " : " + but.getText() + " pressed");
        }
    }

    public void screenChanging(AbstractScreen currentScreen) {
        this.log.info("Starting " + currentScreen.getName());
    }

    public void screenChanged(AbstractScreen currentScreen) {
        this.log.info("Started " + currentScreen.getName());
    }

    public void dialogStarted(AbstractScreen currentScreen) {
        this.log.info("Dialog started " + currentScreen.getName());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.log.info(((JTabbedPane)e.getSource()).getName() + "  Tab Selected, Index " + ((JTabbedPane)e.getSource()).getSelectedIndex());
    }

    public void dialogStopped() {
        this.log.info("Dialog stopped");
    }
}

